/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.Curve;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CurveCurve")
@ImplementedBy(value=Default.class)
public interface CurveCurve
extends Validator<Curve> {
    public static final String NAME = "CurveCurve";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements CurveCurve {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Curve curve) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CurveCurve {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Curve curve) {
            ComparisonResult result = this.executeDataRule(curve);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CurveCurve.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Curve", (RosettaPath)path, (String)CurveCurve.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CurveCurve.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Curve", (RosettaPath)path, (String)CurveCurve.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Curve curve) {
            try {
                return ExpressionOperatorsNullSafe.choice((Mapper)MapperS.of((Object)curve), Arrays.asList("interestRateCurve", "commodityCurve"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

