/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.math.NumberRange;
import cdm.observable.asset.DividendApplicability;
import cdm.observable.asset.Price;
import cdm.observable.common.DeterminationMethodEnum;
import cdm.product.asset.EquityUnderlierProvisions;
import cdm.product.asset.ReturnTermsBase;
import cdm.product.asset.ValuationTerms;
import cdm.product.asset.meta.CorrelationReturnTermsMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CorrelationReturnTerms", builder=CorrelationReturnTermsBuilderImpl.class, version="5.32.0")
@RuneDataType(value="CorrelationReturnTerms", model="cdm", builder=CorrelationReturnTermsBuilderImpl.class, version="5.32.0")
public interface CorrelationReturnTerms
extends ReturnTermsBase {
    public static final CorrelationReturnTermsMeta metaData = new CorrelationReturnTermsMeta();

    public Price getCorrelationStrikePrice();

    public NumberRange getBoundedCorrelation();

    public Integer getNumberOfDataSeries();

    @Override
    public CorrelationReturnTerms build();

    @Override
    public CorrelationReturnTermsBuilder toBuilder();

    public static CorrelationReturnTermsBuilder builder() {
        return new CorrelationReturnTermsBuilderImpl();
    }

    default public RosettaMetaData<? extends CorrelationReturnTerms> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CorrelationReturnTerms> getType() {
        return CorrelationReturnTerms.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("valuationTerms"), processor, ValuationTerms.class, this.getValuationTerms(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("annualizationFactor"), Integer.class, (Object)this.getAnnualizationFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendApplicability"), processor, DividendApplicability.class, this.getDividendApplicability(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityUnderlierProvisions"), processor, EquityUnderlierProvisions.class, this.getEquityUnderlierProvisions(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sharePriceDividendAdjustment"), Boolean.class, (Object)this.getSharePriceDividendAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedN"), Integer.class, (Object)this.getExpectedN(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialLevel"), BigDecimal.class, (Object)this.getInitialLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialLevelSource"), DeterminationMethodEnum.class, (Object)this.getInitialLevelSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("meanAdjustment"), Boolean.class, (Object)this.getMeanAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("performance"), String.class, (Object)this.getPerformance(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationStrikePrice"), processor, Price.class, this.getCorrelationStrikePrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("boundedCorrelation"), processor, NumberRange.class, this.getBoundedCorrelation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberOfDataSeries"), Integer.class, (Object)this.getNumberOfDataSeries(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CorrelationReturnTermsBuilderImpl
    extends ReturnTermsBase.ReturnTermsBaseBuilderImpl
    implements CorrelationReturnTermsBuilder {
        protected Price.PriceBuilder correlationStrikePrice;
        protected NumberRange.NumberRangeBuilder boundedCorrelation;
        protected Integer numberOfDataSeries;

        @Override
        @RosettaAttribute(value="correlationStrikePrice", isRequired=true)
        @RuneAttribute(value="correlationStrikePrice", isRequired=true)
        public Price.PriceBuilder getCorrelationStrikePrice() {
            return this.correlationStrikePrice;
        }

        @Override
        public Price.PriceBuilder getOrCreateCorrelationStrikePrice() {
            Price.PriceBuilder result = this.correlationStrikePrice != null ? this.correlationStrikePrice : (this.correlationStrikePrice = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="boundedCorrelation")
        @RuneAttribute(value="boundedCorrelation")
        public NumberRange.NumberRangeBuilder getBoundedCorrelation() {
            return this.boundedCorrelation;
        }

        @Override
        public NumberRange.NumberRangeBuilder getOrCreateBoundedCorrelation() {
            NumberRange.NumberRangeBuilder result = this.boundedCorrelation != null ? this.boundedCorrelation : (this.boundedCorrelation = NumberRange.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="numberOfDataSeries")
        @RuneAttribute(value="numberOfDataSeries")
        public Integer getNumberOfDataSeries() {
            return this.numberOfDataSeries;
        }

        @Override
        @RosettaAttribute(value="valuationTerms", isRequired=true)
        @RuneAttribute(value="valuationTerms", isRequired=true)
        public CorrelationReturnTermsBuilder setValuationTerms(ValuationTerms _valuationTerms) {
            this.valuationTerms = _valuationTerms == null ? null : _valuationTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="annualizationFactor")
        @RuneAttribute(value="annualizationFactor")
        public CorrelationReturnTermsBuilder setAnnualizationFactor(Integer _annualizationFactor) {
            this.annualizationFactor = _annualizationFactor == null ? null : _annualizationFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendApplicability")
        @RuneAttribute(value="dividendApplicability")
        public CorrelationReturnTermsBuilder setDividendApplicability(DividendApplicability _dividendApplicability) {
            this.dividendApplicability = _dividendApplicability == null ? null : _dividendApplicability.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityUnderlierProvisions")
        @RuneAttribute(value="equityUnderlierProvisions")
        public CorrelationReturnTermsBuilder setEquityUnderlierProvisions(EquityUnderlierProvisions _equityUnderlierProvisions) {
            this.equityUnderlierProvisions = _equityUnderlierProvisions == null ? null : _equityUnderlierProvisions.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="sharePriceDividendAdjustment")
        @RuneAttribute(value="sharePriceDividendAdjustment")
        public CorrelationReturnTermsBuilder setSharePriceDividendAdjustment(Boolean _sharePriceDividendAdjustment) {
            this.sharePriceDividendAdjustment = _sharePriceDividendAdjustment == null ? null : _sharePriceDividendAdjustment;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedN", isRequired=true)
        @RuneAttribute(value="expectedN", isRequired=true)
        public CorrelationReturnTermsBuilder setExpectedN(Integer _expectedN) {
            this.expectedN = _expectedN == null ? null : _expectedN;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialLevel")
        @RuneAttribute(value="initialLevel")
        public CorrelationReturnTermsBuilder setInitialLevel(BigDecimal _initialLevel) {
            this.initialLevel = _initialLevel == null ? null : _initialLevel;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialLevelSource")
        @RuneAttribute(value="initialLevelSource")
        public CorrelationReturnTermsBuilder setInitialLevelSource(DeterminationMethodEnum _initialLevelSource) {
            this.initialLevelSource = _initialLevelSource == null ? null : _initialLevelSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="meanAdjustment")
        @RuneAttribute(value="meanAdjustment")
        public CorrelationReturnTermsBuilder setMeanAdjustment(Boolean _meanAdjustment) {
            this.meanAdjustment = _meanAdjustment == null ? null : _meanAdjustment;
            return this;
        }

        @Override
        @RosettaAttribute(value="performance")
        @RuneAttribute(value="performance")
        public CorrelationReturnTermsBuilder setPerformance(String _performance) {
            this.performance = _performance == null ? null : _performance;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationStrikePrice", isRequired=true)
        @RuneAttribute(value="correlationStrikePrice", isRequired=true)
        public CorrelationReturnTermsBuilder setCorrelationStrikePrice(Price _correlationStrikePrice) {
            this.correlationStrikePrice = _correlationStrikePrice == null ? null : _correlationStrikePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="boundedCorrelation")
        @RuneAttribute(value="boundedCorrelation")
        public CorrelationReturnTermsBuilder setBoundedCorrelation(NumberRange _boundedCorrelation) {
            this.boundedCorrelation = _boundedCorrelation == null ? null : _boundedCorrelation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="numberOfDataSeries")
        @RuneAttribute(value="numberOfDataSeries")
        public CorrelationReturnTermsBuilder setNumberOfDataSeries(Integer _numberOfDataSeries) {
            this.numberOfDataSeries = _numberOfDataSeries == null ? null : _numberOfDataSeries;
            return this;
        }

        @Override
        public CorrelationReturnTerms build() {
            return new CorrelationReturnTermsImpl(this);
        }

        @Override
        public CorrelationReturnTermsBuilder toBuilder() {
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder prune() {
            super.prune();
            if (this.correlationStrikePrice != null && !this.correlationStrikePrice.prune().hasData()) {
                this.correlationStrikePrice = null;
            }
            if (this.boundedCorrelation != null && !this.boundedCorrelation.prune().hasData()) {
                this.boundedCorrelation = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCorrelationStrikePrice() != null && this.getCorrelationStrikePrice().hasData()) {
                return true;
            }
            if (this.getBoundedCorrelation() != null && this.getBoundedCorrelation().hasData()) {
                return true;
            }
            return this.getNumberOfDataSeries() != null;
        }

        @Override
        public CorrelationReturnTermsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CorrelationReturnTermsBuilder o = (CorrelationReturnTermsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCorrelationStrikePrice(), (RosettaModelObjectBuilder)o.getCorrelationStrikePrice(), this::setCorrelationStrikePrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBoundedCorrelation(), (RosettaModelObjectBuilder)o.getBoundedCorrelation(), this::setBoundedCorrelation);
            merger.mergeBasic((Object)this.getNumberOfDataSeries(), (Object)o.getNumberOfDataSeries(), this::setNumberOfDataSeries, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CorrelationReturnTerms _that = (CorrelationReturnTerms)this.getType().cast(o);
            if (!Objects.equals(this.correlationStrikePrice, _that.getCorrelationStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.boundedCorrelation, _that.getBoundedCorrelation())) {
                return false;
            }
            return Objects.equals(this.numberOfDataSeries, _that.getNumberOfDataSeries());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.correlationStrikePrice != null ? this.correlationStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.boundedCorrelation != null ? this.boundedCorrelation.hashCode() : 0);
            _result = 31 * _result + (this.numberOfDataSeries != null ? this.numberOfDataSeries.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CorrelationReturnTermsBuilder {correlationStrikePrice=" + this.correlationStrikePrice + ", boundedCorrelation=" + this.boundedCorrelation + ", numberOfDataSeries=" + this.numberOfDataSeries + '}' + " " + super.toString();
        }
    }

    public static interface CorrelationReturnTermsBuilder
    extends CorrelationReturnTerms,
    ReturnTermsBase.ReturnTermsBaseBuilder {
        public Price.PriceBuilder getOrCreateCorrelationStrikePrice();

        @Override
        public Price.PriceBuilder getCorrelationStrikePrice();

        public NumberRange.NumberRangeBuilder getOrCreateBoundedCorrelation();

        @Override
        public NumberRange.NumberRangeBuilder getBoundedCorrelation();

        @Override
        public CorrelationReturnTermsBuilder setValuationTerms(ValuationTerms var1);

        @Override
        public CorrelationReturnTermsBuilder setAnnualizationFactor(Integer var1);

        @Override
        public CorrelationReturnTermsBuilder setDividendApplicability(DividendApplicability var1);

        @Override
        public CorrelationReturnTermsBuilder setEquityUnderlierProvisions(EquityUnderlierProvisions var1);

        @Override
        public CorrelationReturnTermsBuilder setSharePriceDividendAdjustment(Boolean var1);

        @Override
        public CorrelationReturnTermsBuilder setExpectedN(Integer var1);

        @Override
        public CorrelationReturnTermsBuilder setInitialLevel(BigDecimal var1);

        @Override
        public CorrelationReturnTermsBuilder setInitialLevelSource(DeterminationMethodEnum var1);

        @Override
        public CorrelationReturnTermsBuilder setMeanAdjustment(Boolean var1);

        @Override
        public CorrelationReturnTermsBuilder setPerformance(String var1);

        public CorrelationReturnTermsBuilder setCorrelationStrikePrice(Price var1);

        public CorrelationReturnTermsBuilder setBoundedCorrelation(NumberRange var1);

        public CorrelationReturnTermsBuilder setNumberOfDataSeries(Integer var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("valuationTerms"), processor, ValuationTerms.ValuationTermsBuilder.class, (RosettaModelObjectBuilder)this.getValuationTerms(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("annualizationFactor"), Integer.class, (Object)this.getAnnualizationFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendApplicability"), processor, DividendApplicability.DividendApplicabilityBuilder.class, (RosettaModelObjectBuilder)this.getDividendApplicability(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityUnderlierProvisions"), processor, EquityUnderlierProvisions.EquityUnderlierProvisionsBuilder.class, (RosettaModelObjectBuilder)this.getEquityUnderlierProvisions(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sharePriceDividendAdjustment"), Boolean.class, (Object)this.getSharePriceDividendAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedN"), Integer.class, (Object)this.getExpectedN(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialLevel"), BigDecimal.class, (Object)this.getInitialLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialLevelSource"), DeterminationMethodEnum.class, (Object)this.getInitialLevelSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("meanAdjustment"), Boolean.class, (Object)this.getMeanAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("performance"), String.class, (Object)this.getPerformance(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationStrikePrice"), processor, Price.PriceBuilder.class, this.getCorrelationStrikePrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("boundedCorrelation"), processor, NumberRange.NumberRangeBuilder.class, this.getBoundedCorrelation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberOfDataSeries"), Integer.class, (Object)this.getNumberOfDataSeries(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CorrelationReturnTermsBuilder prune();
    }

    public static class CorrelationReturnTermsImpl
    extends ReturnTermsBase.ReturnTermsBaseImpl
    implements CorrelationReturnTerms {
        private final Price correlationStrikePrice;
        private final NumberRange boundedCorrelation;
        private final Integer numberOfDataSeries;

        protected CorrelationReturnTermsImpl(CorrelationReturnTermsBuilder builder) {
            super(builder);
            this.correlationStrikePrice = Optional.ofNullable(builder.getCorrelationStrikePrice()).map(f -> f.build()).orElse(null);
            this.boundedCorrelation = Optional.ofNullable(builder.getBoundedCorrelation()).map(f -> f.build()).orElse(null);
            this.numberOfDataSeries = builder.getNumberOfDataSeries();
        }

        @Override
        @RosettaAttribute(value="correlationStrikePrice", isRequired=true)
        @RuneAttribute(value="correlationStrikePrice", isRequired=true)
        public Price getCorrelationStrikePrice() {
            return this.correlationStrikePrice;
        }

        @Override
        @RosettaAttribute(value="boundedCorrelation")
        @RuneAttribute(value="boundedCorrelation")
        public NumberRange getBoundedCorrelation() {
            return this.boundedCorrelation;
        }

        @Override
        @RosettaAttribute(value="numberOfDataSeries")
        @RuneAttribute(value="numberOfDataSeries")
        public Integer getNumberOfDataSeries() {
            return this.numberOfDataSeries;
        }

        @Override
        public CorrelationReturnTerms build() {
            return this;
        }

        @Override
        public CorrelationReturnTermsBuilder toBuilder() {
            CorrelationReturnTermsBuilder builder = CorrelationReturnTerms.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CorrelationReturnTermsBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCorrelationStrikePrice()).ifPresent(builder::setCorrelationStrikePrice);
            Optional.ofNullable(this.getBoundedCorrelation()).ifPresent(builder::setBoundedCorrelation);
            Optional.ofNullable(this.getNumberOfDataSeries()).ifPresent(builder::setNumberOfDataSeries);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CorrelationReturnTerms _that = (CorrelationReturnTerms)this.getType().cast(o);
            if (!Objects.equals(this.correlationStrikePrice, _that.getCorrelationStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.boundedCorrelation, _that.getBoundedCorrelation())) {
                return false;
            }
            return Objects.equals(this.numberOfDataSeries, _that.getNumberOfDataSeries());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.correlationStrikePrice != null ? this.correlationStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.boundedCorrelation != null ? this.boundedCorrelation.hashCode() : 0);
            _result = 31 * _result + (this.numberOfDataSeries != null ? this.numberOfDataSeries.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CorrelationReturnTerms {correlationStrikePrice=" + this.correlationStrikePrice + ", boundedCorrelation=" + this.boundedCorrelation + ", numberOfDataSeries=" + this.numberOfDataSeries + '}' + " " + super.toString();
        }
    }
}

