/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.calculation.functions;

import cdm.observable.asset.Money;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.calculation.functions.CalculateFloatingCashFlow;
import cdm.product.asset.calculation.functions.DefaultFloatingRate;
import cdm.product.asset.calculation.functions.GetNotionalAmount;
import cdm.product.asset.floatingrate.FloatingAmountCalculationDetails;
import cdm.product.asset.floatingrate.FloatingRateProcessingDetails;
import cdm.product.asset.floatingrate.FloatingRateProcessingParameters;
import cdm.product.asset.floatingrate.FloatingRateSettingDetails;
import cdm.product.asset.floatingrate.functions.ApplyFloatingRateProcessing;
import cdm.product.asset.floatingrate.functions.GetFloatingRateProcessingParameters;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ApplyFloatingRateSettingDefault.class)
public abstract class ApplyFloatingRateSetting
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ApplyFloatingRateProcessing applyFloatingRateProcessing;
    @Inject
    protected CalculateFloatingCashFlow calculateFloatingCashFlow;
    @Inject
    protected DefaultFloatingRate defaultFloatingRate;
    @Inject
    protected GetFloatingRateProcessingParameters getFloatingRateProcessingParameters;
    @Inject
    protected GetNotionalAmount getNotionalAmount;

    public FloatingAmountCalculationDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
        FloatingAmountCalculationDetails result;
        FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder resultBuilder = this.doEvaluate(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting);
        if (resultBuilder == null) {
            result = null;
        } else {
            result = resultBuilder.build();
            this.objectValidator.validate(FloatingAmountCalculationDetails.class, (RosettaModelObject)result);
        }
        return result;
    }

    protected abstract FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5, FloatingRateSettingDetails var6);

    protected abstract MapperS<BigDecimal> floatingRate(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5, FloatingRateSettingDetails var6);

    protected abstract MapperS<? extends FloatingRateProcessingParameters> processingParameters(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5, FloatingRateSettingDetails var6);

    protected abstract MapperS<? extends FloatingRateProcessingDetails> processedRateDetails(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5, FloatingRateSettingDetails var6);

    protected abstract MapperS<? extends Money> periodNotional(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5, FloatingRateSettingDetails var6);

    protected abstract MapperS<BigDecimal> notional(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5, FloatingRateSettingDetails var6);

    protected abstract MapperS<? extends FieldWithMetaString> currency(InterestRatePayout var1, CalculationPeriodBase var2, Boolean var3, BigDecimal var4, BigDecimal var5, FloatingRateSettingDetails var6);

    public static class ApplyFloatingRateSettingDefault
    extends ApplyFloatingRateSetting {
        @Override
        protected FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result = FloatingAmountCalculationDetails.builder();
            return this.assignOutput(result, interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting);
        }

        protected FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder assignOutput(FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder result, InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)this.currency(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting).get();
            result = (FloatingAmountCalculationDetails.FloatingAmountCalculationDetailsBuilder)this.toBuilder(this.calculateFloatingCashFlow.evaluate(interestRatePayout, calculationPeriod, (BigDecimal)this.notional(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting).get(), fieldWithMetaString == null ? null : fieldWithMetaString.getValue(), floatingRateSetting, (FloatingRateProcessingDetails)this.processedRateDetails(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting).get()));
            return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<BigDecimal> floatingRate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            return MapperS.of((Object)floatingRateSetting).map("getFloatingRate", floatingRateSettingDetails -> floatingRateSettingDetails.getFloatingRate());
        }

        @Override
        protected MapperS<? extends FloatingRateProcessingParameters> processingParameters(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            return MapperS.of((Object)this.getFloatingRateProcessingParameters.evaluate(interestRatePayout, calculationPeriod));
        }

        @Override
        protected MapperS<? extends FloatingRateProcessingDetails> processedRateDetails(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)suppliedRate)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.defaultFloatingRate.evaluate(suppliedRate));
            }
            return MapperS.of((Object)this.applyFloatingRateProcessing.evaluate((FloatingRateProcessingParameters)this.processingParameters(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting).get(), (BigDecimal)this.floatingRate(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting).get(), calculationPeriod, isInitialPeriod));
        }

        @Override
        protected MapperS<? extends Money> periodNotional(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            return MapperS.of((Object)this.getNotionalAmount.evaluate(interestRatePayout, calculationPeriod));
        }

        @Override
        protected MapperS<BigDecimal> notional(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)suppliedNotional)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)suppliedNotional);
            }
            return this.periodNotional(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting).map("getValue", money -> money.getValue());
        }

        @Override
        protected MapperS<? extends FieldWithMetaString> currency(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, Boolean isInitialPeriod, BigDecimal suppliedNotional, BigDecimal suppliedRate, FloatingRateSettingDetails floatingRateSetting) {
            return this.periodNotional(interestRatePayout, calculationPeriod, isInitialPeriod, suppliedNotional, suppliedRate, floatingRateSetting).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
        }
    }
}

