/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.floatingrate.functions.GetRateScheduleAmount;
import cdm.product.common.schedule.CalculationPeriodBase;
import cdm.product.common.schedule.RateSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=FloorRateAmountDefault.class)
public abstract class FloorRateAmount
implements RosettaFunction {
    @Inject
    protected GetRateScheduleAmount getRateScheduleAmount;

    public BigDecimal evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
        BigDecimal floorRate = this.doEvaluate(interestRatePayout, calculationPeriod);
        return floorRate;
    }

    protected abstract BigDecimal doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2);

    public static class FloorRateAmountDefault
    extends FloorRateAmount {
        @Override
        protected BigDecimal doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            BigDecimal floorRate = null;
            return this.assignOutput(floorRate, interestRatePayout, calculationPeriod);
        }

        protected BigDecimal assignOutput(BigDecimal floorRate, InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod) {
            floorRate = this.getRateScheduleAmount.evaluate((RateSchedule)MapperS.of((Object)interestRatePayout).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getFloorRateSchedule", floatingRateSpecification -> floatingRateSpecification.getFloorRateSchedule()).get(), (Date)MapperS.of((Object)calculationPeriod).map("getAdjustedStartDate", calculationPeriodBase -> calculationPeriodBase.getAdjustedStartDate()).get());
            return floorRate;
        }
    }
}

