/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.BoundedVariance;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="BoundedVarianceNonNegativeBarriers")
@ImplementedBy(value=Default.class)
public interface BoundedVarianceNonNegativeBarriers
extends Validator<BoundedVariance> {
    public static final String NAME = "BoundedVarianceNonNegativeBarriers";
    public static final String DEFINITION = "if upperBarrier exists then upperBarrier >= 0 and if lowerBarrier exists then lowerBarrier >= 0";

    public static class NoOp
    implements BoundedVarianceNonNegativeBarriers {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BoundedVariance boundedVariance) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements BoundedVarianceNonNegativeBarriers {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BoundedVariance boundedVariance) {
            ComparisonResult result = this.executeDataRule(boundedVariance);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)BoundedVarianceNonNegativeBarriers.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BoundedVariance", (RosettaPath)path, (String)BoundedVarianceNonNegativeBarriers.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)BoundedVarianceNonNegativeBarriers.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BoundedVariance", (RosettaPath)path, (String)BoundedVarianceNonNegativeBarriers.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(BoundedVariance boundedVariance) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)boundedVariance).map("getUpperBarrier", _boundedVariance -> _boundedVariance.getUpperBarrier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ComparisonResult ifThenElseResult = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)boundedVariance).map("getLowerBarrier", _boundedVariance -> _boundedVariance.getLowerBarrier())).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperatorsNullSafe.greaterThanEquals((Mapper)MapperS.of((Object)boundedVariance).map("getLowerBarrier", _boundedVariance -> _boundedVariance.getLowerBarrier()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All) : ComparisonResult.ofEmpty();
                    return ExpressionOperatorsNullSafe.greaterThanEquals((Mapper)MapperS.of((Object)boundedVariance).map("getUpperBarrier", _boundedVariance -> _boundedVariance.getUpperBarrier()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ifThenElseResult);
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

