/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.functions;

import cdm.base.staticdata.asset.common.AssetType;
import cdm.product.collateral.EligibilityQuery;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=CheckAssetTypeDefault.class)
public abstract class CheckAssetType
implements RosettaFunction {
    public Boolean evaluate(List<? extends AssetType> collateralAssetTypes, EligibilityQuery query) {
        Boolean isEqual = this.doEvaluate(collateralAssetTypes, query);
        return isEqual;
    }

    protected abstract Boolean doEvaluate(List<? extends AssetType> var1, EligibilityQuery var2);

    public static class CheckAssetTypeDefault
    extends CheckAssetType {
        @Override
        protected Boolean doEvaluate(List<? extends AssetType> collateralAssetTypes, EligibilityQuery query) {
            if (collateralAssetTypes == null) {
                collateralAssetTypes = Collections.emptyList();
            }
            Boolean isEqual = null;
            return this.assignOutput(isEqual, collateralAssetTypes, query);
        }

        protected Boolean assignOutput(Boolean isEqual, List<? extends AssetType> collateralAssetTypes, EligibilityQuery query) {
            MapperC thenArg0 = MapperC.of(collateralAssetTypes);
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getAssetType", assetType -> assetType.getAssetType()), (Mapper)MapperS.of((Object)query).map("getCollateralAssetType", eligibilityQuery -> eligibilityQuery.getCollateralAssetType()).map("getAssetType", assetType -> assetType.getAssetType()), (CardinalityOperator)CardinalityOperator.All).get());
            MapperC thenArg2 = thenArg1.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.notExists((Mapper)item.map("getDebtType", assetType -> assetType.getDebtType())).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getDebtType", assetType -> assetType.getDebtType()).map("getDebtClass", debtType -> debtType.getDebtClass()), (Mapper)MapperS.of((Object)query).map("getCollateralAssetType", eligibilityQuery -> eligibilityQuery.getCollateralAssetType()).map("getDebtType", assetType -> assetType.getDebtType()).map("getDebtClass", debtType -> debtType.getDebtClass()), (CardinalityOperator)CardinalityOperator.All)).get());
            MapperC thenArg3 = thenArg2.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.notExists((Mapper)item.map("getSecurityType", assetType -> assetType.getSecurityType())).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getSecurityType", assetType -> assetType.getSecurityType()), (Mapper)MapperS.of((Object)query).map("getCollateralAssetType", eligibilityQuery -> eligibilityQuery.getCollateralAssetType()).map("getSecurityType", assetType -> assetType.getSecurityType()), (CardinalityOperator)CardinalityOperator.All)).get());
            isEqual = ExpressionOperatorsNullSafe.notExists((Mapper)MapperC.of(collateralAssetTypes)).orNullSafe(ComparisonResult.ofNullSafe((Mapper)ExpressionOperatorsNullSafe.exists((Mapper)thenArg3).asMapper())).get();
            return isEqual;
        }
    }
}

