/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.functions;

import cdm.base.datetime.PeriodRange;
import cdm.product.collateral.EligibilityQuery;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=CheckMaturityDefault.class)
public abstract class CheckMaturity
implements RosettaFunction {
    public Boolean evaluate(PeriodRange maturityRange, EligibilityQuery query) {
        Boolean isEqual = this.doEvaluate(maturityRange, query);
        return isEqual;
    }

    protected abstract Boolean doEvaluate(PeriodRange var1, EligibilityQuery var2);

    protected abstract MapperS<Boolean> upperBoundCheck(PeriodRange var1, EligibilityQuery var2);

    protected abstract MapperS<Boolean> lowerBoundCheck(PeriodRange var1, EligibilityQuery var2);

    public static class CheckMaturityDefault
    extends CheckMaturity {
        @Override
        protected Boolean doEvaluate(PeriodRange maturityRange, EligibilityQuery query) {
            Boolean isEqual = null;
            return this.assignOutput(isEqual, maturityRange, query);
        }

        protected Boolean assignOutput(Boolean isEqual, PeriodRange maturityRange, EligibilityQuery query) {
            isEqual = ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)maturityRange)).orNullSafe(ComparisonResult.ofNullSafe(this.upperBoundCheck(maturityRange, query)).andNullSafe(ComparisonResult.ofNullSafe(this.lowerBoundCheck(maturityRange, query)))).get();
            return isEqual;
        }

        @Override
        protected MapperS<Boolean> upperBoundCheck(PeriodRange maturityRange, EligibilityQuery query) {
            if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)maturityRange).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getPeriod", periodBound -> periodBound.getPeriod())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)true);
            }
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)maturityRange).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getInclusive", periodBound -> periodBound.getInclusive())).orNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)maturityRange).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getInclusive", periodBound -> periodBound.getInclusive()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperatorsNullSafe.greaterThanEquals((Mapper)MapperS.of((Object)maturityRange).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getPeriod", periodBound -> periodBound.getPeriod()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()).map("Type coercion", integer0 -> integer0 == null ? null : BigDecimal.valueOf(integer0.intValue())), (Mapper)MapperS.of((Object)query).map("getMaturity", eligibilityQuery -> eligibilityQuery.getMaturity()), (CardinalityOperator)CardinalityOperator.All).asMapper();
            }
            return ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)maturityRange).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getPeriod", periodBound -> periodBound.getPeriod()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()).map("Type coercion", integer1 -> integer1 == null ? null : BigDecimal.valueOf(integer1.intValue())), (Mapper)MapperS.of((Object)query).map("getMaturity", eligibilityQuery -> eligibilityQuery.getMaturity()), (CardinalityOperator)CardinalityOperator.All).asMapper();
        }

        @Override
        protected MapperS<Boolean> lowerBoundCheck(PeriodRange maturityRange, EligibilityQuery query) {
            if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)maturityRange).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getPeriod", periodBound -> periodBound.getPeriod())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)true);
            }
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)maturityRange).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getInclusive", periodBound -> periodBound.getInclusive())).orNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)maturityRange).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getInclusive", periodBound -> periodBound.getInclusive()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperatorsNullSafe.lessThanEquals((Mapper)MapperS.of((Object)maturityRange).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getPeriod", periodBound -> periodBound.getPeriod()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()).map("Type coercion", integer0 -> integer0 == null ? null : BigDecimal.valueOf(integer0.intValue())), (Mapper)MapperS.of((Object)query).map("getMaturity", eligibilityQuery -> eligibilityQuery.getMaturity()), (CardinalityOperator)CardinalityOperator.All).asMapper();
            }
            return ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)maturityRange).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getPeriod", periodBound -> periodBound.getPeriod()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()).map("Type coercion", integer1 -> integer1 == null ? null : BigDecimal.valueOf(integer1.intValue())), (Mapper)MapperS.of((Object)query).map("getMaturity", eligibilityQuery -> eligibilityQuery.getMaturity()), (CardinalityOperator)CardinalityOperator.All).asMapper();
        }
    }
}

