/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule.functions;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.AdjustableDates;
import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.AdjustableRelativeOrPeriodicDates;
import cdm.base.datetime.AdjustedRelativeDateOffset;
import cdm.base.datetime.BusinessDayAdjustments;
import cdm.base.datetime.BusinessDayConventionEnum;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AdjustableDateUtils {
    public static Date adjustDate(AdjustableOrRelativeDate adjustableOrRelativeDate) {
        if (adjustableOrRelativeDate == null) {
            return null;
        }
        if (adjustableOrRelativeDate.getAdjustableDate() != null) {
            return AdjustableDateUtils.adjustDate(adjustableOrRelativeDate.getAdjustableDate());
        }
        if (adjustableOrRelativeDate.getRelativeDate() != null) {
            return AdjustableDateUtils.adjustDate(adjustableOrRelativeDate.getRelativeDate());
        }
        return null;
    }

    public static Date adjustDate(AdjustableDate adjustableDate) {
        if (adjustableDate == null) {
            return null;
        }
        if (adjustableDate.getAdjustedDate() != null) {
            return adjustableDate.getAdjustedDate().getValue();
        }
        if (adjustableDate.getUnadjustedDate() != null) {
            return AdjustableDateUtils.adjustDate(adjustableDate.getUnadjustedDate(), adjustableDate.getDateAdjustments());
        }
        return null;
    }

    public static Date adjustDate(Date unadjustedDate, BusinessDayAdjustments businessDayAdjustments) {
        if (unadjustedDate != null) {
            BusinessDayConventionEnum businessDayConvention = Optional.ofNullable(businessDayAdjustments).map(BusinessDayAdjustments::getBusinessDayConvention).orElse(BusinessDayConventionEnum.NONE);
            return Date.of((LocalDate)BusinessDayAdjustment.builder().convention(AdjustableDateUtils.toBusinessDayConvention(businessDayConvention)).calendar(HolidayCalendarIds.SAT_SUN).build().adjust(unadjustedDate.toLocalDate(), ReferenceData.minimal()));
        }
        return null;
    }

    public static Date adjustDate(AdjustedRelativeDateOffset relativeDate) {
        if (relativeDate == null) {
            return null;
        }
        if (relativeDate.getAdjustedDate() != null) {
            return relativeDate.getAdjustedDate();
        }
        return null;
    }

    public static List<Date> adjustDates(AdjustableRelativeOrPeriodicDates adjustableRelativeOrPeriodicDates) {
        if (adjustableRelativeOrPeriodicDates == null) {
            return null;
        }
        if (adjustableRelativeOrPeriodicDates.getAdjustableDates() != null) {
            AdjustableDates adjustableDates = adjustableRelativeOrPeriodicDates.getAdjustableDates();
            if (adjustableDates.getAdjustedDate() != null) {
                return adjustableDates.getAdjustedDate().stream().map(FieldWithMetaDate::getValue).collect(Collectors.toList());
            }
            if (adjustableDates.getUnadjustedDate() != null) {
                return adjustableDates.getUnadjustedDate().stream().map(unadjustedDate -> AdjustableDateUtils.adjustDate(unadjustedDate, adjustableDates.getDateAdjustments())).collect(Collectors.toList());
            }
        }
        return null;
    }

    private static BusinessDayConvention toBusinessDayConvention(BusinessDayConventionEnum businessDayConvention) {
        switch (businessDayConvention) {
            case FOLLOWING: {
                return BusinessDayConvention.of((String)"FOLLOWING");
            }
            case MODFOLLOWING: {
                return BusinessDayConvention.of((String)"MODIFIEDFOLLOWING");
            }
            case PRECEDING: {
                return BusinessDayConvention.of((String)"PRECEDING");
            }
            case MODPRECEDING: {
                return BusinessDayConvention.of((String)"MODIFIEDPRECEDING");
            }
            case NEAREST: {
                return BusinessDayConvention.of((String)"NEAREST");
            }
        }
        return BusinessDayConvention.of((String)"NOADJUST");
    }
}

