/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.processor;

import cdm.base.datetime.AdjustableDate;
import cdm.base.math.UnitType;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.legaldocumentation.contract.processor.PartyMappingHelper;
import cdm.observable.asset.Money;
import cdm.product.common.settlement.PrincipalPayment;
import cdm.product.common.settlement.PrincipalPaymentSchedule;
import cdm.product.common.settlement.PrincipalPayments;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class PrincipalPaymentScheduleMappingProcessor
extends MappingProcessor {
    public PrincipalPaymentScheduleMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder principalPaymentScheduleBuilder = (PrincipalPaymentSchedule.PrincipalPaymentScheduleBuilder)builder;
        PrincipalPayments principalPaymentParent = (PrincipalPayments)parent;
        boolean initialPayment = Optional.ofNullable(principalPaymentParent.getInitialPayment()).orElse(false);
        boolean finalPayment = Optional.ofNullable(principalPaymentParent.getFinalPayment()).orElse(false);
        LinkedList<PrincipalPayment> principalPayments = this.getPrincipalPayments(synonymPath);
        if (principalPayments.isEmpty()) {
            return;
        }
        if (initialPayment) {
            PrincipalPayment firstPrincipalPayment = principalPayments.removeFirst();
            principalPaymentScheduleBuilder.setInitialPrincipalPayment(firstPrincipalPayment);
        }
        if (principalPayments.isEmpty()) {
            return;
        }
        if (finalPayment) {
            PrincipalPayment finalPrincipalPayment = principalPayments.getLast();
            principalPaymentScheduleBuilder.setFinalPrincipalPayment(finalPrincipalPayment);
        }
    }

    private LinkedList<PrincipalPayment> getPrincipalPayments(Path synonymPath) {
        LinkedList<PrincipalPayment> principalPayments = new LinkedList<PrincipalPayment>();
        for (int i = 0; i < 2; ++i) {
            this.getPrincipalPayment(synonymPath.addElement("principalExchange", Integer.valueOf(i)), synonymPath.getParent()).ifPresent(principalPayments::add);
        }
        principalPayments.sort(Comparator.comparing(this::getAdjustedOrUnadjustedDate));
        return principalPayments;
    }

    private LocalDate getAdjustedOrUnadjustedDate(PrincipalPayment o) {
        return Optional.ofNullable(o.getPrincipalPaymentDate()).map(AdjustableDate::getAdjustedDate).map(FieldWithMetaDate::getValue).map(Date::toLocalDate).orElse(Optional.ofNullable(o.getPrincipalPaymentDate()).map(AdjustableDate::getUnadjustedDate).map(Date::toLocalDate).orElse(LocalDate.MIN));
    }

    private Optional<PrincipalPayment> getPrincipalPayment(Path principalExchangePath, Path swapStreamPath) {
        PrincipalPayment.PrincipalPaymentBuilder principalPaymentBuilder = PrincipalPayment.builder();
        this.setValueAndUpdateMappings(principalExchangePath.addElement("principalExchangeAmount"), xmlValue -> {
            BigDecimal amount = new BigDecimal((String)xmlValue);
            Money.MoneyBuilder moneyBuilder = principalPaymentBuilder.getOrCreatePrincipalAmount();
            moneyBuilder.setValue(amount.abs());
            this.setCurrency(swapStreamPath, moneyBuilder);
            this.setPayerReceiver(swapStreamPath, principalPaymentBuilder, amount);
        });
        this.setValueAndUpdateMappings(principalExchangePath.addElement("unadjustedPrincipalExchangeDate"), xmlValue -> principalPaymentBuilder.getOrCreatePrincipalPaymentDate().setUnadjustedDate(Date.parse((String)xmlValue)));
        this.setValueAndUpdateMappings(principalExchangePath.addElement("adjustedPrincipalExchangeDate"), xmlValue -> principalPaymentBuilder.getOrCreatePrincipalPaymentDate().getOrCreateAdjustedDate().setValue(Date.parse((String)xmlValue)));
        return principalPaymentBuilder.hasData() ? Optional.of(principalPaymentBuilder) : Optional.empty();
    }

    private void setCurrency(Path swapStreamPath, Money.MoneyBuilder moneyBuilder) {
        Optional settlementCurrency = MappingProcessorUtils.getNonNullMappedValue((Path)swapStreamPath.addElement("settlementProvision").addElement("settlementCurrency"), (List)this.getMappings());
        if (settlementCurrency.isPresent()) {
            moneyBuilder.setUnit(UnitType.builder().setCurrencyValue((String)settlementCurrency.get()));
            return;
        }
        Optional notionalCurrency = MappingProcessorUtils.getNonNullMappedValue((Path)swapStreamPath.addElement("calculationPeriodAmount").addElement("calculation").addElement("notionalSchedule").addElement("notionalStepSchedule").addElement("currency"), (List)this.getMappings());
        if (notionalCurrency.isPresent()) {
            moneyBuilder.setUnit(UnitType.builder().setCurrencyValue((String)notionalCurrency.get()));
            return;
        }
    }

    private void setPayerReceiver(Path swapStreamPath, PrincipalPayment.PrincipalPaymentBuilder principalPaymentBuilder, BigDecimal paymentAmount) {
        Path payerPath = swapStreamPath.addElement("payerPartyReference");
        Path receiverPath = swapStreamPath.addElement("receiverPartyReference");
        PayerReceiver.PayerReceiverBuilder payerReceiver = principalPaymentBuilder.getOrCreatePayerReceiver();
        if (paymentAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.setCounterpartyRoleEnum(payerPath, payerReceiver::setPayer);
            this.setCounterpartyRoleEnum(receiverPath, payerReceiver::setReceiver);
        } else {
            this.setCounterpartyRoleEnum(payerPath, payerReceiver::setReceiver);
            this.setCounterpartyRoleEnum(receiverPath, payerReceiver::setPayer);
        }
    }

    private void setCounterpartyRoleEnum(Path synonymPath, Consumer<CounterpartyRoleEnum> setter) {
        PartyMappingHelper.getInstance(this.getContext()).ifPresent(helper -> helper.setCounterpartyRoleEnum(this.getModelPath(), synonymPath, setter));
    }
}

