/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.observable.asset.Money;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.AssetLeg;
import cdm.product.template.DividendTerms;
import cdm.product.template.Duration;
import cdm.product.template.Product;
import cdm.product.template.meta.AssetPayoutMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AssetPayout", builder=AssetPayoutBuilderImpl.class, version="5.32.0")
@RuneDataType(value="AssetPayout", model="cdm", builder=AssetPayoutBuilderImpl.class, version="5.32.0")
public interface AssetPayout
extends PayoutBase,
GlobalKey {
    public static final AssetPayoutMeta metaData = new AssetPayoutMeta();

    public List<? extends AssetLeg> getAssetLeg();

    public Product getSecurityInformation();

    public Duration getDurationType();

    public Money getMinimumFee();

    public DividendTerms getDividendTerms();

    public MetaFields getMeta();

    @Override
    public AssetPayout build();

    @Override
    public AssetPayoutBuilder toBuilder();

    public static AssetPayoutBuilder builder() {
        return new AssetPayoutBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetPayout> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AssetPayout> getType() {
        return AssetPayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.class, this.getPrincipalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.class, this.getSettlementTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assetLeg"), processor, AssetLeg.class, this.getAssetLeg(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("securityInformation"), processor, Product.class, this.getSecurityInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("durationType"), processor, Duration.class, this.getDurationType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("minimumFee"), processor, Money.class, this.getMinimumFee(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendTerms"), processor, DividendTerms.class, this.getDividendTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class AssetPayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements AssetPayoutBuilder {
        protected List<AssetLeg.AssetLegBuilder> assetLeg = new ArrayList<AssetLeg.AssetLegBuilder>();
        protected Product.ProductBuilder securityInformation;
        protected Duration.DurationBuilder durationType;
        protected Money.MoneyBuilder minimumFee;
        protected DividendTerms.DividendTermsBuilder dividendTerms;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="assetLeg", isRequired=true)
        @RuneAttribute(value="assetLeg", isRequired=true)
        public List<? extends AssetLeg.AssetLegBuilder> getAssetLeg() {
            return this.assetLeg;
        }

        @Override
        public AssetLeg.AssetLegBuilder getOrCreateAssetLeg(int index) {
            if (this.assetLeg == null) {
                this.assetLeg = new ArrayList<AssetLeg.AssetLegBuilder>();
            }
            return (AssetLeg.AssetLegBuilder)this.getIndex(this.assetLeg, index, () -> {
                AssetLeg.AssetLegBuilder newAssetLeg = AssetLeg.builder();
                return newAssetLeg;
            });
        }

        @Override
        @RosettaAttribute(value="securityInformation", isRequired=true)
        @RuneAttribute(value="securityInformation", isRequired=true)
        public Product.ProductBuilder getSecurityInformation() {
            return this.securityInformation;
        }

        @Override
        public Product.ProductBuilder getOrCreateSecurityInformation() {
            Product.ProductBuilder result = this.securityInformation != null ? this.securityInformation : (this.securityInformation = Product.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="durationType", isRequired=true)
        @RuneAttribute(value="durationType", isRequired=true)
        public Duration.DurationBuilder getDurationType() {
            return this.durationType;
        }

        @Override
        public Duration.DurationBuilder getOrCreateDurationType() {
            Duration.DurationBuilder result = this.durationType != null ? this.durationType : (this.durationType = Duration.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="minimumFee")
        @RuneAttribute(value="minimumFee")
        public Money.MoneyBuilder getMinimumFee() {
            return this.minimumFee;
        }

        @Override
        public Money.MoneyBuilder getOrCreateMinimumFee() {
            Money.MoneyBuilder result = this.minimumFee != null ? this.minimumFee : (this.minimumFee = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dividendTerms")
        @RuneAttribute(value="dividendTerms")
        public DividendTerms.DividendTermsBuilder getDividendTerms() {
            return this.dividendTerms;
        }

        @Override
        public DividendTerms.DividendTermsBuilder getOrCreateDividendTerms() {
            DividendTerms.DividendTermsBuilder result = this.dividendTerms != null ? this.dividendTerms : (this.dividendTerms = DividendTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public AssetPayoutBuilder setPayerReceiver(PayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuantity")
        @RuneAttribute(value="priceQuantity")
        public AssetPayoutBuilder setPriceQuantity(ResolvablePriceQuantity _priceQuantity) {
            this.priceQuantity = _priceQuantity == null ? null : _priceQuantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principalPayment")
        @RuneAttribute(value="principalPayment")
        public AssetPayoutBuilder setPrincipalPayment(PrincipalPayments _principalPayment) {
            this.principalPayment = _principalPayment == null ? null : _principalPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public AssetPayoutBuilder setSettlementTerms(SettlementTerms _settlementTerms) {
            this.settlementTerms = _settlementTerms == null ? null : _settlementTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetLeg", isRequired=true)
        @RuneAttribute(value="assetLeg", isRequired=true)
        public AssetPayoutBuilder addAssetLeg(AssetLeg _assetLeg) {
            if (_assetLeg != null) {
                this.assetLeg.add(_assetLeg.toBuilder());
            }
            return this;
        }

        @Override
        public AssetPayoutBuilder addAssetLeg(AssetLeg _assetLeg, int idx) {
            this.getIndex(this.assetLeg, idx, () -> _assetLeg.toBuilder());
            return this;
        }

        @Override
        public AssetPayoutBuilder addAssetLeg(List<? extends AssetLeg> assetLegs) {
            if (assetLegs != null) {
                for (AssetLeg assetLeg : assetLegs) {
                    this.assetLeg.add(assetLeg.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="assetLeg")
        public AssetPayoutBuilder setAssetLeg(List<? extends AssetLeg> assetLegs) {
            this.assetLeg = assetLegs == null ? new ArrayList<AssetLeg.AssetLegBuilder>() : (List)assetLegs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="securityInformation", isRequired=true)
        @RuneAttribute(value="securityInformation", isRequired=true)
        public AssetPayoutBuilder setSecurityInformation(Product _securityInformation) {
            this.securityInformation = _securityInformation == null ? null : _securityInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="durationType", isRequired=true)
        @RuneAttribute(value="durationType", isRequired=true)
        public AssetPayoutBuilder setDurationType(Duration _durationType) {
            this.durationType = _durationType == null ? null : _durationType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="minimumFee")
        @RuneAttribute(value="minimumFee")
        public AssetPayoutBuilder setMinimumFee(Money _minimumFee) {
            this.minimumFee = _minimumFee == null ? null : _minimumFee.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendTerms")
        @RuneAttribute(value="dividendTerms")
        public AssetPayoutBuilder setDividendTerms(DividendTerms _dividendTerms) {
            this.dividendTerms = _dividendTerms == null ? null : _dividendTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public AssetPayoutBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public AssetPayout build() {
            return new AssetPayoutImpl(this);
        }

        @Override
        public AssetPayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetPayoutBuilder prune() {
            super.prune();
            this.assetLeg = this.assetLeg.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.securityInformation != null && !this.securityInformation.prune().hasData()) {
                this.securityInformation = null;
            }
            if (this.durationType != null && !this.durationType.prune().hasData()) {
                this.durationType = null;
            }
            if (this.minimumFee != null && !this.minimumFee.prune().hasData()) {
                this.minimumFee = null;
            }
            if (this.dividendTerms != null && !this.dividendTerms.prune().hasData()) {
                this.dividendTerms = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAssetLeg() != null && this.getAssetLeg().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSecurityInformation() != null && this.getSecurityInformation().hasData()) {
                return true;
            }
            if (this.getDurationType() != null && this.getDurationType().hasData()) {
                return true;
            }
            if (this.getMinimumFee() != null && this.getMinimumFee().hasData()) {
                return true;
            }
            return this.getDividendTerms() != null && this.getDividendTerms().hasData();
        }

        @Override
        public AssetPayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AssetPayoutBuilder o = (AssetPayoutBuilder)other;
            merger.mergeRosetta(this.getAssetLeg(), o.getAssetLeg(), this::getOrCreateAssetLeg);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSecurityInformation(), (RosettaModelObjectBuilder)o.getSecurityInformation(), this::setSecurityInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDurationType(), (RosettaModelObjectBuilder)o.getDurationType(), this::setDurationType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMinimumFee(), (RosettaModelObjectBuilder)o.getMinimumFee(), this::setMinimumFee);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDividendTerms(), (RosettaModelObjectBuilder)o.getDividendTerms(), this::setDividendTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AssetPayout _that = (AssetPayout)this.getType().cast(o);
            if (!ListEquals.listEquals(this.assetLeg, _that.getAssetLeg())) {
                return false;
            }
            if (!Objects.equals(this.securityInformation, _that.getSecurityInformation())) {
                return false;
            }
            if (!Objects.equals(this.durationType, _that.getDurationType())) {
                return false;
            }
            if (!Objects.equals(this.minimumFee, _that.getMinimumFee())) {
                return false;
            }
            if (!Objects.equals(this.dividendTerms, _that.getDividendTerms())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.assetLeg != null ? this.assetLeg.hashCode() : 0);
            _result = 31 * _result + (this.securityInformation != null ? this.securityInformation.hashCode() : 0);
            _result = 31 * _result + (this.durationType != null ? this.durationType.hashCode() : 0);
            _result = 31 * _result + (this.minimumFee != null ? this.minimumFee.hashCode() : 0);
            _result = 31 * _result + (this.dividendTerms != null ? this.dividendTerms.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AssetPayoutBuilder {assetLeg=" + this.assetLeg + ", securityInformation=" + this.securityInformation + ", durationType=" + this.durationType + ", minimumFee=" + this.minimumFee + ", dividendTerms=" + this.dividendTerms + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static interface AssetPayoutBuilder
    extends AssetPayout,
    PayoutBase.PayoutBaseBuilder,
    GlobalKey.GlobalKeyBuilder {
        public AssetLeg.AssetLegBuilder getOrCreateAssetLeg(int var1);

        public List<? extends AssetLeg.AssetLegBuilder> getAssetLeg();

        public Product.ProductBuilder getOrCreateSecurityInformation();

        @Override
        public Product.ProductBuilder getSecurityInformation();

        public Duration.DurationBuilder getOrCreateDurationType();

        @Override
        public Duration.DurationBuilder getDurationType();

        public Money.MoneyBuilder getOrCreateMinimumFee();

        @Override
        public Money.MoneyBuilder getMinimumFee();

        public DividendTerms.DividendTermsBuilder getOrCreateDividendTerms();

        @Override
        public DividendTerms.DividendTermsBuilder getDividendTerms();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        @Override
        public AssetPayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public AssetPayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public AssetPayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public AssetPayoutBuilder setSettlementTerms(SettlementTerms var1);

        public AssetPayoutBuilder addAssetLeg(AssetLeg var1);

        public AssetPayoutBuilder addAssetLeg(AssetLeg var1, int var2);

        public AssetPayoutBuilder addAssetLeg(List<? extends AssetLeg> var1);

        public AssetPayoutBuilder setAssetLeg(List<? extends AssetLeg> var1);

        public AssetPayoutBuilder setSecurityInformation(Product var1);

        public AssetPayoutBuilder setDurationType(Duration var1);

        public AssetPayoutBuilder setMinimumFee(Money var1);

        public AssetPayoutBuilder setDividendTerms(DividendTerms var1);

        public AssetPayoutBuilder setMeta(MetaFields var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.ResolvablePriceQuantityBuilder.class, (RosettaModelObjectBuilder)this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.PrincipalPaymentsBuilder.class, (RosettaModelObjectBuilder)this.getPrincipalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.SettlementTermsBuilder.class, (RosettaModelObjectBuilder)this.getSettlementTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assetLeg"), processor, AssetLeg.AssetLegBuilder.class, this.getAssetLeg(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("securityInformation"), processor, Product.ProductBuilder.class, this.getSecurityInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("durationType"), processor, Duration.DurationBuilder.class, this.getDurationType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("minimumFee"), processor, Money.MoneyBuilder.class, this.getMinimumFee(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendTerms"), processor, DividendTerms.DividendTermsBuilder.class, this.getDividendTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        @Override
        public AssetPayoutBuilder prune();
    }

    public static class AssetPayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements AssetPayout {
        private final List<? extends AssetLeg> assetLeg;
        private final Product securityInformation;
        private final Duration durationType;
        private final Money minimumFee;
        private final DividendTerms dividendTerms;
        private final MetaFields meta;

        protected AssetPayoutImpl(AssetPayoutBuilder builder) {
            super(builder);
            this.assetLeg = Optional.ofNullable(builder.getAssetLeg()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.securityInformation = Optional.ofNullable(builder.getSecurityInformation()).map(f -> f.build()).orElse(null);
            this.durationType = Optional.ofNullable(builder.getDurationType()).map(f -> f.build()).orElse(null);
            this.minimumFee = Optional.ofNullable(builder.getMinimumFee()).map(f -> f.build()).orElse(null);
            this.dividendTerms = Optional.ofNullable(builder.getDividendTerms()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="assetLeg", isRequired=true)
        @RuneAttribute(value="assetLeg", isRequired=true)
        public List<? extends AssetLeg> getAssetLeg() {
            return this.assetLeg;
        }

        @Override
        @RosettaAttribute(value="securityInformation", isRequired=true)
        @RuneAttribute(value="securityInformation", isRequired=true)
        public Product getSecurityInformation() {
            return this.securityInformation;
        }

        @Override
        @RosettaAttribute(value="durationType", isRequired=true)
        @RuneAttribute(value="durationType", isRequired=true)
        public Duration getDurationType() {
            return this.durationType;
        }

        @Override
        @RosettaAttribute(value="minimumFee")
        @RuneAttribute(value="minimumFee")
        public Money getMinimumFee() {
            return this.minimumFee;
        }

        @Override
        @RosettaAttribute(value="dividendTerms")
        @RuneAttribute(value="dividendTerms")
        public DividendTerms getDividendTerms() {
            return this.dividendTerms;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public AssetPayout build() {
            return this;
        }

        @Override
        public AssetPayoutBuilder toBuilder() {
            AssetPayoutBuilder builder = AssetPayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetPayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAssetLeg()).ifPresent(builder::setAssetLeg);
            Optional.ofNullable(this.getSecurityInformation()).ifPresent(builder::setSecurityInformation);
            Optional.ofNullable(this.getDurationType()).ifPresent(builder::setDurationType);
            Optional.ofNullable(this.getMinimumFee()).ifPresent(builder::setMinimumFee);
            Optional.ofNullable(this.getDividendTerms()).ifPresent(builder::setDividendTerms);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AssetPayout _that = (AssetPayout)this.getType().cast(o);
            if (!ListEquals.listEquals(this.assetLeg, _that.getAssetLeg())) {
                return false;
            }
            if (!Objects.equals(this.securityInformation, _that.getSecurityInformation())) {
                return false;
            }
            if (!Objects.equals(this.durationType, _that.getDurationType())) {
                return false;
            }
            if (!Objects.equals(this.minimumFee, _that.getMinimumFee())) {
                return false;
            }
            if (!Objects.equals(this.dividendTerms, _that.getDividendTerms())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.assetLeg != null ? this.assetLeg.hashCode() : 0);
            _result = 31 * _result + (this.securityInformation != null ? this.securityInformation.hashCode() : 0);
            _result = 31 * _result + (this.durationType != null ? this.durationType.hashCode() : 0);
            _result = 31 * _result + (this.minimumFee != null ? this.minimumFee.hashCode() : 0);
            _result = 31 * _result + (this.dividendTerms != null ? this.dividendTerms.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AssetPayout {assetLeg=" + this.assetLeg + ", securityInformation=" + this.securityInformation + ", durationType=" + this.durationType + ", minimumFee=" + this.minimumFee + ", dividendTerms=" + this.dividendTerms + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }
}

