/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.observable.event.TriggerEvent;
import cdm.product.template.meta.KnockMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Knock", builder=KnockBuilderImpl.class, version="5.32.0")
@RuneDataType(value="Knock", model="cdm", builder=KnockBuilderImpl.class, version="5.32.0")
public interface Knock
extends RosettaModelObject {
    public static final KnockMeta metaData = new KnockMeta();

    public List<? extends TriggerEvent> getKnockIn();

    public List<? extends TriggerEvent> getKnockOut();

    public Knock build();

    public KnockBuilder toBuilder();

    public static KnockBuilder builder() {
        return new KnockBuilderImpl();
    }

    default public RosettaMetaData<? extends Knock> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Knock> getType() {
        return Knock.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("knockIn"), processor, TriggerEvent.class, this.getKnockIn(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("knockOut"), processor, TriggerEvent.class, this.getKnockOut(), new AttributeMeta[0]);
    }

    public static class KnockBuilderImpl
    implements KnockBuilder {
        protected List<TriggerEvent.TriggerEventBuilder> knockIn = new ArrayList<TriggerEvent.TriggerEventBuilder>();
        protected List<TriggerEvent.TriggerEventBuilder> knockOut = new ArrayList<TriggerEvent.TriggerEventBuilder>();

        @Override
        @RosettaAttribute(value="knockIn")
        @RuneAttribute(value="knockIn")
        public List<? extends TriggerEvent.TriggerEventBuilder> getKnockIn() {
            return this.knockIn;
        }

        @Override
        public TriggerEvent.TriggerEventBuilder getOrCreateKnockIn(int index) {
            if (this.knockIn == null) {
                this.knockIn = new ArrayList<TriggerEvent.TriggerEventBuilder>();
            }
            return (TriggerEvent.TriggerEventBuilder)this.getIndex(this.knockIn, index, () -> {
                TriggerEvent.TriggerEventBuilder newKnockIn = TriggerEvent.builder();
                return newKnockIn;
            });
        }

        @Override
        @RosettaAttribute(value="knockOut")
        @RuneAttribute(value="knockOut")
        public List<? extends TriggerEvent.TriggerEventBuilder> getKnockOut() {
            return this.knockOut;
        }

        @Override
        public TriggerEvent.TriggerEventBuilder getOrCreateKnockOut(int index) {
            if (this.knockOut == null) {
                this.knockOut = new ArrayList<TriggerEvent.TriggerEventBuilder>();
            }
            return (TriggerEvent.TriggerEventBuilder)this.getIndex(this.knockOut, index, () -> {
                TriggerEvent.TriggerEventBuilder newKnockOut = TriggerEvent.builder();
                return newKnockOut;
            });
        }

        @Override
        @RosettaAttribute(value="knockIn")
        @RuneAttribute(value="knockIn")
        public KnockBuilder addKnockIn(TriggerEvent _knockIn) {
            if (_knockIn != null) {
                this.knockIn.add(_knockIn.toBuilder());
            }
            return this;
        }

        @Override
        public KnockBuilder addKnockIn(TriggerEvent _knockIn, int idx) {
            this.getIndex(this.knockIn, idx, () -> _knockIn.toBuilder());
            return this;
        }

        @Override
        public KnockBuilder addKnockIn(List<? extends TriggerEvent> knockIns) {
            if (knockIns != null) {
                for (TriggerEvent triggerEvent : knockIns) {
                    this.knockIn.add(triggerEvent.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="knockIn")
        public KnockBuilder setKnockIn(List<? extends TriggerEvent> knockIns) {
            this.knockIn = knockIns == null ? new ArrayList<TriggerEvent.TriggerEventBuilder>() : (List)knockIns.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="knockOut")
        @RuneAttribute(value="knockOut")
        public KnockBuilder addKnockOut(TriggerEvent _knockOut) {
            if (_knockOut != null) {
                this.knockOut.add(_knockOut.toBuilder());
            }
            return this;
        }

        @Override
        public KnockBuilder addKnockOut(TriggerEvent _knockOut, int idx) {
            this.getIndex(this.knockOut, idx, () -> _knockOut.toBuilder());
            return this;
        }

        @Override
        public KnockBuilder addKnockOut(List<? extends TriggerEvent> knockOuts) {
            if (knockOuts != null) {
                for (TriggerEvent triggerEvent : knockOuts) {
                    this.knockOut.add(triggerEvent.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="knockOut")
        public KnockBuilder setKnockOut(List<? extends TriggerEvent> knockOuts) {
            this.knockOut = knockOuts == null ? new ArrayList<TriggerEvent.TriggerEventBuilder>() : (List)knockOuts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Knock build() {
            return new KnockImpl(this);
        }

        @Override
        public KnockBuilder toBuilder() {
            return this;
        }

        @Override
        public KnockBuilder prune() {
            this.knockIn = this.knockIn.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.knockOut = this.knockOut.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getKnockIn() != null && this.getKnockIn().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getKnockOut() != null && this.getKnockOut().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public KnockBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            KnockBuilder o = (KnockBuilder)other;
            merger.mergeRosetta(this.getKnockIn(), o.getKnockIn(), this::getOrCreateKnockIn);
            merger.mergeRosetta(this.getKnockOut(), o.getKnockOut(), this::getOrCreateKnockOut);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Knock _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.knockIn, _that.getKnockIn())) {
                return false;
            }
            return ListEquals.listEquals(this.knockOut, _that.getKnockOut());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.knockIn != null ? this.knockIn.hashCode() : 0);
            _result = 31 * _result + (this.knockOut != null ? this.knockOut.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "KnockBuilder {knockIn=" + this.knockIn + ", knockOut=" + this.knockOut + '}';
        }
    }

    public static interface KnockBuilder
    extends Knock,
    RosettaModelObjectBuilder {
        public TriggerEvent.TriggerEventBuilder getOrCreateKnockIn(int var1);

        public List<? extends TriggerEvent.TriggerEventBuilder> getKnockIn();

        public TriggerEvent.TriggerEventBuilder getOrCreateKnockOut(int var1);

        public List<? extends TriggerEvent.TriggerEventBuilder> getKnockOut();

        public KnockBuilder addKnockIn(TriggerEvent var1);

        public KnockBuilder addKnockIn(TriggerEvent var1, int var2);

        public KnockBuilder addKnockIn(List<? extends TriggerEvent> var1);

        public KnockBuilder setKnockIn(List<? extends TriggerEvent> var1);

        public KnockBuilder addKnockOut(TriggerEvent var1);

        public KnockBuilder addKnockOut(TriggerEvent var1, int var2);

        public KnockBuilder addKnockOut(List<? extends TriggerEvent> var1);

        public KnockBuilder setKnockOut(List<? extends TriggerEvent> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("knockIn"), processor, TriggerEvent.TriggerEventBuilder.class, this.getKnockIn(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("knockOut"), processor, TriggerEvent.TriggerEventBuilder.class, this.getKnockOut(), new AttributeMeta[0]);
        }

        public KnockBuilder prune();
    }

    public static class KnockImpl
    implements Knock {
        private final List<? extends TriggerEvent> knockIn;
        private final List<? extends TriggerEvent> knockOut;

        protected KnockImpl(KnockBuilder builder) {
            this.knockIn = Optional.ofNullable(builder.getKnockIn()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.knockOut = Optional.ofNullable(builder.getKnockOut()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="knockIn")
        @RuneAttribute(value="knockIn")
        public List<? extends TriggerEvent> getKnockIn() {
            return this.knockIn;
        }

        @Override
        @RosettaAttribute(value="knockOut")
        @RuneAttribute(value="knockOut")
        public List<? extends TriggerEvent> getKnockOut() {
            return this.knockOut;
        }

        @Override
        public Knock build() {
            return this;
        }

        @Override
        public KnockBuilder toBuilder() {
            KnockBuilder builder = Knock.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(KnockBuilder builder) {
            Optional.ofNullable(this.getKnockIn()).ifPresent(builder::setKnockIn);
            Optional.ofNullable(this.getKnockOut()).ifPresent(builder::setKnockOut);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Knock _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.knockIn, _that.getKnockIn())) {
                return false;
            }
            return ListEquals.listEquals(this.knockOut, _that.getKnockOut());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.knockIn != null ? this.knockIn.hashCode() : 0);
            _result = 31 * _result + (this.knockOut != null ? this.knockOut.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Knock {knockIn=" + this.knockIn + ", knockOut=" + this.knockOut + '}';
        }
    }
}

