/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.ValuationDates;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.common.schedule.ObservationTerms;
import cdm.product.common.schedule.PaymentDates;
import cdm.product.common.settlement.PayoutBase;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.FxFeature;
import cdm.product.template.PortfolioReturnTerms;
import cdm.product.template.Product;
import cdm.product.template.ReturnTerms;
import cdm.product.template.meta.PerformancePayoutMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeReference;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PerformancePayout", builder=PerformancePayoutBuilderImpl.class, version="5.32.0")
@RuneDataType(value="PerformancePayout", model="cdm", builder=PerformancePayoutBuilderImpl.class, version="5.32.0")
public interface PerformancePayout
extends PayoutBase,
GlobalKey {
    public static final PerformancePayoutMeta metaData = new PerformancePayoutMeta();

    public ObservationTerms getObservationTerms();

    public ValuationDates getValuationDates();

    public PaymentDates getPaymentDates();

    public Product getUnderlier();

    public List<? extends FxFeature> getFxFeature();

    public ReturnTerms getReturnTerms();

    public List<? extends PortfolioReturnTerms> getPortfolioReturnTerms();

    public List<? extends ReferenceWithMetaPriceSchedule> getInitialValuationPrice();

    public List<? extends ReferenceWithMetaPriceSchedule> getInterimValuationPrice();

    public List<? extends ReferenceWithMetaPriceSchedule> getFinalValuationPrice();

    public MetaFields getMeta();

    @Override
    public PerformancePayout build();

    @Override
    public PerformancePayoutBuilder toBuilder();

    public static PerformancePayoutBuilder builder() {
        return new PerformancePayoutBuilderImpl();
    }

    default public RosettaMetaData<? extends PerformancePayout> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PerformancePayout> getType() {
        return PerformancePayout.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.class, this.getPrincipalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.class, this.getSettlementTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationTerms"), processor, ObservationTerms.class, this.getObservationTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationDates"), processor, ValuationDates.class, this.getValuationDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.class, this.getPaymentDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlier"), processor, Product.class, this.getUnderlier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.class, this.getFxFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("returnTerms"), processor, ReturnTerms.class, this.getReturnTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolioReturnTerms"), processor, PortfolioReturnTerms.class, this.getPortfolioReturnTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("initialValuationPrice"), processor, ReferenceWithMetaPriceSchedule.class, this.getInitialValuationPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interimValuationPrice"), processor, ReferenceWithMetaPriceSchedule.class, this.getInterimValuationPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalValuationPrice"), processor, ReferenceWithMetaPriceSchedule.class, this.getFinalValuationPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class PerformancePayoutBuilderImpl
    extends PayoutBase.PayoutBaseBuilderImpl
    implements PerformancePayoutBuilder {
        protected ObservationTerms.ObservationTermsBuilder observationTerms;
        protected ValuationDates.ValuationDatesBuilder valuationDates;
        protected PaymentDates.PaymentDatesBuilder paymentDates;
        protected Product.ProductBuilder underlier;
        protected List<FxFeature.FxFeatureBuilder> fxFeature = new ArrayList<FxFeature.FxFeatureBuilder>();
        protected ReturnTerms.ReturnTermsBuilder returnTerms;
        protected List<PortfolioReturnTerms.PortfolioReturnTermsBuilder> portfolioReturnTerms = new ArrayList<PortfolioReturnTerms.PortfolioReturnTermsBuilder>();
        protected List<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> initialValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
        protected List<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> interimValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
        protected List<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> finalValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="observationTerms")
        @RuneAttribute(value="observationTerms")
        public ObservationTerms.ObservationTermsBuilder getObservationTerms() {
            return this.observationTerms;
        }

        @Override
        public ObservationTerms.ObservationTermsBuilder getOrCreateObservationTerms() {
            ObservationTerms.ObservationTermsBuilder result = this.observationTerms != null ? this.observationTerms : (this.observationTerms = ObservationTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="valuationDates", isRequired=true)
        @RuneAttribute(value="valuationDates", isRequired=true)
        public ValuationDates.ValuationDatesBuilder getValuationDates() {
            return this.valuationDates;
        }

        @Override
        public ValuationDates.ValuationDatesBuilder getOrCreateValuationDates() {
            ValuationDates.ValuationDatesBuilder result = this.valuationDates != null ? this.valuationDates : (this.valuationDates = ValuationDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDates", isRequired=true)
        @RuneAttribute(value="paymentDates", isRequired=true)
        public PaymentDates.PaymentDatesBuilder getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates() {
            PaymentDates.PaymentDatesBuilder result = this.paymentDates != null ? this.paymentDates : (this.paymentDates = PaymentDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlier")
        @RuneAttribute(value="underlier")
        public Product.ProductBuilder getUnderlier() {
            return this.underlier;
        }

        @Override
        public Product.ProductBuilder getOrCreateUnderlier() {
            Product.ProductBuilder result = this.underlier != null ? this.underlier : (this.underlier = Product.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxFeature")
        @RuneAttribute(value="fxFeature")
        public List<? extends FxFeature.FxFeatureBuilder> getFxFeature() {
            return this.fxFeature;
        }

        @Override
        public FxFeature.FxFeatureBuilder getOrCreateFxFeature(int index) {
            if (this.fxFeature == null) {
                this.fxFeature = new ArrayList<FxFeature.FxFeatureBuilder>();
            }
            return (FxFeature.FxFeatureBuilder)this.getIndex(this.fxFeature, index, () -> {
                FxFeature.FxFeatureBuilder newFxFeature = FxFeature.builder();
                return newFxFeature;
            });
        }

        @Override
        @RosettaAttribute(value="returnTerms")
        @RuneAttribute(value="returnTerms")
        public ReturnTerms.ReturnTermsBuilder getReturnTerms() {
            return this.returnTerms;
        }

        @Override
        public ReturnTerms.ReturnTermsBuilder getOrCreateReturnTerms() {
            ReturnTerms.ReturnTermsBuilder result = this.returnTerms != null ? this.returnTerms : (this.returnTerms = ReturnTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="portfolioReturnTerms")
        @RuneAttribute(value="portfolioReturnTerms")
        public List<? extends PortfolioReturnTerms.PortfolioReturnTermsBuilder> getPortfolioReturnTerms() {
            return this.portfolioReturnTerms;
        }

        @Override
        public PortfolioReturnTerms.PortfolioReturnTermsBuilder getOrCreatePortfolioReturnTerms(int index) {
            if (this.portfolioReturnTerms == null) {
                this.portfolioReturnTerms = new ArrayList<PortfolioReturnTerms.PortfolioReturnTermsBuilder>();
            }
            return (PortfolioReturnTerms.PortfolioReturnTermsBuilder)this.getIndex(this.portfolioReturnTerms, index, () -> {
                PortfolioReturnTerms.PortfolioReturnTermsBuilder newPortfolioReturnTerms = PortfolioReturnTerms.builder();
                return newPortfolioReturnTerms;
            });
        }

        @Override
        @RosettaAttribute(value="initialValuationPrice")
        @RuneAttribute(value="initialValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getInitialValuationPrice() {
            return this.initialValuationPrice;
        }

        @Override
        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateInitialValuationPrice(int index) {
            if (this.initialValuationPrice == null) {
                this.initialValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
            }
            return (ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder)this.getIndex(this.initialValuationPrice, index, () -> {
                ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder newInitialValuationPrice = ReferenceWithMetaPriceSchedule.builder();
                return newInitialValuationPrice;
            });
        }

        @Override
        @RosettaAttribute(value="interimValuationPrice")
        @RuneAttribute(value="interimValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getInterimValuationPrice() {
            return this.interimValuationPrice;
        }

        @Override
        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateInterimValuationPrice(int index) {
            if (this.interimValuationPrice == null) {
                this.interimValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
            }
            return (ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder)this.getIndex(this.interimValuationPrice, index, () -> {
                ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder newInterimValuationPrice = ReferenceWithMetaPriceSchedule.builder();
                return newInterimValuationPrice;
            });
        }

        @Override
        @RosettaAttribute(value="finalValuationPrice")
        @RuneAttribute(value="finalValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getFinalValuationPrice() {
            return this.finalValuationPrice;
        }

        @Override
        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateFinalValuationPrice(int index) {
            if (this.finalValuationPrice == null) {
                this.finalValuationPrice = new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>();
            }
            return (ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder)this.getIndex(this.finalValuationPrice, index, () -> {
                ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder newFinalValuationPrice = ReferenceWithMetaPriceSchedule.builder();
                return newFinalValuationPrice;
            });
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payerReceiver", isRequired=true)
        @RuneAttribute(value="payerReceiver", isRequired=true)
        public PerformancePayoutBuilder setPayerReceiver(PayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuantity")
        @RuneAttribute(value="priceQuantity")
        public PerformancePayoutBuilder setPriceQuantity(ResolvablePriceQuantity _priceQuantity) {
            this.priceQuantity = _priceQuantity == null ? null : _priceQuantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principalPayment")
        @RuneAttribute(value="principalPayment")
        public PerformancePayoutBuilder setPrincipalPayment(PrincipalPayments _principalPayment) {
            this.principalPayment = _principalPayment == null ? null : _principalPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public PerformancePayoutBuilder setSettlementTerms(SettlementTerms _settlementTerms) {
            this.settlementTerms = _settlementTerms == null ? null : _settlementTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationTerms")
        @RuneAttribute(value="observationTerms")
        public PerformancePayoutBuilder setObservationTerms(ObservationTerms _observationTerms) {
            this.observationTerms = _observationTerms == null ? null : _observationTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationDates", isRequired=true)
        @RuneAttribute(value="valuationDates", isRequired=true)
        public PerformancePayoutBuilder setValuationDates(ValuationDates _valuationDates) {
            this.valuationDates = _valuationDates == null ? null : _valuationDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDates", isRequired=true)
        @RuneAttribute(value="paymentDates", isRequired=true)
        public PerformancePayoutBuilder setPaymentDates(PaymentDates _paymentDates) {
            this.paymentDates = _paymentDates == null ? null : _paymentDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlier")
        @RuneAttribute(value="underlier")
        public PerformancePayoutBuilder setUnderlier(Product _underlier) {
            this.underlier = _underlier == null ? null : _underlier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxFeature")
        @RuneAttribute(value="fxFeature")
        public PerformancePayoutBuilder addFxFeature(FxFeature _fxFeature) {
            if (_fxFeature != null) {
                this.fxFeature.add(_fxFeature.toBuilder());
            }
            return this;
        }

        @Override
        public PerformancePayoutBuilder addFxFeature(FxFeature _fxFeature, int idx) {
            this.getIndex(this.fxFeature, idx, () -> _fxFeature.toBuilder());
            return this;
        }

        @Override
        public PerformancePayoutBuilder addFxFeature(List<? extends FxFeature> fxFeatures) {
            if (fxFeatures != null) {
                for (FxFeature fxFeature : fxFeatures) {
                    this.fxFeature.add(fxFeature.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fxFeature")
        public PerformancePayoutBuilder setFxFeature(List<? extends FxFeature> fxFeatures) {
            this.fxFeature = fxFeatures == null ? new ArrayList<FxFeature.FxFeatureBuilder>() : (List)fxFeatures.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="returnTerms")
        @RuneAttribute(value="returnTerms")
        public PerformancePayoutBuilder setReturnTerms(ReturnTerms _returnTerms) {
            this.returnTerms = _returnTerms == null ? null : _returnTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioReturnTerms")
        @RuneAttribute(value="portfolioReturnTerms")
        public PerformancePayoutBuilder addPortfolioReturnTerms(PortfolioReturnTerms _portfolioReturnTerms) {
            if (_portfolioReturnTerms != null) {
                this.portfolioReturnTerms.add(_portfolioReturnTerms.toBuilder());
            }
            return this;
        }

        @Override
        public PerformancePayoutBuilder addPortfolioReturnTerms(PortfolioReturnTerms _portfolioReturnTerms, int idx) {
            this.getIndex(this.portfolioReturnTerms, idx, () -> _portfolioReturnTerms.toBuilder());
            return this;
        }

        @Override
        public PerformancePayoutBuilder addPortfolioReturnTerms(List<? extends PortfolioReturnTerms> portfolioReturnTermss) {
            if (portfolioReturnTermss != null) {
                for (PortfolioReturnTerms portfolioReturnTerms : portfolioReturnTermss) {
                    this.portfolioReturnTerms.add(portfolioReturnTerms.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="portfolioReturnTerms")
        public PerformancePayoutBuilder setPortfolioReturnTerms(List<? extends PortfolioReturnTerms> portfolioReturnTermss) {
            this.portfolioReturnTerms = portfolioReturnTermss == null ? new ArrayList<PortfolioReturnTerms.PortfolioReturnTermsBuilder>() : (List)portfolioReturnTermss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="initialValuationPrice")
        @RuneAttribute(value="initialValuationPrice")
        @RuneScopedAttributeReference
        public PerformancePayoutBuilder addInitialValuationPrice(ReferenceWithMetaPriceSchedule _initialValuationPrice) {
            if (_initialValuationPrice != null) {
                this.initialValuationPrice.add(_initialValuationPrice.toBuilder());
            }
            return this;
        }

        @Override
        public PerformancePayoutBuilder addInitialValuationPrice(ReferenceWithMetaPriceSchedule _initialValuationPrice, int idx) {
            this.getIndex(this.initialValuationPrice, idx, () -> _initialValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PerformancePayoutBuilder addInitialValuationPriceValue(PriceSchedule _initialValuationPrice) {
            this.getOrCreateInitialValuationPrice(-1).setValue(_initialValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PerformancePayoutBuilder addInitialValuationPriceValue(PriceSchedule _initialValuationPrice, int idx) {
            this.getOrCreateInitialValuationPrice(idx).setValue(_initialValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PerformancePayoutBuilder addInitialValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> initialValuationPrices) {
            if (initialValuationPrices != null) {
                for (ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule : initialValuationPrices) {
                    this.initialValuationPrice.add(referenceWithMetaPriceSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="initialValuationPrice")
        @RuneScopedAttributeReference
        public PerformancePayoutBuilder setInitialValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> initialValuationPrices) {
            this.initialValuationPrice = initialValuationPrices == null ? new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>() : (List)initialValuationPrices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PerformancePayoutBuilder addInitialValuationPriceValue(List<? extends PriceSchedule> initialValuationPrices) {
            if (initialValuationPrices != null) {
                for (PriceSchedule priceSchedule : initialValuationPrices) {
                    this.addInitialValuationPriceValue(priceSchedule);
                }
            }
            return this;
        }

        @Override
        public PerformancePayoutBuilder setInitialValuationPriceValue(List<? extends PriceSchedule> initialValuationPrices) {
            this.initialValuationPrice.clear();
            if (initialValuationPrices != null) {
                initialValuationPrices.forEach(this::addInitialValuationPriceValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="interimValuationPrice")
        @RuneAttribute(value="interimValuationPrice")
        @RuneScopedAttributeReference
        public PerformancePayoutBuilder addInterimValuationPrice(ReferenceWithMetaPriceSchedule _interimValuationPrice) {
            if (_interimValuationPrice != null) {
                this.interimValuationPrice.add(_interimValuationPrice.toBuilder());
            }
            return this;
        }

        @Override
        public PerformancePayoutBuilder addInterimValuationPrice(ReferenceWithMetaPriceSchedule _interimValuationPrice, int idx) {
            this.getIndex(this.interimValuationPrice, idx, () -> _interimValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PerformancePayoutBuilder addInterimValuationPriceValue(PriceSchedule _interimValuationPrice) {
            this.getOrCreateInterimValuationPrice(-1).setValue(_interimValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PerformancePayoutBuilder addInterimValuationPriceValue(PriceSchedule _interimValuationPrice, int idx) {
            this.getOrCreateInterimValuationPrice(idx).setValue(_interimValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PerformancePayoutBuilder addInterimValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> interimValuationPrices) {
            if (interimValuationPrices != null) {
                for (ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule : interimValuationPrices) {
                    this.interimValuationPrice.add(referenceWithMetaPriceSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="interimValuationPrice")
        @RuneScopedAttributeReference
        public PerformancePayoutBuilder setInterimValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> interimValuationPrices) {
            this.interimValuationPrice = interimValuationPrices == null ? new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>() : (List)interimValuationPrices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PerformancePayoutBuilder addInterimValuationPriceValue(List<? extends PriceSchedule> interimValuationPrices) {
            if (interimValuationPrices != null) {
                for (PriceSchedule priceSchedule : interimValuationPrices) {
                    this.addInterimValuationPriceValue(priceSchedule);
                }
            }
            return this;
        }

        @Override
        public PerformancePayoutBuilder setInterimValuationPriceValue(List<? extends PriceSchedule> interimValuationPrices) {
            this.interimValuationPrice.clear();
            if (interimValuationPrices != null) {
                interimValuationPrices.forEach(this::addInterimValuationPriceValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="finalValuationPrice")
        @RuneAttribute(value="finalValuationPrice")
        @RuneScopedAttributeReference
        public PerformancePayoutBuilder addFinalValuationPrice(ReferenceWithMetaPriceSchedule _finalValuationPrice) {
            if (_finalValuationPrice != null) {
                this.finalValuationPrice.add(_finalValuationPrice.toBuilder());
            }
            return this;
        }

        @Override
        public PerformancePayoutBuilder addFinalValuationPrice(ReferenceWithMetaPriceSchedule _finalValuationPrice, int idx) {
            this.getIndex(this.finalValuationPrice, idx, () -> _finalValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PerformancePayoutBuilder addFinalValuationPriceValue(PriceSchedule _finalValuationPrice) {
            this.getOrCreateFinalValuationPrice(-1).setValue(_finalValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PerformancePayoutBuilder addFinalValuationPriceValue(PriceSchedule _finalValuationPrice, int idx) {
            this.getOrCreateFinalValuationPrice(idx).setValue(_finalValuationPrice.toBuilder());
            return this;
        }

        @Override
        public PerformancePayoutBuilder addFinalValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> finalValuationPrices) {
            if (finalValuationPrices != null) {
                for (ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule : finalValuationPrices) {
                    this.finalValuationPrice.add(referenceWithMetaPriceSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="finalValuationPrice")
        @RuneScopedAttributeReference
        public PerformancePayoutBuilder setFinalValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> finalValuationPrices) {
            this.finalValuationPrice = finalValuationPrices == null ? new ArrayList<ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder>() : (List)finalValuationPrices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PerformancePayoutBuilder addFinalValuationPriceValue(List<? extends PriceSchedule> finalValuationPrices) {
            if (finalValuationPrices != null) {
                for (PriceSchedule priceSchedule : finalValuationPrices) {
                    this.addFinalValuationPriceValue(priceSchedule);
                }
            }
            return this;
        }

        @Override
        public PerformancePayoutBuilder setFinalValuationPriceValue(List<? extends PriceSchedule> finalValuationPrices) {
            this.finalValuationPrice.clear();
            if (finalValuationPrices != null) {
                finalValuationPrices.forEach(this::addFinalValuationPriceValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public PerformancePayoutBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public PerformancePayout build() {
            return new PerformancePayoutImpl(this);
        }

        @Override
        public PerformancePayoutBuilder toBuilder() {
            return this;
        }

        @Override
        public PerformancePayoutBuilder prune() {
            super.prune();
            if (this.observationTerms != null && !this.observationTerms.prune().hasData()) {
                this.observationTerms = null;
            }
            if (this.valuationDates != null && !this.valuationDates.prune().hasData()) {
                this.valuationDates = null;
            }
            if (this.paymentDates != null && !this.paymentDates.prune().hasData()) {
                this.paymentDates = null;
            }
            if (this.underlier != null && !this.underlier.prune().hasData()) {
                this.underlier = null;
            }
            this.fxFeature = this.fxFeature.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.returnTerms != null && !this.returnTerms.prune().hasData()) {
                this.returnTerms = null;
            }
            this.portfolioReturnTerms = this.portfolioReturnTerms.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.initialValuationPrice = this.initialValuationPrice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.interimValuationPrice = this.interimValuationPrice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.finalValuationPrice = this.finalValuationPrice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getObservationTerms() != null && this.getObservationTerms().hasData()) {
                return true;
            }
            if (this.getValuationDates() != null && this.getValuationDates().hasData()) {
                return true;
            }
            if (this.getPaymentDates() != null && this.getPaymentDates().hasData()) {
                return true;
            }
            if (this.getUnderlier() != null && this.getUnderlier().hasData()) {
                return true;
            }
            if (this.getFxFeature() != null && this.getFxFeature().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getReturnTerms() != null && this.getReturnTerms().hasData()) {
                return true;
            }
            if (this.getPortfolioReturnTerms() != null && this.getPortfolioReturnTerms().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getInitialValuationPrice() != null && this.getInitialValuationPrice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getInterimValuationPrice() != null && this.getInterimValuationPrice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getFinalValuationPrice() != null && this.getFinalValuationPrice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public PerformancePayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PerformancePayoutBuilder o = (PerformancePayoutBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservationTerms(), (RosettaModelObjectBuilder)o.getObservationTerms(), this::setObservationTerms);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationDates(), (RosettaModelObjectBuilder)o.getValuationDates(), this::setValuationDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDates(), (RosettaModelObjectBuilder)o.getPaymentDates(), this::setPaymentDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlier(), (RosettaModelObjectBuilder)o.getUnderlier(), this::setUnderlier);
            merger.mergeRosetta(this.getFxFeature(), o.getFxFeature(), this::getOrCreateFxFeature);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReturnTerms(), (RosettaModelObjectBuilder)o.getReturnTerms(), this::setReturnTerms);
            merger.mergeRosetta(this.getPortfolioReturnTerms(), o.getPortfolioReturnTerms(), this::getOrCreatePortfolioReturnTerms);
            merger.mergeRosetta(this.getInitialValuationPrice(), o.getInitialValuationPrice(), this::getOrCreateInitialValuationPrice);
            merger.mergeRosetta(this.getInterimValuationPrice(), o.getInterimValuationPrice(), this::getOrCreateInterimValuationPrice);
            merger.mergeRosetta(this.getFinalValuationPrice(), o.getFinalValuationPrice(), this::getOrCreateFinalValuationPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PerformancePayout _that = (PerformancePayout)this.getType().cast(o);
            if (!Objects.equals(this.observationTerms, _that.getObservationTerms())) {
                return false;
            }
            if (!Objects.equals(this.valuationDates, _that.getValuationDates())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fxFeature, _that.getFxFeature())) {
                return false;
            }
            if (!Objects.equals(this.returnTerms, _that.getReturnTerms())) {
                return false;
            }
            if (!ListEquals.listEquals(this.portfolioReturnTerms, _that.getPortfolioReturnTerms())) {
                return false;
            }
            if (!ListEquals.listEquals(this.initialValuationPrice, _that.getInitialValuationPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.interimValuationPrice, _that.getInterimValuationPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.finalValuationPrice, _that.getFinalValuationPrice())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.observationTerms != null ? this.observationTerms.hashCode() : 0);
            _result = 31 * _result + (this.valuationDates != null ? this.valuationDates.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.fxFeature != null ? this.fxFeature.hashCode() : 0);
            _result = 31 * _result + (this.returnTerms != null ? this.returnTerms.hashCode() : 0);
            _result = 31 * _result + (this.portfolioReturnTerms != null ? this.portfolioReturnTerms.hashCode() : 0);
            _result = 31 * _result + (this.initialValuationPrice != null ? this.initialValuationPrice.hashCode() : 0);
            _result = 31 * _result + (this.interimValuationPrice != null ? this.interimValuationPrice.hashCode() : 0);
            _result = 31 * _result + (this.finalValuationPrice != null ? this.finalValuationPrice.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PerformancePayoutBuilder {observationTerms=" + this.observationTerms + ", valuationDates=" + this.valuationDates + ", paymentDates=" + this.paymentDates + ", underlier=" + this.underlier + ", fxFeature=" + this.fxFeature + ", returnTerms=" + this.returnTerms + ", portfolioReturnTerms=" + this.portfolioReturnTerms + ", initialValuationPrice=" + this.initialValuationPrice + ", interimValuationPrice=" + this.interimValuationPrice + ", finalValuationPrice=" + this.finalValuationPrice + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static interface PerformancePayoutBuilder
    extends PerformancePayout,
    PayoutBase.PayoutBaseBuilder,
    GlobalKey.GlobalKeyBuilder {
        public ObservationTerms.ObservationTermsBuilder getOrCreateObservationTerms();

        @Override
        public ObservationTerms.ObservationTermsBuilder getObservationTerms();

        public ValuationDates.ValuationDatesBuilder getOrCreateValuationDates();

        @Override
        public ValuationDates.ValuationDatesBuilder getValuationDates();

        public PaymentDates.PaymentDatesBuilder getOrCreatePaymentDates();

        @Override
        public PaymentDates.PaymentDatesBuilder getPaymentDates();

        public Product.ProductBuilder getOrCreateUnderlier();

        @Override
        public Product.ProductBuilder getUnderlier();

        public FxFeature.FxFeatureBuilder getOrCreateFxFeature(int var1);

        public List<? extends FxFeature.FxFeatureBuilder> getFxFeature();

        public ReturnTerms.ReturnTermsBuilder getOrCreateReturnTerms();

        @Override
        public ReturnTerms.ReturnTermsBuilder getReturnTerms();

        public PortfolioReturnTerms.PortfolioReturnTermsBuilder getOrCreatePortfolioReturnTerms(int var1);

        public List<? extends PortfolioReturnTerms.PortfolioReturnTermsBuilder> getPortfolioReturnTerms();

        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateInitialValuationPrice(int var1);

        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getInitialValuationPrice();

        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateInterimValuationPrice(int var1);

        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getInterimValuationPrice();

        public ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder getOrCreateFinalValuationPrice(int var1);

        public List<? extends ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder> getFinalValuationPrice();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        @Override
        public PerformancePayoutBuilder setPayerReceiver(PayerReceiver var1);

        @Override
        public PerformancePayoutBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        @Override
        public PerformancePayoutBuilder setPrincipalPayment(PrincipalPayments var1);

        @Override
        public PerformancePayoutBuilder setSettlementTerms(SettlementTerms var1);

        public PerformancePayoutBuilder setObservationTerms(ObservationTerms var1);

        public PerformancePayoutBuilder setValuationDates(ValuationDates var1);

        public PerformancePayoutBuilder setPaymentDates(PaymentDates var1);

        public PerformancePayoutBuilder setUnderlier(Product var1);

        public PerformancePayoutBuilder addFxFeature(FxFeature var1);

        public PerformancePayoutBuilder addFxFeature(FxFeature var1, int var2);

        public PerformancePayoutBuilder addFxFeature(List<? extends FxFeature> var1);

        public PerformancePayoutBuilder setFxFeature(List<? extends FxFeature> var1);

        public PerformancePayoutBuilder setReturnTerms(ReturnTerms var1);

        public PerformancePayoutBuilder addPortfolioReturnTerms(PortfolioReturnTerms var1);

        public PerformancePayoutBuilder addPortfolioReturnTerms(PortfolioReturnTerms var1, int var2);

        public PerformancePayoutBuilder addPortfolioReturnTerms(List<? extends PortfolioReturnTerms> var1);

        public PerformancePayoutBuilder setPortfolioReturnTerms(List<? extends PortfolioReturnTerms> var1);

        public PerformancePayoutBuilder addInitialValuationPrice(ReferenceWithMetaPriceSchedule var1);

        public PerformancePayoutBuilder addInitialValuationPrice(ReferenceWithMetaPriceSchedule var1, int var2);

        public PerformancePayoutBuilder addInitialValuationPriceValue(PriceSchedule var1);

        public PerformancePayoutBuilder addInitialValuationPriceValue(PriceSchedule var1, int var2);

        public PerformancePayoutBuilder addInitialValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public PerformancePayoutBuilder setInitialValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public PerformancePayoutBuilder addInitialValuationPriceValue(List<? extends PriceSchedule> var1);

        public PerformancePayoutBuilder setInitialValuationPriceValue(List<? extends PriceSchedule> var1);

        public PerformancePayoutBuilder addInterimValuationPrice(ReferenceWithMetaPriceSchedule var1);

        public PerformancePayoutBuilder addInterimValuationPrice(ReferenceWithMetaPriceSchedule var1, int var2);

        public PerformancePayoutBuilder addInterimValuationPriceValue(PriceSchedule var1);

        public PerformancePayoutBuilder addInterimValuationPriceValue(PriceSchedule var1, int var2);

        public PerformancePayoutBuilder addInterimValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public PerformancePayoutBuilder setInterimValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public PerformancePayoutBuilder addInterimValuationPriceValue(List<? extends PriceSchedule> var1);

        public PerformancePayoutBuilder setInterimValuationPriceValue(List<? extends PriceSchedule> var1);

        public PerformancePayoutBuilder addFinalValuationPrice(ReferenceWithMetaPriceSchedule var1);

        public PerformancePayoutBuilder addFinalValuationPrice(ReferenceWithMetaPriceSchedule var1, int var2);

        public PerformancePayoutBuilder addFinalValuationPriceValue(PriceSchedule var1);

        public PerformancePayoutBuilder addFinalValuationPriceValue(PriceSchedule var1, int var2);

        public PerformancePayoutBuilder addFinalValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public PerformancePayoutBuilder setFinalValuationPrice(List<? extends ReferenceWithMetaPriceSchedule> var1);

        public PerformancePayoutBuilder addFinalValuationPriceValue(List<? extends PriceSchedule> var1);

        public PerformancePayoutBuilder setFinalValuationPriceValue(List<? extends PriceSchedule> var1);

        public PerformancePayoutBuilder setMeta(MetaFields var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.ResolvablePriceQuantityBuilder.class, (RosettaModelObjectBuilder)this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.PrincipalPaymentsBuilder.class, (RosettaModelObjectBuilder)this.getPrincipalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.SettlementTermsBuilder.class, (RosettaModelObjectBuilder)this.getSettlementTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationTerms"), processor, ObservationTerms.ObservationTermsBuilder.class, this.getObservationTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationDates"), processor, ValuationDates.ValuationDatesBuilder.class, this.getValuationDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDates"), processor, PaymentDates.PaymentDatesBuilder.class, this.getPaymentDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlier"), processor, Product.ProductBuilder.class, this.getUnderlier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.FxFeatureBuilder.class, this.getFxFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("returnTerms"), processor, ReturnTerms.ReturnTermsBuilder.class, this.getReturnTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolioReturnTerms"), processor, PortfolioReturnTerms.PortfolioReturnTermsBuilder.class, this.getPortfolioReturnTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("initialValuationPrice"), processor, ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder.class, this.getInitialValuationPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interimValuationPrice"), processor, ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder.class, this.getInterimValuationPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalValuationPrice"), processor, ReferenceWithMetaPriceSchedule.ReferenceWithMetaPriceScheduleBuilder.class, this.getFinalValuationPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        @Override
        public PerformancePayoutBuilder prune();
    }

    public static class PerformancePayoutImpl
    extends PayoutBase.PayoutBaseImpl
    implements PerformancePayout {
        private final ObservationTerms observationTerms;
        private final ValuationDates valuationDates;
        private final PaymentDates paymentDates;
        private final Product underlier;
        private final List<? extends FxFeature> fxFeature;
        private final ReturnTerms returnTerms;
        private final List<? extends PortfolioReturnTerms> portfolioReturnTerms;
        private final List<? extends ReferenceWithMetaPriceSchedule> initialValuationPrice;
        private final List<? extends ReferenceWithMetaPriceSchedule> interimValuationPrice;
        private final List<? extends ReferenceWithMetaPriceSchedule> finalValuationPrice;
        private final MetaFields meta;

        protected PerformancePayoutImpl(PerformancePayoutBuilder builder) {
            super(builder);
            this.observationTerms = Optional.ofNullable(builder.getObservationTerms()).map(f -> f.build()).orElse(null);
            this.valuationDates = Optional.ofNullable(builder.getValuationDates()).map(f -> f.build()).orElse(null);
            this.paymentDates = Optional.ofNullable(builder.getPaymentDates()).map(f -> f.build()).orElse(null);
            this.underlier = Optional.ofNullable(builder.getUnderlier()).map(f -> f.build()).orElse(null);
            this.fxFeature = Optional.ofNullable(builder.getFxFeature()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.returnTerms = Optional.ofNullable(builder.getReturnTerms()).map(f -> f.build()).orElse(null);
            this.portfolioReturnTerms = Optional.ofNullable(builder.getPortfolioReturnTerms()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.initialValuationPrice = Optional.ofNullable(builder.getInitialValuationPrice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.interimValuationPrice = Optional.ofNullable(builder.getInterimValuationPrice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.finalValuationPrice = Optional.ofNullable(builder.getFinalValuationPrice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="observationTerms")
        @RuneAttribute(value="observationTerms")
        public ObservationTerms getObservationTerms() {
            return this.observationTerms;
        }

        @Override
        @RosettaAttribute(value="valuationDates", isRequired=true)
        @RuneAttribute(value="valuationDates", isRequired=true)
        public ValuationDates getValuationDates() {
            return this.valuationDates;
        }

        @Override
        @RosettaAttribute(value="paymentDates", isRequired=true)
        @RuneAttribute(value="paymentDates", isRequired=true)
        public PaymentDates getPaymentDates() {
            return this.paymentDates;
        }

        @Override
        @RosettaAttribute(value="underlier")
        @RuneAttribute(value="underlier")
        public Product getUnderlier() {
            return this.underlier;
        }

        @Override
        @RosettaAttribute(value="fxFeature")
        @RuneAttribute(value="fxFeature")
        public List<? extends FxFeature> getFxFeature() {
            return this.fxFeature;
        }

        @Override
        @RosettaAttribute(value="returnTerms")
        @RuneAttribute(value="returnTerms")
        public ReturnTerms getReturnTerms() {
            return this.returnTerms;
        }

        @Override
        @RosettaAttribute(value="portfolioReturnTerms")
        @RuneAttribute(value="portfolioReturnTerms")
        public List<? extends PortfolioReturnTerms> getPortfolioReturnTerms() {
            return this.portfolioReturnTerms;
        }

        @Override
        @RosettaAttribute(value="initialValuationPrice")
        @RuneAttribute(value="initialValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule> getInitialValuationPrice() {
            return this.initialValuationPrice;
        }

        @Override
        @RosettaAttribute(value="interimValuationPrice")
        @RuneAttribute(value="interimValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule> getInterimValuationPrice() {
            return this.interimValuationPrice;
        }

        @Override
        @RosettaAttribute(value="finalValuationPrice")
        @RuneAttribute(value="finalValuationPrice")
        @RuneScopedAttributeReference
        public List<? extends ReferenceWithMetaPriceSchedule> getFinalValuationPrice() {
            return this.finalValuationPrice;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public PerformancePayout build() {
            return this;
        }

        @Override
        public PerformancePayoutBuilder toBuilder() {
            PerformancePayoutBuilder builder = PerformancePayout.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PerformancePayoutBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getObservationTerms()).ifPresent(builder::setObservationTerms);
            Optional.ofNullable(this.getValuationDates()).ifPresent(builder::setValuationDates);
            Optional.ofNullable(this.getPaymentDates()).ifPresent(builder::setPaymentDates);
            Optional.ofNullable(this.getUnderlier()).ifPresent(builder::setUnderlier);
            Optional.ofNullable(this.getFxFeature()).ifPresent(builder::setFxFeature);
            Optional.ofNullable(this.getReturnTerms()).ifPresent(builder::setReturnTerms);
            Optional.ofNullable(this.getPortfolioReturnTerms()).ifPresent(builder::setPortfolioReturnTerms);
            Optional.ofNullable(this.getInitialValuationPrice()).ifPresent(builder::setInitialValuationPrice);
            Optional.ofNullable(this.getInterimValuationPrice()).ifPresent(builder::setInterimValuationPrice);
            Optional.ofNullable(this.getFinalValuationPrice()).ifPresent(builder::setFinalValuationPrice);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PerformancePayout _that = (PerformancePayout)this.getType().cast(o);
            if (!Objects.equals(this.observationTerms, _that.getObservationTerms())) {
                return false;
            }
            if (!Objects.equals(this.valuationDates, _that.getValuationDates())) {
                return false;
            }
            if (!Objects.equals(this.paymentDates, _that.getPaymentDates())) {
                return false;
            }
            if (!Objects.equals(this.underlier, _that.getUnderlier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fxFeature, _that.getFxFeature())) {
                return false;
            }
            if (!Objects.equals(this.returnTerms, _that.getReturnTerms())) {
                return false;
            }
            if (!ListEquals.listEquals(this.portfolioReturnTerms, _that.getPortfolioReturnTerms())) {
                return false;
            }
            if (!ListEquals.listEquals(this.initialValuationPrice, _that.getInitialValuationPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.interimValuationPrice, _that.getInterimValuationPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.finalValuationPrice, _that.getFinalValuationPrice())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.observationTerms != null ? this.observationTerms.hashCode() : 0);
            _result = 31 * _result + (this.valuationDates != null ? this.valuationDates.hashCode() : 0);
            _result = 31 * _result + (this.paymentDates != null ? this.paymentDates.hashCode() : 0);
            _result = 31 * _result + (this.underlier != null ? this.underlier.hashCode() : 0);
            _result = 31 * _result + (this.fxFeature != null ? this.fxFeature.hashCode() : 0);
            _result = 31 * _result + (this.returnTerms != null ? this.returnTerms.hashCode() : 0);
            _result = 31 * _result + (this.portfolioReturnTerms != null ? this.portfolioReturnTerms.hashCode() : 0);
            _result = 31 * _result + (this.initialValuationPrice != null ? this.initialValuationPrice.hashCode() : 0);
            _result = 31 * _result + (this.interimValuationPrice != null ? this.interimValuationPrice.hashCode() : 0);
            _result = 31 * _result + (this.finalValuationPrice != null ? this.finalValuationPrice.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PerformancePayout {observationTerms=" + this.observationTerms + ", valuationDates=" + this.valuationDates + ", paymentDates=" + this.paymentDates + ", underlier=" + this.underlier + ", fxFeature=" + this.fxFeature + ", returnTerms=" + this.returnTerms + ", portfolioReturnTerms=" + this.portfolioReturnTerms + ", initialValuationPrice=" + this.initialValuationPrice + ", interimValuationPrice=" + this.interimValuationPrice + ", finalValuationPrice=" + this.finalValuationPrice + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }
}

