/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ProductOneOf0")
@ImplementedBy(value=Default.class)
public interface ProductOneOf0
extends Validator<Product> {
    public static final String NAME = "ProductOneOf0";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements ProductOneOf0 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Product product) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ProductOneOf0 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Product product) {
            ComparisonResult result = this.executeDataRule(product);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ProductOneOf0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Product", (RosettaPath)path, (String)ProductOneOf0.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ProductOneOf0.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Product", (RosettaPath)path, (String)ProductOneOf0.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Product product) {
            try {
                return ExpressionOperatorsNullSafe.choice((Mapper)MapperS.of((Object)product), Arrays.asList("contractualProduct", "index", "loan", "assetPool", "foreignExchange", "commodity", "security", "basket"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

