/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.collect.tuple.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Messages {
    private static final Pattern REGEX_PATTERN = Pattern.compile("\\{(\\w*)\\}");

    private Messages() {
    }

    public static String format(String messageTemplate, Object arg) {
        if (messageTemplate == null) {
            return Messages.format("", arg);
        }
        int placeholderPos = messageTemplate.indexOf("{}", 0);
        String argStr = String.valueOf(arg);
        StringBuilder builder = new StringBuilder(messageTemplate.length() + argStr.length() + 3);
        if (placeholderPos >= 0) {
            builder.append(messageTemplate.substring(0, placeholderPos)).append(argStr).append(messageTemplate.substring(placeholderPos + 2));
        } else {
            builder.append(messageTemplate).append(" - [").append(argStr).append(']');
        }
        return builder.toString();
    }

    public static String format(String messageTemplate, Object ... args) {
        int argIndex;
        if (messageTemplate == null) {
            return Messages.format("", args);
        }
        if (args == null) {
            return Messages.format(messageTemplate, new Object[0]);
        }
        StringBuilder builder = new StringBuilder(messageTemplate.length() + args.length * 20);
        int curPos = 0;
        int nextPlaceholderPos = messageTemplate.indexOf("{}", curPos);
        for (argIndex = 0; nextPlaceholderPos >= 0 && argIndex < args.length; ++argIndex) {
            builder.append(messageTemplate.substring(curPos, nextPlaceholderPos)).append(args[argIndex]);
            curPos = nextPlaceholderPos + 2;
            nextPlaceholderPos = messageTemplate.indexOf("{}", curPos);
        }
        builder.append(messageTemplate.substring(curPos));
        if (argIndex < args.length) {
            builder.append(" - [");
            for (int i = argIndex; i < args.length; ++i) {
                if (i > argIndex) {
                    builder.append(", ");
                }
                builder.append(args[i]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public static Pair<String, Map<String, String>> formatWithAttributes(String messageTemplate, Object ... args) {
        if (messageTemplate == null) {
            return Messages.formatWithAttributes("", args);
        }
        if (args == null) {
            return Messages.formatWithAttributes(messageTemplate, new Object[0]);
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        Matcher matcher = REGEX_PATTERN.matcher(messageTemplate);
        int argIndex = 0;
        StringBuffer outputMessageBuffer = new StringBuffer();
        while (matcher.find()) {
            if (argIndex >= args.length) continue;
            String attributeName = matcher.group(1);
            String replacement = args[argIndex].toString().replace("$", "\\$");
            matcher.appendReplacement(outputMessageBuffer, replacement);
            if (!attributeName.isEmpty()) {
                attributes.put(attributeName, replacement);
            }
            ++argIndex;
        }
        matcher.appendTail(outputMessageBuffer);
        return Pair.of(outputMessageBuffer.toString(), ImmutableMap.copyOf(attributes));
    }
}

