/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.result;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.result.FailureItem;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ValueWithFailures<T>
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final T value;
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<FailureItem> failures;
    private static final long serialVersionUID = 1L;

    public static <T> ValueWithFailures<T> of(T successValue, FailureItem ... failures) {
        return new ValueWithFailures<T>(successValue, (List<FailureItem>)ImmutableList.copyOf((Object[])failures));
    }

    public static <T> ValueWithFailures<T> of(T successValue, List<FailureItem> failures) {
        return new ValueWithFailures<T>(successValue, failures);
    }

    public static <T> Collector<ValueWithFailures<T>, ?, ValueWithFailures<T>> toValueWithFailures(T identityValue, BinaryOperator<T> operator) {
        BinaryOperator reduceFunction = (result1, result2) -> result1.combinedWith((ValueWithFailures)result2, operator);
        return Collectors.reducing(ValueWithFailures.of(identityValue, new FailureItem[0]), reduceFunction);
    }

    public boolean hasFailures() {
        return !this.failures.isEmpty();
    }

    public <R> ValueWithFailures<R> map(Function<? super T, ? extends R> function) {
        R transformedValue = Objects.requireNonNull(function.apply(this.value));
        return ValueWithFailures.of(transformedValue, this.failures);
    }

    public <R> ValueWithFailures<R> flatMap(Function<? super T, ValueWithFailures<R>> function) {
        ValueWithFailures<R> transformedValue = Objects.requireNonNull(function.apply(this.value));
        ImmutableList combinedFailures = ImmutableList.builder().addAll(this.failures).addAll(transformedValue.failures).build();
        return ValueWithFailures.of(transformedValue.value, (List<FailureItem>)combinedFailures);
    }

    public ValueWithFailures<T> combinedWith(ValueWithFailures<T> other, BinaryOperator<T> combiner) {
        Object combinedValues = combiner.apply(this.value, other.value);
        ImmutableList combinedFailures = Guavate.concatToList(new Iterable[]{this.failures, other.failures});
        return ValueWithFailures.of(combinedValues, combinedFailures);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static <R> Meta<R> metaValueWithFailures(Class<R> cls) {
        return Meta.INSTANCE;
    }

    private ValueWithFailures(T value, List<FailureItem> failures) {
        JodaBeanUtils.notNull(value, (String)"value");
        JodaBeanUtils.notNull(failures, (String)"failures");
        this.value = value;
        this.failures = ImmutableList.copyOf(failures);
    }

    public Meta<T> metaBean() {
        return Meta.INSTANCE;
    }

    public T getValue() {
        return this.value;
    }

    public ImmutableList<FailureItem> getFailures() {
        return this.failures;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ValueWithFailures other = (ValueWithFailures)obj;
            return JodaBeanUtils.equal(this.value, other.value) && JodaBeanUtils.equal(this.failures, other.failures);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.value);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.failures);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("ValueWithFailures{");
        buf.append("value").append('=').append(this.value).append(',').append(' ');
        buf.append("failures").append('=').append(JodaBeanUtils.toString(this.failures));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder<T>
    extends DirectPrivateBeanBuilder<ValueWithFailures<T>> {
        private T value;
        private List<FailureItem> failures = ImmutableList.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
                case 675938345: {
                    return this.failures;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder<T> set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    this.value = newValue;
                    break;
                }
                case 675938345: {
                    this.failures = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ValueWithFailures<T> build() {
            return new ValueWithFailures(this.value, this.failures);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ValueWithFailures.Builder{");
            buf.append("value").append('=').append(JodaBeanUtils.toString(this.value)).append(',').append(' ');
            buf.append("failures").append('=').append(JodaBeanUtils.toString(this.failures));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta<T>
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<T> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", ValueWithFailures.class, Object.class);
        private final MetaProperty<ImmutableList<FailureItem>> failures = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"failures", ValueWithFailures.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"value", "failures"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
                case 675938345: {
                    return this.failures;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ValueWithFailures<T>> builder() {
            return new Builder();
        }

        public Class<? extends ValueWithFailures<T>> beanType() {
            return ValueWithFailures.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<T> value() {
            return this.value;
        }

        public MetaProperty<ImmutableList<FailureItem>> failures() {
            return this.failures;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return ((ValueWithFailures)bean).getValue();
                }
                case 675938345: {
                    return ((ValueWithFailures)bean).getFailures();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

