/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import com.opengamma.strata.basics.date.LocalDateUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class DaysAdjustment
implements Resolvable<DateAdjuster>,
ImmutableBean,
Serializable {
    public static final DaysAdjustment NONE = new DaysAdjustment(0, HolidayCalendarIds.NO_HOLIDAYS, BusinessDayAdjustment.NONE);
    @PropertyDefinition(validate="notNull")
    private final int days;
    @PropertyDefinition(validate="notNull")
    private final HolidayCalendarId calendar;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment adjustment;
    private static final long serialVersionUID = 1L;

    public static DaysAdjustment ofCalendarDays(int numberOfDays) {
        return new DaysAdjustment(numberOfDays, HolidayCalendarIds.NO_HOLIDAYS, BusinessDayAdjustment.NONE);
    }

    public static DaysAdjustment ofCalendarDays(int numberOfDays, BusinessDayAdjustment adjustment) {
        return new DaysAdjustment(numberOfDays, HolidayCalendarIds.NO_HOLIDAYS, adjustment);
    }

    public static DaysAdjustment ofBusinessDays(int numberOfDays, HolidayCalendarId holidayCalendar) {
        return new DaysAdjustment(numberOfDays, holidayCalendar, BusinessDayAdjustment.NONE);
    }

    public static DaysAdjustment ofBusinessDays(int numberOfDays, HolidayCalendarId holidayCalendar, BusinessDayAdjustment adjustment) {
        return new DaysAdjustment(numberOfDays, holidayCalendar, adjustment);
    }

    public LocalDate adjust(LocalDate date, ReferenceData refData) {
        LocalDate added = this.calendar.resolve(refData).shift(date, this.days);
        return this.adjustment.adjust(added, refData);
    }

    @Override
    public DateAdjuster resolve(ReferenceData refData) {
        HolidayCalendar holCalAdj = this.adjustment.getCalendar().resolve(refData);
        if (this.calendar == HolidayCalendarIds.NO_HOLIDAYS) {
            BusinessDayConvention adjustmentConvention = this.adjustment.getConvention();
            return date -> adjustmentConvention.adjust(LocalDateUtils.plusDays(date, this.days), holCalAdj);
        }
        HolidayCalendar holCalAdd = this.calendar.resolve(refData);
        BusinessDayConvention adjustmentConvention = this.adjustment.getConvention();
        return date -> adjustmentConvention.adjust(holCalAdd.shift(date, this.days), holCalAdj);
    }

    public HolidayCalendarId getResultCalendar() {
        HolidayCalendarId cal = this.adjustment.getCalendar();
        if (cal == HolidayCalendarIds.NO_HOLIDAYS) {
            cal = this.calendar;
        }
        return cal;
    }

    public DaysAdjustment normalized() {
        if (this.days == 0) {
            if (this.calendar != HolidayCalendarIds.NO_HOLIDAYS) {
                return DaysAdjustment.ofCalendarDays(this.days, this.adjustment);
            }
            return this;
        }
        if (this.calendar.equals(this.adjustment.getCalendar())) {
            return DaysAdjustment.ofBusinessDays(this.days, this.calendar);
        }
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(this.days);
        if (this.calendar == HolidayCalendarIds.NO_HOLIDAYS) {
            buf.append(" calendar day");
            if (this.days != 1) {
                buf.append("s");
            }
        } else {
            buf.append(" business day");
            if (this.days != 1) {
                buf.append("s");
            }
            buf.append(" using calendar ").append(this.calendar.getName());
        }
        if (!this.adjustment.equals(BusinessDayAdjustment.NONE)) {
            buf.append(" then apply ").append(this.adjustment);
        }
        return buf.toString();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private DaysAdjustment(int days, HolidayCalendarId calendar, BusinessDayAdjustment adjustment) {
        JodaBeanUtils.notNull((Object)days, (String)"days");
        JodaBeanUtils.notNull((Object)calendar, (String)"calendar");
        JodaBeanUtils.notNull((Object)adjustment, (String)"adjustment");
        this.days = days;
        this.calendar = calendar;
        this.adjustment = adjustment;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public int getDays() {
        return this.days;
    }

    public HolidayCalendarId getCalendar() {
        return this.calendar;
    }

    public BusinessDayAdjustment getAdjustment() {
        return this.adjustment;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DaysAdjustment other = (DaysAdjustment)obj;
            return this.days == other.days && JodaBeanUtils.equal((Object)this.calendar, (Object)other.calendar) && JodaBeanUtils.equal((Object)this.adjustment, (Object)other.adjustment);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.days);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.calendar);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.adjustment);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<DaysAdjustment> {
        private int days;
        private HolidayCalendarId calendar;
        private BusinessDayAdjustment adjustment;

        private Builder() {
        }

        private Builder(DaysAdjustment beanToCopy) {
            this.days = beanToCopy.getDays();
            this.calendar = beanToCopy.getCalendar();
            this.adjustment = beanToCopy.getAdjustment();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3076183: {
                    return this.days;
                }
                case -178324674: {
                    return this.calendar;
                }
                case 1977085293: {
                    return this.adjustment;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3076183: {
                    this.days = (Integer)newValue;
                    break;
                }
                case -178324674: {
                    this.calendar = (HolidayCalendarId)newValue;
                    break;
                }
                case 1977085293: {
                    this.adjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public DaysAdjustment build() {
            return new DaysAdjustment(this.days, this.calendar, this.adjustment);
        }

        public Builder days(int days) {
            JodaBeanUtils.notNull((Object)days, (String)"days");
            this.days = days;
            return this;
        }

        public Builder calendar(HolidayCalendarId calendar) {
            JodaBeanUtils.notNull((Object)calendar, (String)"calendar");
            this.calendar = calendar;
            return this;
        }

        public Builder adjustment(BusinessDayAdjustment adjustment) {
            JodaBeanUtils.notNull((Object)adjustment, (String)"adjustment");
            this.adjustment = adjustment;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("DaysAdjustment.Builder{");
            buf.append("days").append('=').append(JodaBeanUtils.toString((Object)this.days)).append(',').append(' ');
            buf.append("calendar").append('=').append(JodaBeanUtils.toString((Object)this.calendar)).append(',').append(' ');
            buf.append("adjustment").append('=').append(JodaBeanUtils.toString((Object)this.adjustment));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Integer> days = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"days", DaysAdjustment.class, Integer.TYPE);
        private final MetaProperty<HolidayCalendarId> calendar = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"calendar", DaysAdjustment.class, HolidayCalendarId.class);
        private final MetaProperty<BusinessDayAdjustment> adjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"adjustment", DaysAdjustment.class, BusinessDayAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"days", "calendar", "adjustment"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3076183: {
                    return this.days;
                }
                case -178324674: {
                    return this.calendar;
                }
                case 1977085293: {
                    return this.adjustment;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends DaysAdjustment> beanType() {
            return DaysAdjustment.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Integer> days() {
            return this.days;
        }

        public MetaProperty<HolidayCalendarId> calendar() {
            return this.calendar;
        }

        public MetaProperty<BusinessDayAdjustment> adjustment() {
            return this.adjustment;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3076183: {
                    return ((DaysAdjustment)bean).getDays();
                }
                case -178324674: {
                    return ((DaysAdjustment)bean).getCalendar();
                }
                case 1977085293: {
                    return ((DaysAdjustment)bean).getAdjustment();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

