/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.DateSequence;
import com.opengamma.strata.collect.ArgChecker;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;

enum StandardDateSequences implements DateSequence
{
    QUARTERLY_IMM("Quarterly-IMM"){

        @Override
        public LocalDate next(LocalDate date) {
            return this.nth(date, 1);
        }

        @Override
        public LocalDate nextOrSame(LocalDate date) {
            return this.nthOrSame(date, 1);
        }

        @Override
        public LocalDate nth(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate base = date.with(THIRD_WEDNESDAY);
            if (!base.isAfter(date)) {
                base = base.plusMonths(1L);
            }
            return this.shift(base, sequenceNumber);
        }

        @Override
        public LocalDate nthOrSame(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate base = date.with(THIRD_WEDNESDAY);
            if (base.isBefore(date)) {
                base = base.plusMonths(1L);
            }
            return this.shift(base, sequenceNumber);
        }

        private LocalDate shift(LocalDate base, int sequenceNumber) {
            int month = base.getMonthValue();
            int offset = (month % 3 == 0 ? 0 : 3 - month % 3) + (sequenceNumber - 1) * 3;
            return base.plusMonths(offset).with(THIRD_WEDNESDAY);
        }

        @Override
        public LocalDate dateMatching(YearMonth yearMonth) {
            return this.nextOrSame(yearMonth.atDay(1));
        }
    }
    ,
    MONTHLY_IMM("Monthly-IMM"){

        @Override
        public LocalDate next(LocalDate date) {
            return this.nth(date, 1);
        }

        @Override
        public LocalDate nextOrSame(LocalDate date) {
            return this.nthOrSame(date, 1);
        }

        @Override
        public LocalDate nth(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate base = date.with(THIRD_WEDNESDAY);
            if (!base.isAfter(date)) {
                return base.plusMonths(sequenceNumber).with(THIRD_WEDNESDAY);
            }
            return base.plusMonths(sequenceNumber - 1).with(THIRD_WEDNESDAY);
        }

        @Override
        public LocalDate nthOrSame(LocalDate date, int sequenceNumber) {
            ArgChecker.notNegativeOrZero((int)sequenceNumber, (String)"sequenceNumber");
            LocalDate base = date.with(THIRD_WEDNESDAY);
            if (base.isBefore(date)) {
                return base.plusMonths(sequenceNumber).with(THIRD_WEDNESDAY);
            }
            return base.plusMonths(sequenceNumber - 1).with(THIRD_WEDNESDAY);
        }

        @Override
        public LocalDate dateMatching(YearMonth yearMonth) {
            return yearMonth.atDay(1).with(THIRD_WEDNESDAY);
        }
    };

    private static final TemporalAdjuster THIRD_WEDNESDAY;
    private final String name;

    private StandardDateSequences(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        THIRD_WEDNESDAY = TemporalAdjusters.dayOfWeekInMonth(3, DayOfWeek.WEDNESDAY);
    }
}

