/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.reportdata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.StringJoiner;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class ReportDataItem {
    private String name;
    private Object input;
    private Object expected;
    @JsonIgnore
    private Exception error;

    public ReportDataItem() {
    }

    public ReportDataItem(String name, Object input, Object expected) {
        this(name, input, expected, null);
    }

    public ReportDataItem(String name, Object input, Object expected, Exception error) {
        this.name = name;
        this.input = input;
        this.expected = expected;
        this.error = error;
    }

    public String getName() {
        return this.name;
    }

    public Object getInput() {
        if (this.error != null) {
            Exceptions.sneakyThrow((Throwable)this.error);
        }
        return this.input;
    }

    public Object getExpected() {
        return this.expected;
    }

    @JsonIgnore
    public Exception getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportDataItem that = (ReportDataItem)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.input, that.input) && Objects.equals(this.expected, that.expected);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.input, this.expected);
    }

    public String toString() {
        return new StringJoiner(", ", ReportDataItem.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("input=" + this.input).add("expected=" + (this.expected == null ? "" : this.expected.toString())).toString();
    }
}

