/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SubstitutionMap {
    private final Map<JavaType, XMLFullyQualifiedName> typeToFullyQualifiedNameMap = new LinkedHashMap<JavaType, XMLFullyQualifiedName>();
    private final Map<XMLFullyQualifiedName, JavaType> fullyQualifiedNameToTypeMap;
    private final Multimap<String, JavaType> localNameToTypeMap = MultimapBuilder.hashKeys().arrayListValues().build();

    public SubstitutionMap(Map<JavaType, XMLFullyQualifiedName> typeToFullyQualifiedNameMap, Map<XMLFullyQualifiedName, JavaType> fullyQualifiedNameToTypeMap) {
        typeToFullyQualifiedNameMap.keySet().stream().sorted((o1, o2) -> {
            if (o1.equals(o2)) {
                return 0;
            }
            if (o1.getRawClass().equals(o2.getRawClass())) {
                return o1.toString().compareTo(o2.toString());
            }
            if (o1.getRawClass().isAssignableFrom(o2.getRawClass())) {
                return 1;
            }
            if (o2.getRawClass().isAssignableFrom(o1.getRawClass())) {
                return -1;
            }
            return o1.toString().compareTo(o2.toString());
        }).forEach(key -> {
            XMLFullyQualifiedName fqn = (XMLFullyQualifiedName)typeToFullyQualifiedNameMap.get(key);
            this.typeToFullyQualifiedNameMap.put((JavaType)key, fqn);
            if (fqn != null && fqn.getName() != null) {
                this.localNameToTypeMap.put((Object)fqn.getName(), key);
            }
        });
        this.fullyQualifiedNameToTypeMap = new LinkedHashMap<XMLFullyQualifiedName, JavaType>(fullyQualifiedNameToTypeMap);
    }

    public String getSubstitutedName(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        return this.typeToFullyQualifiedNameMap.entrySet().stream().filter(e -> ((JavaType)e.getKey()).isTypeOrSuperTypeOf(clazz)).map(e -> ((XMLFullyQualifiedName)e.getValue()).getName()).findFirst().orElse(null);
    }

    public Collection<JavaType> getTypes() {
        return this.typeToFullyQualifiedNameMap.keySet();
    }

    public String getName(JavaType type) {
        XMLFullyQualifiedName fullyQualifiedName = this.typeToFullyQualifiedNameMap.get(type);
        return fullyQualifiedName != null ? fullyQualifiedName.getName() : null;
    }

    public String getNamespace(JavaType type) {
        XMLFullyQualifiedName fullyQualifiedName = this.typeToFullyQualifiedNameMap.get(type);
        return fullyQualifiedName != null ? fullyQualifiedName.getNamespace() : null;
    }

    public JavaType getTypeByFullyQualifiedName(XMLFullyQualifiedName fullyQualifiedName) {
        return this.fullyQualifiedNameToTypeMap.get(fullyQualifiedName);
    }

    public Collection<JavaType> getTypesByLocalName(String localName) {
        return this.localNameToTypeMap.get((Object)localName);
    }

    public static class XMLFullyQualifiedName {
        private final String name;
        private final String namespace;

        public XMLFullyQualifiedName(String name) {
            Matcher namespaceAndLocalNameMatcher = XMLFullyQualifiedName.getNamespaceAndLocalNameMatcher(name);
            this.name = XMLFullyQualifiedName.generateLocalName(name, namespaceAndLocalNameMatcher);
            this.namespace = XMLFullyQualifiedName.generateNamespace(namespaceAndLocalNameMatcher);
        }

        public XMLFullyQualifiedName(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        private static String generateNamespace(Matcher namespaceAndLocalNameMatcher) {
            if (namespaceAndLocalNameMatcher.matches()) {
                return namespaceAndLocalNameMatcher.group(1);
            }
            return null;
        }

        private static String generateLocalName(String name, Matcher namespaceAndLocalNameMatcher) {
            if (namespaceAndLocalNameMatcher.matches()) {
                return namespaceAndLocalNameMatcher.group(2);
            }
            return name;
        }

        private static Matcher getNamespaceAndLocalNameMatcher(String name) {
            Pattern p = Pattern.compile("^(.+)/(.+)$");
            return p.matcher(name);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            XMLFullyQualifiedName that = (XMLFullyQualifiedName)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.namespace);
        }

        public String toString() {
            return this.namespace != null ? this.namespace + "/" + this.name : this.name;
        }
    }
}

