/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml.deserialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.regnosys.rosetta.common.serialisation.xml.SubstitutionMap;
import com.regnosys.rosetta.common.serialisation.xml.deserialization.RosettaModelObjectSizeEstimator;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SubstitutedMethodProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedMethod _annotated;
    protected final transient Method _setter;
    protected final boolean _skipNulls;
    protected final JavaType _substitutedType;
    protected final SubstitutionMap _substitutionMap;

    public SubstitutedMethodProperty(MethodProperty src, JavaType substitutedType, AnnotatedMethod method, SubstitutionMap substitutionMap) {
        super((SettableBeanProperty)src);
        this._annotated = method;
        this._setter = method.getAnnotated();
        this._skipNulls = NullsConstantProvider.isSkipper((NullValueProvider)this._nullProvider);
        this._substitutedType = substitutedType;
        this._substitutionMap = substitutionMap;
    }

    protected SubstitutedMethodProperty(SubstitutedMethodProperty src, JsonDeserializer<?> deser, NullValueProvider nva) {
        super((SettableBeanProperty)src, deser, nva);
        this._annotated = src._annotated;
        this._setter = src._setter;
        this._skipNulls = NullsConstantProvider.isSkipper((NullValueProvider)nva);
        this._substitutedType = src._substitutedType;
        this._substitutionMap = src._substitutionMap;
    }

    protected SubstitutedMethodProperty(SubstitutedMethodProperty src, PropertyName newName) {
        super((SettableBeanProperty)src, newName);
        this._annotated = src._annotated;
        this._setter = src._setter;
        this._skipNulls = src._skipNulls;
        this._substitutedType = src._substitutedType;
        this._substitutionMap = src._substitutionMap;
    }

    protected SubstitutedMethodProperty(SubstitutedMethodProperty src, Method m) {
        super((SettableBeanProperty)src);
        this._annotated = src._annotated;
        this._setter = m;
        this._skipNulls = src._skipNulls;
        this._substitutedType = src._substitutedType;
        this._substitutionMap = src._substitutionMap;
    }

    public JavaType getType() {
        return this._substitutedType;
    }

    private JavaType getActualType(JsonParser p) {
        FromXmlParser xmlParser;
        QName staxName;
        if (p instanceof FromXmlParser && (staxName = (xmlParser = (FromXmlParser)p).getStaxReader().getName()) != null) {
            String namespaceURI = staxName.getNamespaceURI();
            String localName = staxName.getLocalPart();
            if (namespaceURI != null && !namespaceURI.isEmpty()) {
                SubstitutionMap.XMLFullyQualifiedName xmlFullyQualifiedName = new SubstitutionMap.XMLFullyQualifiedName(localName, namespaceURI);
                return this._substitutionMap.getTypeByFullyQualifiedName(xmlFullyQualifiedName);
            }
        }
        return null;
    }

    private String getCurrentElementName(JsonParser p) throws IOException {
        String name = p.currentName();
        if (name != null) {
            return name;
        }
        JsonStreamContext context = p.getParsingContext();
        return context != null ? context.getCurrentName() : null;
    }

    private Collection<JavaType> getCandidateTypesByLocalName(String localName) {
        if (localName == null) {
            return Collections.emptyList();
        }
        return this._substitutionMap.getTypesByLocalName(localName);
    }

    private Object deserializeWithCandidates(JsonParser p, DeserializationContext ctxt, List<JavaType> candidates) throws IOException {
        TokenBuffer buffer = ctxt.bufferAsCopyOfValue(p);
        IOException lastException = null;
        TreeSet<Object> candidateSet = new TreeSet<Object>(Comparator.comparingInt(RosettaModelObjectSizeEstimator::getNumberOfFields));
        for (JavaType candidate : candidates) {
            try {
                JsonParser candidateParser = buffer.asParserOnFirstToken();
                try {
                    JsonDeserializer deserializer = ctxt.findRootValueDeserializer(candidate);
                    candidateSet.add(deserializer.deserialize(candidateParser, ctxt));
                }
                finally {
                    if (candidateParser == null) continue;
                    candidateParser.close();
                }
            }
            catch (IOException e) {
                lastException = e;
            }
        }
        if (!candidateSet.isEmpty()) {
            return candidateSet.last();
        }
        if (lastException != null) {
            throw lastException;
        }
        return null;
    }

    public SettableBeanProperty withName(PropertyName newName) {
        return new SubstitutedMethodProperty(this, newName);
    }

    public SubstitutedMethodProperty withValueDeserializer(JsonDeserializer<?> deser) {
        if (this._valueDeserializer == deser) {
            return this;
        }
        NullValueProvider nvp = this._valueDeserializer == this._nullProvider ? deser : this._nullProvider;
        return new SubstitutedMethodProperty(this, (JsonDeserializer<?>)deser, nvp);
    }

    public SettableBeanProperty withNullProvider(NullValueProvider nva) {
        return new SubstitutedMethodProperty(this, this._valueDeserializer, nva);
    }

    public void fixAccess(DeserializationConfig config) {
        this._annotated.fixAccess(config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return (A)(this._annotated == null ? null : this._annotated.getAnnotation(acls));
    }

    public AnnotatedMember getMember() {
        return this._annotated;
    }

    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        Object value = null;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return;
            }
            value = this._nullProvider.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer == null) {
            if ((value = this.getDeserialisedValue(p, ctxt, value)) == null) {
                if (this._skipNulls) {
                    return;
                }
                value = this._nullProvider.getNullValue(ctxt);
            }
        } else {
            value = this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        }
        try {
            this._setter.invoke(instance, value);
        }
        catch (Exception e) {
            this._throwAsIOE(p, e, value);
        }
    }

    private @Nullable Object getDeserialisedValue(JsonParser p, DeserializationContext ctxt, Object value) throws IOException {
        JavaType actualType = this.getActualType(p);
        if (actualType == null) {
            String localName = this.getCurrentElementName(p);
            ArrayList<JavaType> candidates = new ArrayList<JavaType>(this.getCandidateTypesByLocalName(localName));
            if (candidates.size() > 1) {
                if (candidates.remove(this._substitutedType)) {
                    candidates.add(0, this._substitutedType);
                }
                value = this.deserializeWithCandidates(p, ctxt, candidates);
            } else {
                actualType = candidates.size() == 1 ? (JavaType)candidates.get(0) : this._substitutedType;
            }
        }
        if (actualType != null) {
            JsonDeserializer deserializer = this._valueDeserializer;
            if (!actualType.equals((Object)this._substitutedType)) {
                deserializer = ctxt.findRootValueDeserializer(actualType);
            }
            value = deserializer.deserialize(p, ctxt);
        }
        return value;
    }

    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        Object value = null;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return instance;
            }
            value = this._nullProvider.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer == null) {
            if ((value = this.getDeserialisedValue(p, ctxt, value)) == null) {
                if (this._skipNulls) {
                    return instance;
                }
                value = this._nullProvider.getNullValue(ctxt);
            }
        } else {
            value = this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        }
        try {
            Object result = this._setter.invoke(instance, value);
            return result == null ? instance : result;
        }
        catch (Exception e) {
            this._throwAsIOE(p, e, value);
            return null;
        }
    }

    public final void set(Object instance, Object value) throws IOException {
        if (value == null && this._skipNulls) {
            return;
        }
        try {
            this._setter.invoke(instance, value);
        }
        catch (Exception e) {
            this._throwAsIOE(e, value);
        }
    }

    public Object setAndReturn(Object instance, Object value) throws IOException {
        if (value == null && this._skipNulls) {
            return instance;
        }
        try {
            Object result = this._setter.invoke(instance, value);
            return result == null ? instance : result;
        }
        catch (Exception e) {
            this._throwAsIOE(e, value);
            return null;
        }
    }

    Object readResolve() {
        return new SubstitutedMethodProperty(this, this._annotated.getAnnotated());
    }
}

