/*
 * Decompiled with CFR 0.152.
 */
package drr.base.margin;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.base.margin.CollateralDetails;
import drr.base.margin.ReportableCollateralBase;
import drr.base.margin.meta.CollateralReportInstructionBaseMeta;
import drr.base.trade.ReportableInformationBase;
import drr.base.trade.ReportingSide;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CollateralReportInstructionBase", builder=CollateralReportInstructionBaseBuilderImpl.class, version="7.0.0-dev.101")
@RuneDataType(value="CollateralReportInstructionBase", model="drr", builder=CollateralReportInstructionBaseBuilderImpl.class, version="7.0.0-dev.101")
public interface CollateralReportInstructionBase
extends ReportableCollateralBase {
    public static final CollateralReportInstructionBaseMeta metaData = new CollateralReportInstructionBaseMeta();

    public ReportingSide getReportingSide();

    @Override
    public CollateralReportInstructionBase build();

    @Override
    public CollateralReportInstructionBaseBuilder toBuilder();

    public static CollateralReportInstructionBaseBuilder builder() {
        return new CollateralReportInstructionBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralReportInstructionBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralReportInstructionBase> getType() {
        return CollateralReportInstructionBase.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("collateralDetails"), processor, CollateralDetails.class, this.getCollateralDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformationBase.class, this.getReportableInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.class, this.getReportingSide(), new AttributeMeta[0]);
    }

    public static class CollateralReportInstructionBaseBuilderImpl
    extends ReportableCollateralBase.ReportableCollateralBaseBuilderImpl
    implements CollateralReportInstructionBaseBuilder {
        protected ReportingSide.ReportingSideBuilder reportingSide;

        @Override
        @RosettaAttribute(value="reportingSide", isRequired=true)
        @RuneAttribute(value="reportingSide", isRequired=true)
        public ReportingSide.ReportingSideBuilder getReportingSide() {
            return this.reportingSide;
        }

        @Override
        public ReportingSide.ReportingSideBuilder getOrCreateReportingSide() {
            ReportingSide.ReportingSideBuilder result = this.reportingSide != null ? this.reportingSide : (this.reportingSide = ReportingSide.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralDetails")
        @RuneAttribute(value="collateralDetails")
        public CollateralReportInstructionBaseBuilder setCollateralDetails(CollateralDetails _collateralDetails) {
            this.collateralDetails = _collateralDetails == null ? null : _collateralDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public CollateralReportInstructionBaseBuilder setReportableInformation(ReportableInformationBase _reportableInformation) {
            this.reportableInformation = _reportableInformation == null ? null : _reportableInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingSide", isRequired=true)
        @RuneAttribute(value="reportingSide", isRequired=true)
        public CollateralReportInstructionBaseBuilder setReportingSide(ReportingSide _reportingSide) {
            this.reportingSide = _reportingSide == null ? null : _reportingSide.toBuilder();
            return this;
        }

        @Override
        public CollateralReportInstructionBase build() {
            return new CollateralReportInstructionBaseImpl(this);
        }

        @Override
        public CollateralReportInstructionBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralReportInstructionBaseBuilder prune() {
            super.prune();
            if (this.reportingSide != null && !this.reportingSide.prune().hasData()) {
                this.reportingSide = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getReportingSide() != null && this.getReportingSide().hasData();
        }

        @Override
        public CollateralReportInstructionBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CollateralReportInstructionBaseBuilder o = (CollateralReportInstructionBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingSide(), (RosettaModelObjectBuilder)o.getReportingSide(), this::setReportingSide);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollateralReportInstructionBase _that = (CollateralReportInstructionBase)this.getType().cast(o);
            return Objects.equals(this.reportingSide, _that.getReportingSide());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.reportingSide != null ? this.reportingSide.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CollateralReportInstructionBaseBuilder {reportingSide=" + String.valueOf(this.reportingSide) + "} " + super.toString();
        }
    }

    public static interface CollateralReportInstructionBaseBuilder
    extends CollateralReportInstructionBase,
    ReportableCollateralBase.ReportableCollateralBaseBuilder {
        public ReportingSide.ReportingSideBuilder getOrCreateReportingSide();

        @Override
        public ReportingSide.ReportingSideBuilder getReportingSide();

        @Override
        public CollateralReportInstructionBaseBuilder setCollateralDetails(CollateralDetails var1);

        @Override
        public CollateralReportInstructionBaseBuilder setReportableInformation(ReportableInformationBase var1);

        public CollateralReportInstructionBaseBuilder setReportingSide(ReportingSide var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("collateralDetails"), processor, CollateralDetails.CollateralDetailsBuilder.class, (RosettaModelObjectBuilder)this.getCollateralDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformationBase.ReportableInformationBaseBuilder.class, (RosettaModelObjectBuilder)this.getReportableInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.ReportingSideBuilder.class, this.getReportingSide(), new AttributeMeta[0]);
        }

        @Override
        public CollateralReportInstructionBaseBuilder prune();
    }

    public static class CollateralReportInstructionBaseImpl
    extends ReportableCollateralBase.ReportableCollateralBaseImpl
    implements CollateralReportInstructionBase {
        private final ReportingSide reportingSide;

        protected CollateralReportInstructionBaseImpl(CollateralReportInstructionBaseBuilder builder) {
            super(builder);
            this.reportingSide = Optional.ofNullable(builder.getReportingSide()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="reportingSide", isRequired=true)
        @RuneAttribute(value="reportingSide", isRequired=true)
        public ReportingSide getReportingSide() {
            return this.reportingSide;
        }

        @Override
        public CollateralReportInstructionBase build() {
            return this;
        }

        @Override
        public CollateralReportInstructionBaseBuilder toBuilder() {
            CollateralReportInstructionBaseBuilder builder = CollateralReportInstructionBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralReportInstructionBaseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getReportingSide()).ifPresent(builder::setReportingSide);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollateralReportInstructionBase _that = (CollateralReportInstructionBase)this.getType().cast(o);
            return Objects.equals(this.reportingSide, _that.getReportingSide());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.reportingSide != null ? this.reportingSide.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CollateralReportInstructionBase {reportingSide=" + String.valueOf(this.reportingSide) + "} " + super.toString();
        }
    }
}

