/*
 * Decompiled with CFR 0.152.
 */
package drr.base.margin.functions;

import cdm.event.common.CollateralBalance;
import cdm.product.collateral.CollateralMarginTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.margin.ReportableCollateralBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetCollateralBalancesForMarginTypeDefault.class)
public abstract class GetCollateralBalancesForMarginType
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends CollateralBalance> evaluate(ReportableCollateralBase reportableCollateral, CollateralMarginTypeEnum marginType) {
        List collateralBalances;
        List<CollateralBalance.CollateralBalanceBuilder> collateralBalancesBuilder = this.doEvaluate(reportableCollateral, marginType);
        if (collateralBalancesBuilder == null) {
            collateralBalances = null;
        } else {
            collateralBalances = collateralBalancesBuilder.stream().map(CollateralBalance::build).collect(Collectors.toList());
            this.objectValidator.validate(CollateralBalance.class, collateralBalances);
        }
        return collateralBalances;
    }

    protected abstract List<CollateralBalance.CollateralBalanceBuilder> doEvaluate(ReportableCollateralBase var1, CollateralMarginTypeEnum var2);

    public static class GetCollateralBalancesForMarginTypeDefault
    extends GetCollateralBalancesForMarginType {
        @Override
        protected List<CollateralBalance.CollateralBalanceBuilder> doEvaluate(ReportableCollateralBase reportableCollateral, CollateralMarginTypeEnum marginType) {
            ArrayList<CollateralBalance.CollateralBalanceBuilder> collateralBalances = new ArrayList<CollateralBalance.CollateralBalanceBuilder>();
            return this.assignOutput(collateralBalances, reportableCollateral, marginType);
        }

        protected List<CollateralBalance.CollateralBalanceBuilder> assignOutput(List<CollateralBalance.CollateralBalanceBuilder> collateralBalances, ReportableCollateralBase reportableCollateral, CollateralMarginTypeEnum marginType) {
            MapperC thenArg0 = MapperS.of((Object)reportableCollateral).map("getCollateralDetails", reportableCollateralBase -> reportableCollateralBase.getCollateralDetails()).map("getCollateral", collateralDetails -> collateralDetails.getCollateral()).mapC("getCollateralPortfolio", collateral -> collateral.getCollateralPortfolio()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("Type coercion", referenceWithMetaCollateralPortfolio -> referenceWithMetaCollateralPortfolio == null ? null : referenceWithMetaCollateralPortfolio.getValue()).map("getLegalAgreement", collateralPortfolio -> collateralPortfolio.getLegalAgreement()).map("Type coercion", referenceWithMetaLegalAgreement -> referenceWithMetaLegalAgreement == null ? null : referenceWithMetaLegalAgreement.getValue()).map("getLegalAgreementIdentification", legalAgreement -> legalAgreement.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).map("getCreditSupportAgreementMarginType", agreementName -> agreementName.getCreditSupportAgreementMarginType()), (Mapper)MapperS.of((Object)marginType), (CardinalityOperator)CardinalityOperator.All).get());
            MapperListOfLists thenArg1 = thenArg0.mapItemToList(item -> item.map("Type coercion", referenceWithMetaCollateralPortfolio -> referenceWithMetaCollateralPortfolio == null ? null : referenceWithMetaCollateralPortfolio.getValue()).mapC("getCollateralBalance", collateralPortfolio -> collateralPortfolio.getCollateralBalance()));
            collateralBalances.addAll(this.toBuilder(thenArg1.flattenList().getMulti()));
            return Optional.ofNullable(collateralBalances).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

