/*
 * Decompiled with CFR 0.152.
 */
package drr.base.qualification.product.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=InterestRateReturnSwapDefault.class)
public abstract class InterestRateReturnSwap
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;

    public InterestRatePayout evaluate(Product product) {
        InterestRatePayout interestRatePayout;
        InterestRatePayout.InterestRatePayoutBuilder interestRatePayoutBuilder = this.doEvaluate(product);
        if (interestRatePayoutBuilder == null) {
            interestRatePayout = null;
        } else {
            interestRatePayout = interestRatePayoutBuilder.build();
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)interestRatePayout);
        }
        return interestRatePayout;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product var1);

    public static class InterestRateReturnSwapDefault
    extends InterestRateReturnSwap {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
            InterestRatePayout.InterestRatePayoutBuilder interestRatePayout = InterestRatePayout.builder();
            return this.assignOutput(interestRatePayout, product);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRatePayout, Product product) {
            interestRatePayout = (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get());
            return Optional.ofNullable(interestRatePayout).map(o -> o.prune()).orElse(null);
        }
    }
}

