/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.basket.functions;

import cdm.base.math.CapacityUnitEnum;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.WeatherUnitEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.event.common.Trade;
import cdm.product.asset.ReferencePoolItem;
import cdm.product.template.Basket;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.basket.BasketConstituentsReport;
import drr.base.trade.basket.functions.GetBasket;
import drr.base.trade.basket.functions.GetQuantityForConstituent;
import drr.base.trade.basket.functions.GetQuantityForReferencePoolItem;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForTrade;
import drr.base.trade.underlier.functions.FilterProductIdentifier;
import drr.standards.iso.functions.CapacityUnitToISO20022UnitOfMeasure;
import drr.standards.iso.functions.FinancialUnitToISO20022UnitOfMeasure;
import drr.standards.iso.functions.WeatherUnitToISO20022UnitOfMeasure;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetBasketConstituentsDefault.class)
public abstract class GetBasketConstituents
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CapacityUnitToISO20022UnitOfMeasure capacityUnitToISO20022UnitOfMeasure;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FilterProductIdentifier filterProductIdentifier;
    @Inject
    protected FinancialUnitToISO20022UnitOfMeasure financialUnitToISO20022UnitOfMeasure;
    @Inject
    protected GetBasket getBasket;
    @Inject
    protected GetQuantityForConstituent getQuantityForConstituent;
    @Inject
    protected GetQuantityForReferencePoolItem getQuantityForReferencePoolItem;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected WeatherUnitToISO20022UnitOfMeasure weatherUnitToISO20022UnitOfMeasure;

    public List<? extends BasketConstituentsReport> evaluate(Trade trade) {
        List result;
        List<BasketConstituentsReport.BasketConstituentsReportBuilder> resultBuilder = this.doEvaluate(trade);
        if (resultBuilder == null) {
            result = null;
        } else {
            result = resultBuilder.stream().map(BasketConstituentsReport::build).collect(Collectors.toList());
            this.objectValidator.validate(BasketConstituentsReport.class, result);
        }
        return result;
    }

    protected abstract List<BasketConstituentsReport.BasketConstituentsReportBuilder> doEvaluate(Trade var1);

    protected abstract MapperC<? extends Product> underliers(Trade var1);

    protected abstract MapperC<? extends TradeLot> tradeLots(Trade var1);

    protected abstract MapperC<? extends ReferencePoolItem> referencePoolItems(Trade var1);

    public static class GetBasketConstituentsDefault
    extends GetBasketConstituents {
        @Override
        protected List<BasketConstituentsReport.BasketConstituentsReportBuilder> doEvaluate(Trade trade) {
            ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder> result = new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>();
            return this.assignOutput(result, trade);
        }

        protected List<BasketConstituentsReport.BasketConstituentsReportBuilder> assignOutput(List<BasketConstituentsReport.BasketConstituentsReportBuilder> result, Trade trade) {
            MapperC thenArg0 = this.underliers(trade).map("getBasket", product -> product.getBasket());
            MapperListOfLists thenArg1 = thenArg0.mapItemToList(item -> MapperC.of(this.getBasket.evaluate((Basket)item.get())));
            MapperC thenArg2 = thenArg1.flattenList();
            MapperListOfLists thenArg3 = thenArg2.mapItemToList(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getSecurity", product -> product.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getSecurity", product -> product.getSecurity()).mapC("getProductIdentifier", security -> security.getProductIdentifier());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getLoan", product -> product.getLoan())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getLoan", product -> product.getLoan()).mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getCommodity", product -> product.getCommodity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getCommodity", product -> product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getIndex", product -> product.getIndex())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getIndex", product -> product.getIndex()).mapC("getProductIdentifier", index -> index.getProductIdentifier());
                }
                return MapperC.ofNull();
            });
            MapperListOfLists thenArg4 = thenArg3.mapListToList(item -> {
                ReferenceWithMetaProductIdentifier referenceWithMetaProductIdentifier = (ReferenceWithMetaProductIdentifier)item.get();
                return MapperC.of(Collections.singletonList((ProductIdentifier)MapperS.of((Object)this.filterProductIdentifier.evaluate(item.map("Type coercion", _referenceWithMetaProductIdentifier -> _referenceWithMetaProductIdentifier.getValue()).getMulti(), ProductIdTypeEnum.ISIN)).getOrDefault((Object)(referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()))));
            });
            result.addAll(this.toBuilder(thenArg4.mapListToItem(item -> {
                FieldWithMetaString fieldWithMetaString0 = (FieldWithMetaString)item.map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
                FieldWithMetaString fieldWithMetaString1 = (FieldWithMetaString)item.map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
                FieldWithMetaString fieldWithMetaString2 = (FieldWithMetaString)item.map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get();
                MapperS thenArg = MapperS.of((Object)this.getQuantityForConstituent.evaluate(fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue(), this.tradeLots(trade).getMulti())).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit());
                return MapperS.of((Object)BasketConstituentsReport.builder().setIdentifier(fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()).setSource((ProductIdTypeEnum)item.map("getSource", productIdentifier -> productIdentifier.getSource()).get()).setNumberOfUnits((BigDecimal)MapperS.of((Object)this.getQuantityForConstituent.evaluate(fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue(), this.tradeLots(trade).getMulti())).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get()).setUnitOfMeasure((String)thenArg.mapSingleToItem(_item -> {
                    if (ExpressionOperatorsNullSafe.exists((Mapper)_item.map("getCapacityUnit", unitType -> unitType.getCapacityUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)this.capacityUnitToISO20022UnitOfMeasure.evaluate((CapacityUnitEnum)_item.map("getCapacityUnit", unitType -> unitType.getCapacityUnit()).get()));
                    }
                    if (ExpressionOperatorsNullSafe.exists((Mapper)_item.map("getWeatherUnit", unitType -> unitType.getWeatherUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)this.weatherUnitToISO20022UnitOfMeasure.evaluate((WeatherUnitEnum)_item.map("getWeatherUnit", unitType -> unitType.getWeatherUnit()).get()));
                    }
                    if (ExpressionOperatorsNullSafe.exists((Mapper)_item.map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)this.financialUnitToISO20022UnitOfMeasure.evaluate((FinancialUnitEnum)_item.map("getFinancialUnit", unitType -> unitType.getFinancialUnit()).get()));
                    }
                    return MapperS.ofNull();
                }).get()).build());
            }).getMulti()));
            MapperC<? extends ReferencePoolItem> thenArg5 = this.referencePoolItems(trade);
            MapperListOfLists thenArg6 = thenArg5.mapItemToList(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation()).map("getSecurity", referenceObligation -> referenceObligation.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation()).map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).mapC("getProductIdentifier", security -> security.getProductIdentifier());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation()).map("getLoan", referenceObligation -> referenceObligation.getLoan())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation()).map("getLoan", referenceObligation -> referenceObligation.getLoan()).mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
                }
                return MapperC.ofNull();
            });
            result.addAll(this.toBuilder(thenArg6.mapListToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)MapperS.of((Object)this.filterProductIdentifier.evaluate(item.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti(), ProductIdTypeEnum.ISIN)).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).getOrDefault((Object)((FieldWithMetaString)item.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).get()));
                MapperS thenArg = MapperS.of((Object)this.getQuantityForReferencePoolItem.evaluate((ReferencePoolItem)this.referencePoolItems(trade).get())).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit());
                return MapperS.of((Object)BasketConstituentsReport.builder().setIdentifier(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()).setSource((ProductIdTypeEnum)MapperS.of((Object)this.filterProductIdentifier.evaluate(item.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti(), ProductIdTypeEnum.ISIN)).map("getSource", productIdentifier -> productIdentifier.getSource()).getOrDefault((Object)((ProductIdTypeEnum)item.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getSource", productIdentifier -> productIdentifier.getSource()).get()))).setNumberOfUnits((BigDecimal)MapperS.of((Object)this.getQuantityForReferencePoolItem.evaluate((ReferencePoolItem)this.referencePoolItems(trade).get())).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get()).setUnitOfMeasure((String)thenArg.mapSingleToItem(_item -> {
                    if (ExpressionOperatorsNullSafe.exists((Mapper)_item.map("getCapacityUnit", unitType -> unitType.getCapacityUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)this.capacityUnitToISO20022UnitOfMeasure.evaluate((CapacityUnitEnum)_item.map("getCapacityUnit", unitType -> unitType.getCapacityUnit()).get()));
                    }
                    if (ExpressionOperatorsNullSafe.exists((Mapper)_item.map("getWeatherUnit", unitType -> unitType.getWeatherUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)this.weatherUnitToISO20022UnitOfMeasure.evaluate((WeatherUnitEnum)_item.map("getWeatherUnit", unitType -> unitType.getWeatherUnit()).get()));
                    }
                    if (ExpressionOperatorsNullSafe.exists((Mapper)_item.map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)this.financialUnitToISO20022UnitOfMeasure.evaluate((FinancialUnitEnum)_item.map("getFinancialUnit", unitType -> unitType.getFinancialUnit()).get()));
                    }
                    return MapperS.ofNull();
                }).get()).build());
            }).getMulti()));
            return Optional.ofNullable(result).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperC<? extends Product> underliers(Trade trade) {
            MapperS thenArg = MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade))).map("getPayout", economicTerms -> economicTerms.getPayout());
            MapperC ifThenElseResult = ExpressionOperatorsNullSafe.exists((Mapper)thenArg.mapC("getOptionPayout", payout -> payout.getOptionPayout())).getOrDefault(Boolean.valueOf(false)) != false ? MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((OptionPayout)thenArg.mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getUnderlier", optionPayout -> optionPayout.getUnderlier())}) : (ExpressionOperatorsNullSafe.exists((Mapper)thenArg.mapC("getForwardPayout", payout -> payout.getForwardPayout())).getOrDefault(Boolean.valueOf(false)) != false ? MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((ForwardPayout)thenArg.mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier())}) : (ExpressionOperatorsNullSafe.exists((Mapper)thenArg.mapC("getPerformancePayout", payout -> payout.getPerformancePayout())).getOrDefault(Boolean.valueOf(false)) != false ? thenArg.mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()) : (ExpressionOperatorsNullSafe.exists((Mapper)thenArg.mapC("getCommodityPayout", payout -> payout.getCommodityPayout())).getOrDefault(Boolean.valueOf(false)) != false ? thenArg.mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()) : MapperC.ofNull())));
            return ifThenElseResult;
        }

        @Override
        protected MapperC<? extends TradeLot> tradeLots(Trade trade) {
            return MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot());
        }

        @Override
        protected MapperC<? extends ReferencePoolItem> referencePoolItems(Trade trade) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).map("getReferencePool", basketReferenceInformation -> basketReferenceInformation.getReferencePool()).mapC("getReferencePoolItem", referencePool -> referencePool.getReferencePoolItem()).map("getReferencePair", referencePoolItem -> referencePoolItem.getReferencePair()).map("getReferenceObligation", referencePair -> referencePair.getReferenceObligation())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForTrade.evaluate(trade))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).map("getReferencePool", basketReferenceInformation -> basketReferenceInformation.getReferencePool()).mapC("getReferencePoolItem", referencePool -> referencePool.getReferencePoolItem());
            }
            return MapperC.ofNull();
        }
    }
}

