/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.basket.functions;

import cdm.product.asset.CreditDefaultPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.basket.functions.CreditBasketIdentifier;
import javax.inject.Inject;

@ImplementedBy(value=UnderlierBasketIdentifierDefault.class)
public abstract class UnderlierBasketIdentifier
implements RosettaFunction {
    @Inject
    protected CreditBasketIdentifier creditBasketIdentifier;

    public String evaluate(Product underlier) {
        String identifier = this.doEvaluate(underlier);
        return identifier;
    }

    protected abstract String doEvaluate(Product var1);

    public static class UnderlierBasketIdentifierDefault
    extends UnderlierBasketIdentifier {
        @Override
        protected String doEvaluate(Product underlier) {
            String identifier = null;
            return this.assignOutput(identifier, underlier);
        }

        protected String assignOutput(String identifier, Product underlier) {
            identifier = (String)MapperS.of((Object)underlier).map("getBasket", product -> product.getBasket()).mapC("getProductIdentifier", basket -> basket.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).first().map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue()).getOrDefault((Object)this.creditBasketIdentifier.evaluate((CreditDefaultPayout)MapperS.of((Object)underlier).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).get()));
            return identifier;
        }
    }
}

