/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.price;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.meta.PricePeriodMeta;
import drr.base.util.datetime.ValuePeriodBase;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PricePeriod", builder=PricePeriodBuilderImpl.class, version="7.0.0-dev.101")
@RuneDataType(value="PricePeriod", model="drr", builder=PricePeriodBuilderImpl.class, version="7.0.0-dev.101")
public interface PricePeriod
extends ValuePeriodBase {
    public static final PricePeriodMeta metaData = new PricePeriodMeta();

    public PriceFormat getPrice();

    @Override
    public PricePeriod build();

    @Override
    public PricePeriodBuilder toBuilder();

    public static PricePeriodBuilder builder() {
        return new PricePeriodBuilderImpl();
    }

    default public RosettaMetaData<? extends PricePeriod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PricePeriod> getType() {
        return PricePeriod.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("endDate"), Date.class, (Object)this.getEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("price"), processor, PriceFormat.class, this.getPrice(), new AttributeMeta[0]);
    }

    public static class PricePeriodBuilderImpl
    extends ValuePeriodBase.ValuePeriodBaseBuilderImpl
    implements PricePeriodBuilder {
        protected PriceFormat.PriceFormatBuilder price;

        @Override
        @RosettaAttribute(value="price", isRequired=true)
        @RuneAttribute(value="price", isRequired=true)
        public PriceFormat.PriceFormatBuilder getPrice() {
            return this.price;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreatePrice() {
            PriceFormat.PriceFormatBuilder result = this.price != null ? this.price : (this.price = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public PricePeriodBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="endDate")
        @RuneAttribute(value="endDate")
        public PricePeriodBuilder setEndDate(Date _endDate) {
            this.endDate = _endDate == null ? null : _endDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="price", isRequired=true)
        @RuneAttribute(value="price", isRequired=true)
        public PricePeriodBuilder setPrice(PriceFormat _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        public PricePeriod build() {
            return new PricePeriodImpl(this);
        }

        @Override
        public PricePeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public PricePeriodBuilder prune() {
            super.prune();
            if (this.price != null && !this.price.prune().hasData()) {
                this.price = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getPrice() != null && this.getPrice().hasData();
        }

        @Override
        public PricePeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PricePeriodBuilder o = (PricePeriodBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrice(), (RosettaModelObjectBuilder)o.getPrice(), this::setPrice);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PricePeriod _that = (PricePeriod)this.getType().cast(o);
            return Objects.equals(this.price, _that.getPrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PricePeriodBuilder {price=" + String.valueOf(this.price) + "} " + super.toString();
        }
    }

    public static interface PricePeriodBuilder
    extends PricePeriod,
    ValuePeriodBase.ValuePeriodBaseBuilder {
        public PriceFormat.PriceFormatBuilder getOrCreatePrice();

        @Override
        public PriceFormat.PriceFormatBuilder getPrice();

        @Override
        public PricePeriodBuilder setEffectiveDate(Date var1);

        @Override
        public PricePeriodBuilder setEndDate(Date var1);

        public PricePeriodBuilder setPrice(PriceFormat var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("endDate"), Date.class, (Object)this.getEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, this.getPrice(), new AttributeMeta[0]);
        }

        @Override
        public PricePeriodBuilder prune();
    }

    public static class PricePeriodImpl
    extends ValuePeriodBase.ValuePeriodBaseImpl
    implements PricePeriod {
        private final PriceFormat price;

        protected PricePeriodImpl(PricePeriodBuilder builder) {
            super(builder);
            this.price = Optional.ofNullable(builder.getPrice()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="price", isRequired=true)
        @RuneAttribute(value="price", isRequired=true)
        public PriceFormat getPrice() {
            return this.price;
        }

        @Override
        public PricePeriod build() {
            return this;
        }

        @Override
        public PricePeriodBuilder toBuilder() {
            PricePeriodBuilder builder = PricePeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PricePeriodBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPrice()).ifPresent(builder::setPrice);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PricePeriod _that = (PricePeriod)this.getType().cast(o);
            return Objects.equals(this.price, _that.getPrice());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PricePeriod {price=" + String.valueOf(this.price) + "} " + super.toString();
        }
    }
}

