/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.processor;

import cdm.base.staticdata.party.NaturalPersonRole;
import cdm.base.staticdata.party.NaturalPersonRoleEnum;
import cdm.base.staticdata.party.metafields.FieldWithMetaNaturalPersonRoleEnum;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaNaturalPerson;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.translation.SynonymToEnumMap;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.util.CollectionUtils;
import drr.base.trade.PartyInformation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NaturalPersonMappingProcessor
extends MappingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NaturalPersonMappingProcessor.class);
    private final SynonymToEnumMap synonymToEnumMap;

    public NaturalPersonMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
        this.synonymToEnumMap = context.getSynonymToEnumMap();
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builders, RosettaModelObjectBuilder parent) {
        List<? extends RosettaModelObjectBuilder> naturalPersonRoleBuilders = builders;
        PartyInformation.PartyInformationBuilder partyInformationBuilder = (PartyInformation.PartyInformationBuilder)parent;
        List<Path> relatedPersonHrefOrRolePaths = this.getRelatedPersonPaths();
        HashSet processedIndices = new HashSet();
        HashSet<Integer> processedPartyTradeInformationIndices = new HashSet<Integer>();
        HashSet<Integer> processedRelatedPersonIndices = new HashSet<Integer>();
        int previousPartyTradeInformationSize = 0;
        ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder referenceWithMetaParty = partyInformationBuilder.getOrCreatePartyReference();
        for (int i = 0; i < relatedPersonHrefOrRolePaths.size(); ++i) {
            Path relatedPersonHrefOrRolePath = relatedPersonHrefOrRolePaths.get(i);
            Path relatedPersonPath = (Path)MappingProcessorUtils.subPath((String)"relatedPerson", (Path)relatedPersonHrefOrRolePath).get();
            int currentIndex = relatedPersonPath.getLastElement().forceGetIndex();
            int partyTradeInformationIndex = relatedPersonPath.getParent().getLastElement().forceGetIndex();
            if (processedPartyTradeInformationIndices.contains(partyTradeInformationIndex) && processedRelatedPersonIndices.contains(currentIndex)) continue;
            Optional<String> personReferenceHrefOptional = this.extractPersonReferenceHref(relatedPersonHrefOrRolePath);
            Optional naturalPersonRoleOptional = this.extractRoleValue(relatedPersonHrefOrRolePaths.get(i + 1)).flatMap(this::getNaturalPersonRoleEnum);
            NaturalPersonRole.NaturalPersonRoleBuilder naturalPersonRoleBuilder = (NaturalPersonRole.NaturalPersonRoleBuilder)naturalPersonRoleBuilders.get(currentIndex);
            personReferenceHrefOptional.ifPresent(personReferenceHref -> naturalPersonRoleOptional.ifPresent(naturalPersonRole -> {
                try {
                    FieldWithMetaNaturalPersonRoleEnum.FieldWithMetaNaturalPersonRoleEnumBuilder fieldWithMeta = FieldWithMetaNaturalPersonRoleEnum.builder().setValue(naturalPersonRole);
                    List roles = CollectionUtils.emptyIfNull((List)naturalPersonRoleBuilder.getRole());
                    if (roles.isEmpty() || roles.stream().map(FieldWithMetaNaturalPersonRoleEnum::getValue).filter(Objects::nonNull).noneMatch(existingRole -> existingRole.equals(naturalPersonRole))) {
                        ArrayList<FieldWithMetaNaturalPersonRoleEnum.FieldWithMetaNaturalPersonRoleEnumBuilder> fieldList = new ArrayList<FieldWithMetaNaturalPersonRoleEnum.FieldWithMetaNaturalPersonRoleEnumBuilder>();
                        fieldList.add(fieldWithMeta);
                        naturalPersonRoleBuilder.addRole(fieldList);
                        naturalPersonRoleBuilder.setPersonReference(ReferenceWithMetaNaturalPerson.builder().setExternalReference(personReferenceHref).build());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error setting value for NaturalPersonRoleEnum: " + e.getMessage(), (Throwable)e);
                }
            }));
            processedPartyTradeInformationIndices.add(partyTradeInformationIndex);
            processedRelatedPersonIndices.add(currentIndex);
            if (processedPartyTradeInformationIndices.size() <= previousPartyTradeInformationSize || processedPartyTradeInformationIndices.size() <= 1) continue;
            processedRelatedPersonIndices.clear();
            previousPartyTradeInformationSize = processedPartyTradeInformationIndices.size();
            processedRelatedPersonIndices.add(currentIndex);
        }
    }

    private List<Path> getRelatedPersonPaths() {
        return this.getMappings().stream().filter(mapping -> mapping.getXmlPath().toString().contains(".relatedPerson")).map(Mapping::getXmlPath).collect(Collectors.toList());
    }

    private Optional<NaturalPersonRoleEnum> getNaturalPersonRoleEnum(String role) {
        return this.synonymToEnumMap.getEnumValueOptional(NaturalPersonRoleEnum.class, role);
    }

    private Optional<String> extractPersonReferenceHref(Path path) {
        return this.getMappings().stream().filter(mapping -> {
            String xmlPath = mapping.getXmlPath().toString();
            return xmlPath.endsWith(".personReference.href") && xmlPath.equals(path.toString());
        }).map(Mapping::getXmlValue).filter(Objects::nonNull).map(Object::toString).findFirst();
    }

    private Optional<String> extractRoleValue(Path path) {
        return this.getMappings().stream().filter(mapping -> {
            String xmlPath = mapping.getXmlPath().toString();
            return xmlPath.endsWith(".role") && xmlPath.equals(path.toString());
        }).map(Mapping::getXmlValue).filter(Objects::nonNull).map(Object::toString).findFirst();
    }
}

