/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.valuation.functions;

import cdm.event.common.Valuation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.PositionStateForEvent;
import drr.base.trade.functions.TradeStateForEvent;
import java.time.LocalDate;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetValuationDefault.class)
public abstract class GetValuation
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected PositionStateForEvent positionStateForEvent;
    @Inject
    protected TradeStateForEvent tradeStateForEvent;

    public Valuation evaluate(ReportableEventBase reportableEvent) {
        Valuation valuation;
        Valuation.ValuationBuilder valuationBuilder = this.doEvaluate(reportableEvent);
        if (valuationBuilder == null) {
            valuation = null;
        } else {
            valuation = valuationBuilder.build();
            this.objectValidator.validate(Valuation.class, (RosettaModelObject)valuation);
        }
        return valuation;
    }

    protected abstract Valuation.ValuationBuilder doEvaluate(ReportableEventBase var1);

    public static class GetValuationDefault
    extends GetValuation {
        @Override
        protected Valuation.ValuationBuilder doEvaluate(ReportableEventBase reportableEvent) {
            Valuation.ValuationBuilder valuation = Valuation.builder();
            return this.assignOutput(valuation, reportableEvent);
        }

        protected Valuation.ValuationBuilder assignOutput(Valuation.ValuationBuilder valuation, ReportableEventBase reportableEvent) {
            valuation = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.tradeStateForEvent.evaluate(reportableEvent)).mapC("getValuationHistory", tradeState -> tradeState.getValuationHistory())).getOrDefault(Boolean.valueOf(false)) != false ? (Valuation.ValuationBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.tradeStateForEvent.evaluate(reportableEvent)).mapC("getValuationHistory", tradeState -> tradeState.getValuationHistory()).max(item -> item.map("getTimestamp", _valuation -> _valuation.getTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate()))).get()) : (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.positionStateForEvent.evaluate(reportableEvent)).mapC("getValuationHistory", counterpartyPositionState -> counterpartyPositionState.getValuationHistory())).getOrDefault(Boolean.valueOf(false)) != false ? (Valuation.ValuationBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.positionStateForEvent.evaluate(reportableEvent)).mapC("getValuationHistory", counterpartyPositionState -> counterpartyPositionState.getValuationHistory()).max(item -> item.map("getTimestamp", _valuation -> _valuation.getTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate()))).get()) : null);
            return Optional.ofNullable(valuation).map(o -> o.prune()).orElse(null);
        }
    }
}

