/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.fca.ukemir.refit.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.util.string.functions.StringLength;
import drr.base.util.string.functions.SubString;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import iso20022.auth030.fca.ActiveOrHistoricCurrencyAnd13DecimalAmount__1;
import iso20022.auth030.fca.ActiveOrHistoricCurrencyAnd5DecimalAmount__1;
import iso20022.auth030.fca.AmountAndDirection106__1;
import iso20022.auth030.fca.OptionOrSwaption10__1;
import iso20022.auth030.fca.OptionStyle6Code__1;
import iso20022.auth030.fca.OptionType2Code;
import iso20022.auth030.fca.Schedule4__1;
import iso20022.auth030.fca.SecuritiesTransactionPrice17Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetOptnDefault.class)
public abstract class GetOptn
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;
    @Inject
    protected StringLength stringLength;
    @Inject
    protected SubString subString;

    public OptionOrSwaption10__1 evaluate(FCAUKEMIRTransactionReport drrReport) {
        OptionOrSwaption10__1 optn;
        OptionOrSwaption10__1.OptionOrSwaption10__1Builder optnBuilder = this.doEvaluate(drrReport);
        if (optnBuilder == null) {
            optn = null;
        } else {
            optn = optnBuilder.build();
            this.objectValidator.validate(OptionOrSwaption10__1.class, (RosettaModelObject)optn);
        }
        return optn;
    }

    protected abstract OptionOrSwaption10__1.OptionOrSwaption10__1Builder doEvaluate(FCAUKEMIRTransactionReport var1);

    public static class GetOptnDefault
    extends GetOptn {
        @Override
        protected OptionOrSwaption10__1.OptionOrSwaption10__1Builder doEvaluate(FCAUKEMIRTransactionReport drrReport) {
            OptionOrSwaption10__1.OptionOrSwaption10__1Builder optn = OptionOrSwaption10__1.builder();
            return this.assignOutput(optn, drrReport);
        }

        protected OptionOrSwaption10__1.OptionOrSwaption10__1Builder assignOutput(OptionOrSwaption10__1.OptionOrSwaption10__1Builder optn, FCAUKEMIRTransactionReport drrReport) {
            optn = (OptionOrSwaption10__1.OptionOrSwaption10__1Builder)this.toBuilder((RosettaModelObject)OptionOrSwaption10__1.builder().setTp((OptionType2Code)MapperS.of((Object)drrReport).map("getOptionType", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getOptionType()).checkedMap("to-enum", e -> OptionType2Code.valueOf((String)e.name()), IllegalArgumentException.class).get()).setExrcStyle((OptionStyle6Code__1)MapperS.of((Object)drrReport).map("getOptionStyle", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getOptionStyle()).checkedMap("to-enum", e -> OptionStyle6Code__1.valueOf((String)e.name()), IllegalArgumentException.class).get()).setStrkPric((SecuritiesTransactionPrice17Choice__1)MapperS.of((Object)drrReport).mapSingleToItem(item -> {
                String ifThenElseResult0 = null;
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getContractType()), (Mapper)MapperS.of((Object)((Object)CommonContractType.OPTN)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getContractType()), (Mapper)MapperS.of((Object)((Object)CommonContractType.SWPT)), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.INTR)), (CardinalityOperator)CardinalityOperator.All)), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult0 = ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)this.stringLength.evaluate((String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getStrikePriceCurrency()).get())), (Mapper)MapperS.of((Object)3), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getStrikePriceCurrency()).get(), 5, 3) : (String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getStrikePriceCurrency()).get();
                }
                Boolean ifThenElseResult1 = null;
                if (ExpressionOperatorsNullSafe.lessThan((Mapper)item.map("getStrikePrice", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getStrikePrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult1 = false;
                }
                return MapperS.of((Object)SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getStrikePrice", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getStrikePrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())).setCcy(ifThenElseResult0).build()).setSgn(ifThenElseResult1).build()).setPctg((BigDecimal)item.map("getStrikePrice", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getStrikePrice()).map("getPercentage", priceFormat -> priceFormat.getPercentage()).get()).build());
            }).get()).setStrkPricSchdl(MapperS.of((Object)drrReport).mapC("getStrikePriceSchedule", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getStrikePriceSchedule()).mapItem(item -> {
                AmountAndDirection106__1 ifThenElseResult2 = null;
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    String ifThenElseResult0 = null;
                    if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getContractType()), (Mapper)MapperS.of((Object)((Object)CommonContractType.OPTN)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getContractType()), (Mapper)MapperS.of((Object)((Object)CommonContractType.SWPT)), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.INTR)), (CardinalityOperator)CardinalityOperator.All), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult0 = ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)this.stringLength.evaluate((String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getStrikePriceCurrency()).get())), (Mapper)MapperS.of((Object)3), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getStrikePriceCurrency()).get(), 5, 3) : (String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getStrikePriceCurrency()).get();
                    }
                    Boolean ifThenElseResult1 = null;
                    if (ExpressionOperatorsNullSafe.lessThan((Mapper)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        ifThenElseResult1 = false;
                    }
                    ifThenElseResult2 = AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())).setCcy(ifThenElseResult0).build()).setSgn(ifThenElseResult1).build();
                }
                BigDecimal ifThenElseResult3 = null;
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getPercentage", priceFormat -> priceFormat.getPercentage())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult3 = (BigDecimal)item.map("getPrice", pricePeriod -> pricePeriod.getPrice()).map("getPercentage", priceFormat -> priceFormat.getPercentage()).get();
                }
                return MapperS.of((Object)Schedule4__1.builder().setUadjstdFctvDt((Date)item.map("getEffectiveDate", pricePeriod -> pricePeriod.getEffectiveDate()).get()).setUadjstdEndDt((Date)item.map("getEndDate", pricePeriod -> pricePeriod.getEndDate()).get()).setPric(SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(ifThenElseResult2).setPctg(ifThenElseResult3).build()).build());
            }).getMulti()).setPrmAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount__1.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getOptionPremiumAmount", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getOptionPremiumAmount()).get()).setCcy((String)MapperS.of((Object)drrReport).map("getOptionPremiumCurrency", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getOptionPremiumCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setPrmPmtDt((Date)MapperS.of((Object)drrReport).map("getOptionPremiumPaymentDate", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getOptionPremiumPaymentDate()).get()).setMtrtyDtOfUndrlyg((Date)MapperS.of((Object)drrReport).map("getMaturityDateOfTheUnderlying", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getMaturityDateOfTheUnderlying()).get()).build());
            return Optional.ofNullable(optn).map(o -> o.prune()).orElse(null);
        }
    }
}

