/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.margin;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.asic.rewrite.margin.meta.ASICMarginReportMeta;
import drr.regulation.common.margin.CommonMarginReport;
import drr.standards.iso.CollateralisationType3Code;
import drr.standards.iso.MarginActionEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ASICMarginReport", builder=ASICMarginReportBuilderImpl.class, version="7.0.0-dev.101")
@RuneDataType(value="ASICMarginReport", model="drr", builder=ASICMarginReportBuilderImpl.class, version="7.0.0-dev.101")
public interface ASICMarginReport
extends CommonMarginReport {
    public static final ASICMarginReportMeta metaData = new ASICMarginReportMeta();

    @Override
    public String getCounterparty2();

    public String getUniqueTransactionIdentifierProprietary();

    public String getReportingEntity();

    public String getSmallScaleBuySideEntityIndicator();

    public Boolean getPortfolioContainingNonReportedComponentIndicator();

    public String getTechnicalRecordId();

    public String getExecutionAgentOfCounterparty1();

    @Override
    public ASICMarginReport build();

    @Override
    public ASICMarginReportBuilder toBuilder();

    public static ASICMarginReportBuilder builder() {
        return new ASICMarginReportBuilderImpl();
    }

    default public RosettaMetaData<? extends ASICMarginReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ASICMarginReport> getType() {
        return ASICMarginReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code.class, (Object)this.getCollateralisationCategory(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginPostedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginPostedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginCollectedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginCollectedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralPostedByTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, (Object)this.getCurrencyOfTheExcessCollateralPosted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralCollectedByTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, (Object)this.getCurrencyOfTheExcessCollateralCollected(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingEntity"), String.class, (Object)this.getReportingEntity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, (Object)this.getSmallScaleBuySideEntityIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("portfolioContainingNonReportedComponentIndicator"), Boolean.class, (Object)this.getPortfolioContainingNonReportedComponentIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentOfCounterparty1"), String.class, (Object)this.getExecutionAgentOfCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ASICMarginReportBuilderImpl
    extends CommonMarginReport.CommonMarginReportBuilderImpl
    implements ASICMarginReportBuilder {
        protected String counterparty2;
        protected String uniqueTransactionIdentifierProprietary;
        protected String reportingEntity;
        protected String smallScaleBuySideEntityIndicator;
        protected Boolean portfolioContainingNonReportedComponentIndicator;
        protected String technicalRecordId;
        protected String executionAgentOfCounterparty1;

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="reportingEntity", isRequired=true)
        @RuneAttribute(value="reportingEntity", isRequired=true)
        public String getReportingEntity() {
            return this.reportingEntity;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
        @RuneAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
        public String getSmallScaleBuySideEntityIndicator() {
            return this.smallScaleBuySideEntityIndicator;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportedComponentIndicator")
        @RuneAttribute(value="portfolioContainingNonReportedComponentIndicator")
        public Boolean getPortfolioContainingNonReportedComponentIndicator() {
            return this.portfolioContainingNonReportedComponentIndicator;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty1", isRequired=true)
        @RuneAttribute(value="executionAgentOfCounterparty1", isRequired=true)
        public String getExecutionAgentOfCounterparty1() {
            return this.executionAgentOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ASICMarginReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public ASICMarginReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public ASICMarginReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public ASICMarginReportBuilder setCounterparty2OverriddenAsString(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public ASICMarginReportBuilder setCounterparty2(String _counterparty2) {
            return this.setCounterparty2OverriddenAsString(_counterparty2);
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCode")
        @RuneAttribute(value="collateralPortfolioCode")
        public ASICMarginReportBuilder setCollateralPortfolioCode(String _collateralPortfolioCode) {
            this.collateralPortfolioCode = _collateralPortfolioCode == null ? null : _collateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public ASICMarginReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="uti")
        @RuneAttribute(value="uti")
        public ASICMarginReportBuilder setUti(String _uti) {
            this.uti = _uti == null ? null : _uti;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory")
        @RuneAttribute(value="collateralisationCategory")
        public ASICMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code _collateralisationCategory) {
            this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheCounterparty1PreHaircut")
        public ASICMarginReportBuilder setInitialMarginPostedByTheCounterparty1PreHaircut(BigDecimal _initialMarginPostedByTheCounterparty1PreHaircut) {
            this.initialMarginPostedByTheCounterparty1PreHaircut = _initialMarginPostedByTheCounterparty1PreHaircut == null ? null : _initialMarginPostedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheCounterparty1PostHaircut")
        public ASICMarginReportBuilder setInitialMarginPostedByTheCounterparty1PostHaircut(BigDecimal _initialMarginPostedByTheCounterparty1PostHaircut) {
            this.initialMarginPostedByTheCounterparty1PostHaircut = _initialMarginPostedByTheCounterparty1PostHaircut == null ? null : _initialMarginPostedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByCounterparty1Currency")
        @RuneAttribute(value="initialMarginPostedByCounterparty1Currency")
        public ASICMarginReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginPostedByCounterparty1Currency) {
            this.initialMarginPostedByCounterparty1Currency = _initialMarginPostedByCounterparty1Currency == null ? null : _initialMarginPostedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheCounterparty1PreHaircut")
        public ASICMarginReportBuilder setVariationMarginPostedByTheCounterparty1PreHaircut(BigDecimal _variationMarginPostedByTheCounterparty1PreHaircut) {
            this.variationMarginPostedByTheCounterparty1PreHaircut = _variationMarginPostedByTheCounterparty1PreHaircut == null ? null : _variationMarginPostedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="variationMarginPostedByTheCounterparty1PostHaircut")
        public ASICMarginReportBuilder setVariationMarginPostedByTheCounterparty1PostHaircut(BigDecimal _variationMarginPostedByTheCounterparty1PostHaircut) {
            this.variationMarginPostedByTheCounterparty1PostHaircut = _variationMarginPostedByTheCounterparty1PostHaircut == null ? null : _variationMarginPostedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByCounterparty1Currency")
        @RuneAttribute(value="variationMarginPostedByCounterparty1Currency")
        public ASICMarginReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginPostedByCounterparty1Currency) {
            this.variationMarginPostedByCounterparty1Currency = _variationMarginPostedByCounterparty1Currency == null ? null : _variationMarginPostedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1PreHaircut")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1PreHaircut")
        public ASICMarginReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal _initialMarginCollectedByCounterparty1PreHaircut) {
            this.initialMarginCollectedByCounterparty1PreHaircut = _initialMarginCollectedByCounterparty1PreHaircut == null ? null : _initialMarginCollectedByCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1PostHaircut")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1PostHaircut")
        public ASICMarginReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal _initialMarginCollectedByCounterparty1PostHaircut) {
            this.initialMarginCollectedByCounterparty1PostHaircut = _initialMarginCollectedByCounterparty1PostHaircut == null ? null : _initialMarginCollectedByCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1Currency")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1Currency")
        public ASICMarginReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginCollectedByCounterparty1Currency) {
            this.initialMarginCollectedByCounterparty1Currency = _initialMarginCollectedByCounterparty1Currency == null ? null : _initialMarginCollectedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheCounterparty1PreHaircut")
        public ASICMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PreHaircut(BigDecimal _variationMarginCollectedByTheCounterparty1PreHaircut) {
            this.variationMarginCollectedByTheCounterparty1PreHaircut = _variationMarginCollectedByTheCounterparty1PreHaircut == null ? null : _variationMarginCollectedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheCounterparty1PostHaircut")
        public ASICMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PostHaircut(BigDecimal _variationMarginCollectedByTheCounterparty1PostHaircut) {
            this.variationMarginCollectedByTheCounterparty1PostHaircut = _variationMarginCollectedByTheCounterparty1PostHaircut == null ? null : _variationMarginCollectedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByCounterparty1Currency")
        @RuneAttribute(value="variationMarginCollectedByCounterparty1Currency")
        public ASICMarginReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginCollectedByCounterparty1Currency) {
            this.variationMarginCollectedByCounterparty1Currency = _variationMarginCollectedByCounterparty1Currency == null ? null : _variationMarginCollectedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="excessCollateralPostedByTheCounterparty1")
        @RuneAttribute(value="excessCollateralPostedByTheCounterparty1")
        public ASICMarginReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal _excessCollateralPostedByTheCounterparty1) {
            this.excessCollateralPostedByTheCounterparty1 = _excessCollateralPostedByTheCounterparty1 == null ? null : _excessCollateralPostedByTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralPosted")
        @RuneAttribute(value="currencyOfTheExcessCollateralPosted")
        public ASICMarginReportBuilder setCurrencyOfTheExcessCollateralPosted(String _currencyOfTheExcessCollateralPosted) {
            this.currencyOfTheExcessCollateralPosted = _currencyOfTheExcessCollateralPosted == null ? null : _currencyOfTheExcessCollateralPosted;
            return this;
        }

        @Override
        @RosettaAttribute(value="excessCollateralCollectedByTheCounterparty1")
        @RuneAttribute(value="excessCollateralCollectedByTheCounterparty1")
        public ASICMarginReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal _excessCollateralCollectedByTheCounterparty1) {
            this.excessCollateralCollectedByTheCounterparty1 = _excessCollateralCollectedByTheCounterparty1 == null ? null : _excessCollateralCollectedByTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralCollected")
        @RuneAttribute(value="currencyOfTheExcessCollateralCollected")
        public ASICMarginReportBuilder setCurrencyOfTheExcessCollateralCollected(String _currencyOfTheExcessCollateralCollected) {
            this.currencyOfTheExcessCollateralCollected = _currencyOfTheExcessCollateralCollected == null ? null : _currencyOfTheExcessCollateralCollected;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralTimestamp")
        @RuneAttribute(value="collateralTimestamp")
        public ASICMarginReportBuilder setCollateralTimestamp(ZonedDateTime _collateralTimestamp) {
            this.collateralTimestamp = _collateralTimestamp == null ? null : _collateralTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public ASICMarginReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public ASICMarginReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public ASICMarginReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public ASICMarginReportBuilder setActionType(MarginActionEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public ASICMarginReportBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp")
        @RuneAttribute(value="eventTimestamp")
        public ASICMarginReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public ASICMarginReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingEntity", isRequired=true)
        @RuneAttribute(value="reportingEntity", isRequired=true)
        public ASICMarginReportBuilder setReportingEntity(String _reportingEntity) {
            this.reportingEntity = _reportingEntity == null ? null : _reportingEntity;
            return this;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
        @RuneAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
        public ASICMarginReportBuilder setSmallScaleBuySideEntityIndicator(String _smallScaleBuySideEntityIndicator) {
            this.smallScaleBuySideEntityIndicator = _smallScaleBuySideEntityIndicator == null ? null : _smallScaleBuySideEntityIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportedComponentIndicator")
        @RuneAttribute(value="portfolioContainingNonReportedComponentIndicator")
        public ASICMarginReportBuilder setPortfolioContainingNonReportedComponentIndicator(Boolean _portfolioContainingNonReportedComponentIndicator) {
            this.portfolioContainingNonReportedComponentIndicator = _portfolioContainingNonReportedComponentIndicator == null ? null : _portfolioContainingNonReportedComponentIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public ASICMarginReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty1", isRequired=true)
        @RuneAttribute(value="executionAgentOfCounterparty1", isRequired=true)
        public ASICMarginReportBuilder setExecutionAgentOfCounterparty1(String _executionAgentOfCounterparty1) {
            this.executionAgentOfCounterparty1 = _executionAgentOfCounterparty1 == null ? null : _executionAgentOfCounterparty1;
            return this;
        }

        @Override
        public ASICMarginReport build() {
            return new ASICMarginReportImpl(this);
        }

        @Override
        public ASICMarginReportBuilder toBuilder() {
            return this;
        }

        @Override
        public ASICMarginReportBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifierProprietary() != null) {
                return true;
            }
            if (this.getReportingEntity() != null) {
                return true;
            }
            if (this.getSmallScaleBuySideEntityIndicator() != null) {
                return true;
            }
            if (this.getPortfolioContainingNonReportedComponentIndicator() != null) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            return this.getExecutionAgentOfCounterparty1() != null;
        }

        @Override
        public ASICMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ASICMarginReportBuilder o = (ASICMarginReportBuilder)other;
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2OverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifierProprietary(), (Object)o.getUniqueTransactionIdentifierProprietary(), this::setUniqueTransactionIdentifierProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingEntity(), (Object)o.getReportingEntity(), this::setReportingEntity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSmallScaleBuySideEntityIndicator(), (Object)o.getSmallScaleBuySideEntityIndicator(), this::setSmallScaleBuySideEntityIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPortfolioContainingNonReportedComponentIndicator(), (Object)o.getPortfolioContainingNonReportedComponentIndicator(), this::setPortfolioContainingNonReportedComponentIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentOfCounterparty1(), (Object)o.getExecutionAgentOfCounterparty1(), this::setExecutionAgentOfCounterparty1, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ASICMarginReport _that = (ASICMarginReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals(this.reportingEntity, _that.getReportingEntity())) {
                return false;
            }
            if (!Objects.equals(this.smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator())) {
                return false;
            }
            if (!Objects.equals(this.portfolioContainingNonReportedComponentIndicator, _that.getPortfolioContainingNonReportedComponentIndicator())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            return Objects.equals(this.executionAgentOfCounterparty1, _that.getExecutionAgentOfCounterparty1());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.reportingEntity != null ? this.reportingEntity.hashCode() : 0);
            _result = 31 * _result + (this.smallScaleBuySideEntityIndicator != null ? this.smallScaleBuySideEntityIndicator.hashCode() : 0);
            _result = 31 * _result + (this.portfolioContainingNonReportedComponentIndicator != null ? this.portfolioContainingNonReportedComponentIndicator.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfCounterparty1 != null ? this.executionAgentOfCounterparty1.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ASICMarginReportBuilder {counterparty2=" + this.counterparty2 + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", reportingEntity=" + this.reportingEntity + ", smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + ", portfolioContainingNonReportedComponentIndicator=" + this.portfolioContainingNonReportedComponentIndicator + ", technicalRecordId=" + this.technicalRecordId + ", executionAgentOfCounterparty1=" + this.executionAgentOfCounterparty1 + "} " + super.toString();
        }
    }

    public static interface ASICMarginReportBuilder
    extends ASICMarginReport,
    CommonMarginReport.CommonMarginReportBuilder {
        @Override
        public ASICMarginReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public ASICMarginReportBuilder setCounterparty1(String var1);

        @Override
        public ASICMarginReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public ASICMarginReportBuilder setCounterparty2(String var1);

        @Override
        public ASICMarginReportBuilder setCollateralPortfolioCode(String var1);

        @Override
        public ASICMarginReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        @Override
        public ASICMarginReportBuilder setUti(String var1);

        @Override
        public ASICMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code var1);

        @Override
        public ASICMarginReportBuilder setInitialMarginPostedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public ASICMarginReportBuilder setInitialMarginPostedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public ASICMarginReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public ASICMarginReportBuilder setVariationMarginPostedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public ASICMarginReportBuilder setVariationMarginPostedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public ASICMarginReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public ASICMarginReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public ASICMarginReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public ASICMarginReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public ASICMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public ASICMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public ASICMarginReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public ASICMarginReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal var1);

        @Override
        public ASICMarginReportBuilder setCurrencyOfTheExcessCollateralPosted(String var1);

        @Override
        public ASICMarginReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal var1);

        @Override
        public ASICMarginReportBuilder setCurrencyOfTheExcessCollateralCollected(String var1);

        @Override
        public ASICMarginReportBuilder setCollateralTimestamp(ZonedDateTime var1);

        @Override
        public ASICMarginReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public ASICMarginReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public ASICMarginReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public ASICMarginReportBuilder setActionType(MarginActionEnum var1);

        @Override
        public ASICMarginReportBuilder setEventDate(Date var1);

        @Override
        public ASICMarginReportBuilder setEventTimestamp(ZonedDateTime var1);

        public ASICMarginReportBuilder setCounterparty2OverriddenAsString(String var1);

        public ASICMarginReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        public ASICMarginReportBuilder setReportingEntity(String var1);

        public ASICMarginReportBuilder setSmallScaleBuySideEntityIndicator(String var1);

        public ASICMarginReportBuilder setPortfolioContainingNonReportedComponentIndicator(Boolean var1);

        public ASICMarginReportBuilder setTechnicalRecordId(String var1);

        public ASICMarginReportBuilder setExecutionAgentOfCounterparty1(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code.class, (Object)this.getCollateralisationCategory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginPostedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginPostedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginCollectedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginCollectedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralPostedByTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, (Object)this.getCurrencyOfTheExcessCollateralPosted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralCollectedByTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, (Object)this.getCurrencyOfTheExcessCollateralCollected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingEntity"), String.class, (Object)this.getReportingEntity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, (Object)this.getSmallScaleBuySideEntityIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("portfolioContainingNonReportedComponentIndicator"), Boolean.class, (Object)this.getPortfolioContainingNonReportedComponentIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentOfCounterparty1"), String.class, (Object)this.getExecutionAgentOfCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public ASICMarginReportBuilder prune();
    }

    public static class ASICMarginReportImpl
    extends CommonMarginReport.CommonMarginReportImpl
    implements ASICMarginReport {
        private final String counterparty2;
        private final String uniqueTransactionIdentifierProprietary;
        private final String reportingEntity;
        private final String smallScaleBuySideEntityIndicator;
        private final Boolean portfolioContainingNonReportedComponentIndicator;
        private final String technicalRecordId;
        private final String executionAgentOfCounterparty1;

        protected ASICMarginReportImpl(ASICMarginReportBuilder builder) {
            super(builder);
            this.counterparty2 = builder.getCounterparty2();
            this.uniqueTransactionIdentifierProprietary = builder.getUniqueTransactionIdentifierProprietary();
            this.reportingEntity = builder.getReportingEntity();
            this.smallScaleBuySideEntityIndicator = builder.getSmallScaleBuySideEntityIndicator();
            this.portfolioContainingNonReportedComponentIndicator = builder.getPortfolioContainingNonReportedComponentIndicator();
            this.technicalRecordId = builder.getTechnicalRecordId();
            this.executionAgentOfCounterparty1 = builder.getExecutionAgentOfCounterparty1();
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="reportingEntity", isRequired=true)
        @RuneAttribute(value="reportingEntity", isRequired=true)
        public String getReportingEntity() {
            return this.reportingEntity;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
        @RuneAttribute(value="smallScaleBuySideEntityIndicator", isRequired=true)
        public String getSmallScaleBuySideEntityIndicator() {
            return this.smallScaleBuySideEntityIndicator;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportedComponentIndicator")
        @RuneAttribute(value="portfolioContainingNonReportedComponentIndicator")
        public Boolean getPortfolioContainingNonReportedComponentIndicator() {
            return this.portfolioContainingNonReportedComponentIndicator;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfCounterparty1", isRequired=true)
        @RuneAttribute(value="executionAgentOfCounterparty1", isRequired=true)
        public String getExecutionAgentOfCounterparty1() {
            return this.executionAgentOfCounterparty1;
        }

        @Override
        public ASICMarginReport build() {
            return this;
        }

        @Override
        public ASICMarginReportBuilder toBuilder() {
            ASICMarginReportBuilder builder = ASICMarginReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ASICMarginReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCounterparty2()).ifPresent(builder::setCounterparty2OverriddenAsString);
            Optional.ofNullable(this.getUniqueTransactionIdentifierProprietary()).ifPresent(builder::setUniqueTransactionIdentifierProprietary);
            Optional.ofNullable(this.getReportingEntity()).ifPresent(builder::setReportingEntity);
            Optional.ofNullable(this.getSmallScaleBuySideEntityIndicator()).ifPresent(builder::setSmallScaleBuySideEntityIndicator);
            Optional.ofNullable(this.getPortfolioContainingNonReportedComponentIndicator()).ifPresent(builder::setPortfolioContainingNonReportedComponentIndicator);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
            Optional.ofNullable(this.getExecutionAgentOfCounterparty1()).ifPresent(builder::setExecutionAgentOfCounterparty1);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ASICMarginReport _that = (ASICMarginReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals(this.reportingEntity, _that.getReportingEntity())) {
                return false;
            }
            if (!Objects.equals(this.smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator())) {
                return false;
            }
            if (!Objects.equals(this.portfolioContainingNonReportedComponentIndicator, _that.getPortfolioContainingNonReportedComponentIndicator())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            return Objects.equals(this.executionAgentOfCounterparty1, _that.getExecutionAgentOfCounterparty1());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.reportingEntity != null ? this.reportingEntity.hashCode() : 0);
            _result = 31 * _result + (this.smallScaleBuySideEntityIndicator != null ? this.smallScaleBuySideEntityIndicator.hashCode() : 0);
            _result = 31 * _result + (this.portfolioContainingNonReportedComponentIndicator != null ? this.portfolioContainingNonReportedComponentIndicator.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfCounterparty1 != null ? this.executionAgentOfCounterparty1.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ASICMarginReport {counterparty2=" + this.counterparty2 + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", reportingEntity=" + this.reportingEntity + ", smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + ", portfolioContainingNonReportedComponentIndicator=" + this.portfolioContainingNonReportedComponentIndicator + ", technicalRecordId=" + this.technicalRecordId + ", executionAgentOfCounterparty1=" + this.executionAgentOfCounterparty1 + "} " + super.toString();
        }
    }
}

