/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.margin.ASICMarginReport;
import drr.regulation.asic.rewrite.margin.labels.ASICMarginLabelProvider;
import drr.regulation.asic.rewrite.margin.reports.ActionTypeRule;
import drr.regulation.asic.rewrite.margin.reports.ExecutionAgentOfCounterparty1Rule;
import drr.regulation.asic.rewrite.margin.reports.PortfolioContainingNonReportedComponentIndicatorRule;
import drr.regulation.asic.rewrite.margin.reports.ReportingEntityRule;
import drr.regulation.asic.rewrite.margin.reports.SmallScaleBuySideEntityIndicatorRule;
import drr.regulation.asic.rewrite.margin.reports.TechnicalRecordIdRule;
import drr.regulation.asic.rewrite.margin.reports.UniqueTransactionIdentifierProprietaryRule;
import drr.regulation.asic.rewrite.margin.reports.UniqueTransactionIdentifierRule;
import drr.regulation.common.CollateralReportInstruction;
import drr.regulation.common.margin.collateral.reports.CollateralPortfolioIndicatorRule;
import drr.regulation.common.margin.collateral.reports.CollateralTimestampRule;
import drr.regulation.common.margin.collateral.reports.CollateralisationCategoryRule;
import drr.regulation.common.margin.collateral.reports.CurrencyOfExcessCollateralCollectedRule;
import drr.regulation.common.margin.collateral.reports.CurrencyOfTheExcessCollateralPostedRule;
import drr.regulation.common.margin.collateral.reports.InitialMarginCollateralPortfolioCodeRule;
import drr.regulation.common.margin.collateral.reports.InitialMarginCollectedByCounterparty1CurrencyRule;
import drr.regulation.common.margin.collateral.reports.InitialMarginCollectedByCounterparty1PostHaircutRule;
import drr.regulation.common.margin.collateral.reports.InitialMarginCollectedByCounterparty1PreHaircutRule;
import drr.regulation.common.margin.collateral.reports.InitialMarginPostedByCounterparty1CurrencyRule;
import drr.regulation.common.margin.collateral.reports.InitialMarginPostedByTheCounterparty1PostHaircutRule;
import drr.regulation.common.margin.collateral.reports.InitialMarginPostedByTheCounterparty1PreHaircutRule;
import drr.regulation.common.margin.collateral.reports.VariationMarginCollateralPortfolioCodeRule;
import drr.regulation.common.margin.collateral.reports.VariationMarginCollectedByCounterparty1CurrencyRule;
import drr.regulation.common.margin.collateral.reports.VariationMarginCollectedByTheCounterparty1PreHaircutRule;
import drr.regulation.common.margin.collateral.reports.VariationMarginPostedByCounterparty1CurrencyRule;
import drr.regulation.common.margin.collateral.reports.VariationMarginPostedByTheCounterparty1PreHaircutRule;
import drr.regulation.common.margin.datetime.reports.ReportingTimestampRule;
import drr.regulation.common.margin.party.reports.Counterparty1Rule;
import drr.regulation.common.margin.party.reports.Counterparty2IdentifierTypeRule;
import drr.regulation.common.margin.party.reports.Counterparty2Rule;
import drr.regulation.common.margin.party.reports.ReportSubmittingEntityIDRule;
import java.util.Optional;
import javax.inject.Inject;

@RosettaReport(namespace="drr.regulation.asic.rewrite.margin", body="ASIC", corpusList={"Margin"})
@RuneLabelProvider(labelProvider=ASICMarginLabelProvider.class)
@ImplementedBy(value=ASICMarginReportFunctionDefault.class)
public abstract class ASICMarginReportFunction
implements ReportFunction<CollateralReportInstruction, ASICMarginReport> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
    @Inject
    protected CollateralTimestampRule collateralTimestampRule;
    @Inject
    protected CollateralisationCategoryRule collateralisationCategoryRule;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
    @Inject
    protected Counterparty2Rule counterparty2Rule;
    @Inject
    protected CurrencyOfExcessCollateralCollectedRule currencyOfExcessCollateralCollectedRule;
    @Inject
    protected CurrencyOfTheExcessCollateralPostedRule currencyOfTheExcessCollateralPostedRule;
    @Inject
    protected ExecutionAgentOfCounterparty1Rule executionAgentOfCounterparty1Rule;
    @Inject
    protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
    @Inject
    protected InitialMarginCollectedByCounterparty1CurrencyRule initialMarginCollectedByCounterparty1CurrencyRule;
    @Inject
    protected InitialMarginCollectedByCounterparty1PostHaircutRule initialMarginCollectedByCounterparty1PostHaircutRule;
    @Inject
    protected InitialMarginCollectedByCounterparty1PreHaircutRule initialMarginCollectedByCounterparty1PreHaircutRule;
    @Inject
    protected InitialMarginPostedByCounterparty1CurrencyRule initialMarginPostedByCounterparty1CurrencyRule;
    @Inject
    protected InitialMarginPostedByTheCounterparty1PostHaircutRule initialMarginPostedByTheCounterparty1PostHaircutRule;
    @Inject
    protected InitialMarginPostedByTheCounterparty1PreHaircutRule initialMarginPostedByTheCounterparty1PreHaircutRule;
    @Inject
    protected PortfolioContainingNonReportedComponentIndicatorRule portfolioContainingNonReportedComponentIndicatorRule;
    @Inject
    protected ReportSubmittingEntityIDRule reportSubmittingEntityIDRule;
    @Inject
    protected ReportingEntityRule reportingEntityRule;
    @Inject
    protected ReportingTimestampRule reportingTimestampRule;
    @Inject
    protected SmallScaleBuySideEntityIndicatorRule smallScaleBuySideEntityIndicatorRule;
    @Inject
    protected TechnicalRecordIdRule technicalRecordIdRule;
    @Inject
    protected UniqueTransactionIdentifierProprietaryRule uniqueTransactionIdentifierProprietaryRule;
    @Inject
    protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
    @Inject
    protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;
    @Inject
    protected VariationMarginCollectedByCounterparty1CurrencyRule variationMarginCollectedByCounterparty1CurrencyRule;
    @Inject
    protected VariationMarginCollectedByTheCounterparty1PreHaircutRule variationMarginCollectedByTheCounterparty1PreHaircutRule;
    @Inject
    protected VariationMarginPostedByCounterparty1CurrencyRule variationMarginPostedByCounterparty1CurrencyRule;
    @Inject
    protected VariationMarginPostedByTheCounterparty1PreHaircutRule variationMarginPostedByTheCounterparty1PreHaircutRule;

    public ASICMarginReport evaluate(CollateralReportInstruction input) {
        ASICMarginReport output;
        ASICMarginReport.ASICMarginReportBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(ASICMarginReport.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract ASICMarginReport.ASICMarginReportBuilder doEvaluate(CollateralReportInstruction var1);

    public static class ASICMarginReportFunctionDefault
    extends ASICMarginReportFunction {
        @Override
        protected ASICMarginReport.ASICMarginReportBuilder doEvaluate(CollateralReportInstruction input) {
            ASICMarginReport.ASICMarginReportBuilder output = ASICMarginReport.builder();
            return this.assignOutput(output, input);
        }

        protected ASICMarginReport.ASICMarginReportBuilder assignOutput(ASICMarginReport.ASICMarginReportBuilder output, CollateralReportInstruction input) {
            output.setReportingTimestamp(this.reportingTimestampRule.evaluate(input));
            output.setCounterparty1(this.counterparty1Rule.evaluate(input));
            output.setCounterparty2IdentifierType(this.counterparty2IdentifierTypeRule.evaluate(input));
            output.setCounterparty2OverriddenAsString(this.counterparty2Rule.evaluate(input));
            output.setCollateralPortfolioIndicator(this.collateralPortfolioIndicatorRule.evaluate(input));
            output.setUti(this.uniqueTransactionIdentifierRule.evaluate(input));
            output.setCollateralisationCategory(this.collateralisationCategoryRule.evaluate(input));
            output.setInitialMarginPostedByTheCounterparty1PreHaircut(this.initialMarginPostedByTheCounterparty1PreHaircutRule.evaluate(input));
            output.setInitialMarginPostedByTheCounterparty1PostHaircut(this.initialMarginPostedByTheCounterparty1PostHaircutRule.evaluate(input));
            output.setInitialMarginPostedByCounterparty1Currency(this.initialMarginPostedByCounterparty1CurrencyRule.evaluate(input));
            output.setVariationMarginPostedByTheCounterparty1PreHaircut(this.variationMarginPostedByTheCounterparty1PreHaircutRule.evaluate(input));
            output.setVariationMarginPostedByCounterparty1Currency(this.variationMarginPostedByCounterparty1CurrencyRule.evaluate(input));
            output.setInitialMarginCollectedByCounterparty1PreHaircut(this.initialMarginCollectedByCounterparty1PreHaircutRule.evaluate(input));
            output.setInitialMarginCollectedByCounterparty1PostHaircut(this.initialMarginCollectedByCounterparty1PostHaircutRule.evaluate(input));
            output.setInitialMarginCollectedByCounterparty1Currency(this.initialMarginCollectedByCounterparty1CurrencyRule.evaluate(input));
            output.setVariationMarginCollectedByTheCounterparty1PreHaircut(this.variationMarginCollectedByTheCounterparty1PreHaircutRule.evaluate(input));
            output.setVariationMarginCollectedByCounterparty1Currency(this.variationMarginCollectedByCounterparty1CurrencyRule.evaluate(input));
            output.setCurrencyOfTheExcessCollateralPosted(this.currencyOfTheExcessCollateralPostedRule.evaluate(input));
            output.setCurrencyOfTheExcessCollateralCollected(this.currencyOfExcessCollateralCollectedRule.evaluate(input));
            output.setCollateralTimestamp(this.collateralTimestampRule.evaluate(input));
            output.setVariationMarginCollateralPortfolioCode(this.variationMarginCollateralPortfolioCodeRule.evaluate(input));
            output.setInitialMarginCollateralPortfolioCode(this.initialMarginCollateralPortfolioCodeRule.evaluate(input));
            output.setReportSubmittingEntityID(this.reportSubmittingEntityIDRule.evaluate(input));
            output.setActionType(this.actionTypeRule.evaluate(input));
            output.setUniqueTransactionIdentifierProprietary(this.uniqueTransactionIdentifierProprietaryRule.evaluate(input));
            output.setReportingEntity(this.reportingEntityRule.evaluate(input));
            output.setSmallScaleBuySideEntityIndicator(this.smallScaleBuySideEntityIndicatorRule.evaluate(input));
            output.setPortfolioContainingNonReportedComponentIndicator(this.portfolioContainingNonReportedComponentIndicatorRule.evaluate(input));
            output.setTechnicalRecordId(this.technicalRecordIdRule.evaluate(input));
            output.setExecutionAgentOfCounterparty1(this.executionAgentOfCounterparty1Rule.evaluate(input));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

