/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.valuation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.asic.rewrite.valuation.meta.ASICValuationReportMeta;
import drr.regulation.common.valuation.CommonValuationReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ASICValuationReport", builder=ASICValuationReportBuilderImpl.class, version="7.0.0-dev.101")
@RuneDataType(value="ASICValuationReport", model="drr", builder=ASICValuationReportBuilderImpl.class, version="7.0.0-dev.101")
public interface ASICValuationReport
extends CommonValuationReport {
    public static final ASICValuationReportMeta metaData = new ASICValuationReportMeta();

    @Override
    public Boolean getCounterparty2IdentifierType();

    @Override
    public String getEntityResponsibleForReporting();

    @Override
    public String getReportSubmittingEntityID();

    @Override
    public String getTechnicalRecordId();

    public String getExecutionAgentOfTheCounterparty2();

    public String getExecutionAgentOfTheCounterparty1();

    public String getSmallScaleBuySideEntityIndicator();

    @Override
    public ASICValuationReport build();

    @Override
    public ASICValuationReportBuilder toBuilder();

    public static ASICValuationReportBuilder builder() {
        return new ASICValuationReportBuilderImpl();
    }

    default public RosettaMetaData<? extends ASICValuationReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ASICValuationReport> getType() {
        return ASICValuationReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg1"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg2"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty2"), String.class, (Object)this.getExecutionAgentOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty1"), String.class, (Object)this.getExecutionAgentOfTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, (Object)this.getSmallScaleBuySideEntityIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ASICValuationReportBuilderImpl
    extends CommonValuationReport.CommonValuationReportBuilderImpl
    implements ASICValuationReportBuilder {
        protected Boolean counterparty2IdentifierType;
        protected String entityResponsibleForReporting;
        protected String reportSubmittingEntityID;
        protected String technicalRecordId;
        protected String executionAgentOfTheCounterparty2;
        protected String executionAgentOfTheCounterparty1;
        protected String smallScaleBuySideEntityIndicator;

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting", isRequired=true)
        @RuneAttribute(value="entityResponsibleForReporting", isRequired=true)
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty2")
        @RuneAttribute(value="executionAgentOfTheCounterparty2")
        public String getExecutionAgentOfTheCounterparty2() {
            return this.executionAgentOfTheCounterparty2;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty1")
        @RuneAttribute(value="executionAgentOfTheCounterparty1")
        public String getExecutionAgentOfTheCounterparty1() {
            return this.executionAgentOfTheCounterparty1;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator")
        @RuneAttribute(value="smallScaleBuySideEntityIndicator")
        public String getSmallScaleBuySideEntityIndicator() {
            return this.smallScaleBuySideEntityIndicator;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ASICValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public ASICValuationReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public ASICValuationReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public ASICValuationReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            return this.setCounterparty2IdentifierTypeOverriddenAsBoolean(_counterparty2IdentifierType);
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public ASICValuationReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public ASICValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public ASICValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public ASICValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public ASICValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public ASICValuationReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public ASICValuationReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public ASICValuationReportBuilder setLevel(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public ASICValuationReportBuilder setTechnicalRecordIdOverriddenAsString(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public ASICValuationReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            return this.setTechnicalRecordIdOverriddenAsString(_technicalRecordId);
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public ASICValuationReportBuilder setReportSubmittingEntityIDOverriddenAsString(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public ASICValuationReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            return this.setReportSubmittingEntityIDOverriddenAsString(_reportSubmittingEntityID);
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting", isRequired=true)
        @RuneAttribute(value="entityResponsibleForReporting", isRequired=true)
        public ASICValuationReportBuilder setEntityResponsibleForReportingOverriddenAsString(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public ASICValuationReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            return this.setEntityResponsibleForReportingOverriddenAsString(_entityResponsibleForReporting);
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource")
        @RuneAttribute(value="counterparty2IdentifierSource")
        public ASICValuationReportBuilder setCounterparty2IdentifierSource(String _counterparty2IdentifierSource) {
            this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public ASICValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date _nextFloatingReferenceResetDateLeg1) {
            this.nextFloatingReferenceResetDateLeg1 = _nextFloatingReferenceResetDateLeg1 == null ? null : _nextFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public ASICValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date _nextFloatingReferenceResetDateLeg2) {
            this.nextFloatingReferenceResetDateLeg2 = _nextFloatingReferenceResetDateLeg2 == null ? null : _nextFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public ASICValuationReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public ASICValuationReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public ASICValuationReportBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public ASICValuationReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public ASICValuationReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg1")
        @RuneAttribute(value="lastFloatingReferenceValueLeg1")
        public ASICValuationReportBuilder setLastFloatingReferenceValueLeg1(BigDecimal _lastFloatingReferenceValueLeg1) {
            this.lastFloatingReferenceValueLeg1 = _lastFloatingReferenceValueLeg1 == null ? null : _lastFloatingReferenceValueLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg2")
        @RuneAttribute(value="lastFloatingReferenceValueLeg2")
        public ASICValuationReportBuilder setLastFloatingReferenceValueLeg2(BigDecimal _lastFloatingReferenceValueLeg2) {
            this.lastFloatingReferenceValueLeg2 = _lastFloatingReferenceValueLeg2 == null ? null : _lastFloatingReferenceValueLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg1")
        public ASICValuationReportBuilder setLastFloatingReferenceResetDateLeg1(Date _lastFloatingReferenceResetDateLeg1) {
            this.lastFloatingReferenceResetDateLeg1 = _lastFloatingReferenceResetDateLeg1 == null ? null : _lastFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg2")
        public ASICValuationReportBuilder setLastFloatingReferenceResetDateLeg2(Date _lastFloatingReferenceResetDateLeg2) {
            this.lastFloatingReferenceResetDateLeg2 = _lastFloatingReferenceResetDateLeg2 == null ? null : _lastFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty2")
        @RuneAttribute(value="executionAgentOfTheCounterparty2")
        public ASICValuationReportBuilder setExecutionAgentOfTheCounterparty2(String _executionAgentOfTheCounterparty2) {
            this.executionAgentOfTheCounterparty2 = _executionAgentOfTheCounterparty2 == null ? null : _executionAgentOfTheCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty1")
        @RuneAttribute(value="executionAgentOfTheCounterparty1")
        public ASICValuationReportBuilder setExecutionAgentOfTheCounterparty1(String _executionAgentOfTheCounterparty1) {
            this.executionAgentOfTheCounterparty1 = _executionAgentOfTheCounterparty1 == null ? null : _executionAgentOfTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator")
        @RuneAttribute(value="smallScaleBuySideEntityIndicator")
        public ASICValuationReportBuilder setSmallScaleBuySideEntityIndicator(String _smallScaleBuySideEntityIndicator) {
            this.smallScaleBuySideEntityIndicator = _smallScaleBuySideEntityIndicator == null ? null : _smallScaleBuySideEntityIndicator;
            return this;
        }

        @Override
        public ASICValuationReport build() {
            return new ASICValuationReportImpl(this);
        }

        @Override
        public ASICValuationReportBuilder toBuilder() {
            return this;
        }

        @Override
        public ASICValuationReportBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCounterparty2IdentifierType() != null) {
                return true;
            }
            if (this.getEntityResponsibleForReporting() != null) {
                return true;
            }
            if (this.getReportSubmittingEntityID() != null) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            if (this.getExecutionAgentOfTheCounterparty2() != null) {
                return true;
            }
            if (this.getExecutionAgentOfTheCounterparty1() != null) {
                return true;
            }
            return this.getSmallScaleBuySideEntityIndicator() != null;
        }

        @Override
        public ASICValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ASICValuationReportBuilder o = (ASICValuationReportBuilder)other;
            merger.mergeBasic((Object)this.getCounterparty2IdentifierType(), (Object)o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierTypeOverriddenAsBoolean, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEntityResponsibleForReporting(), (Object)o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReportingOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportSubmittingEntityID(), (Object)o.getReportSubmittingEntityID(), this::setReportSubmittingEntityIDOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordIdOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentOfTheCounterparty2(), (Object)o.getExecutionAgentOfTheCounterparty2(), this::setExecutionAgentOfTheCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentOfTheCounterparty1(), (Object)o.getExecutionAgentOfTheCounterparty1(), this::setExecutionAgentOfTheCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSmallScaleBuySideEntityIndicator(), (Object)o.getSmallScaleBuySideEntityIndicator(), this::setSmallScaleBuySideEntityIndicator, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ASICValuationReport _that = (ASICValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfTheCounterparty2, _that.getExecutionAgentOfTheCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfTheCounterparty1, _that.getExecutionAgentOfTheCounterparty1())) {
                return false;
            }
            return Objects.equals(this.smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfTheCounterparty2 != null ? this.executionAgentOfTheCounterparty2.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfTheCounterparty1 != null ? this.executionAgentOfTheCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.smallScaleBuySideEntityIndicator != null ? this.smallScaleBuySideEntityIndicator.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ASICValuationReportBuilder {counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", technicalRecordId=" + this.technicalRecordId + ", executionAgentOfTheCounterparty2=" + this.executionAgentOfTheCounterparty2 + ", executionAgentOfTheCounterparty1=" + this.executionAgentOfTheCounterparty1 + ", smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + "} " + super.toString();
        }
    }

    public static interface ASICValuationReportBuilder
    extends ASICValuationReport,
    CommonValuationReport.CommonValuationReportBuilder {
        @Override
        public ASICValuationReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public ASICValuationReportBuilder setCounterparty1(String var1);

        @Override
        public ASICValuationReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public ASICValuationReportBuilder setCounterparty2(String var1);

        @Override
        public ASICValuationReportBuilder setValuationAmount(BigDecimal var1);

        @Override
        public ASICValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public ASICValuationReportBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public ASICValuationReportBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public ASICValuationReportBuilder setDelta(BigDecimal var1);

        @Override
        public ASICValuationReportBuilder setActionType(ActionTypeEnum var1);

        @Override
        public ASICValuationReportBuilder setLevel(ReportLevelEnum var1);

        @Override
        public ASICValuationReportBuilder setTechnicalRecordId(String var1);

        @Override
        public ASICValuationReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public ASICValuationReportBuilder setEntityResponsibleForReporting(String var1);

        @Override
        public ASICValuationReportBuilder setCounterparty2IdentifierSource(String var1);

        @Override
        public ASICValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date var1);

        @Override
        public ASICValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date var1);

        @Override
        public ASICValuationReportBuilder setUniqueTransactionIdentifier(String var1);

        @Override
        public ASICValuationReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        @Override
        public ASICValuationReportBuilder setEventDate(Date var1);

        @Override
        public ASICValuationReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public ASICValuationReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public ASICValuationReportBuilder setLastFloatingReferenceValueLeg1(BigDecimal var1);

        @Override
        public ASICValuationReportBuilder setLastFloatingReferenceValueLeg2(BigDecimal var1);

        @Override
        public ASICValuationReportBuilder setLastFloatingReferenceResetDateLeg1(Date var1);

        @Override
        public ASICValuationReportBuilder setLastFloatingReferenceResetDateLeg2(Date var1);

        public ASICValuationReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean var1);

        public ASICValuationReportBuilder setEntityResponsibleForReportingOverriddenAsString(String var1);

        public ASICValuationReportBuilder setReportSubmittingEntityIDOverriddenAsString(String var1);

        public ASICValuationReportBuilder setTechnicalRecordIdOverriddenAsString(String var1);

        public ASICValuationReportBuilder setExecutionAgentOfTheCounterparty2(String var1);

        public ASICValuationReportBuilder setExecutionAgentOfTheCounterparty1(String var1);

        public ASICValuationReportBuilder setSmallScaleBuySideEntityIndicator(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg1"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg2"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty2"), String.class, (Object)this.getExecutionAgentOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty1"), String.class, (Object)this.getExecutionAgentOfTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, (Object)this.getSmallScaleBuySideEntityIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public ASICValuationReportBuilder prune();
    }

    public static class ASICValuationReportImpl
    extends CommonValuationReport.CommonValuationReportImpl
    implements ASICValuationReport {
        private final Boolean counterparty2IdentifierType;
        private final String entityResponsibleForReporting;
        private final String reportSubmittingEntityID;
        private final String technicalRecordId;
        private final String executionAgentOfTheCounterparty2;
        private final String executionAgentOfTheCounterparty1;
        private final String smallScaleBuySideEntityIndicator;

        protected ASICValuationReportImpl(ASICValuationReportBuilder builder) {
            super(builder);
            this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
            this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
            this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
            this.technicalRecordId = builder.getTechnicalRecordId();
            this.executionAgentOfTheCounterparty2 = builder.getExecutionAgentOfTheCounterparty2();
            this.executionAgentOfTheCounterparty1 = builder.getExecutionAgentOfTheCounterparty1();
            this.smallScaleBuySideEntityIndicator = builder.getSmallScaleBuySideEntityIndicator();
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting", isRequired=true)
        @RuneAttribute(value="entityResponsibleForReporting", isRequired=true)
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty2")
        @RuneAttribute(value="executionAgentOfTheCounterparty2")
        public String getExecutionAgentOfTheCounterparty2() {
            return this.executionAgentOfTheCounterparty2;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty1")
        @RuneAttribute(value="executionAgentOfTheCounterparty1")
        public String getExecutionAgentOfTheCounterparty1() {
            return this.executionAgentOfTheCounterparty1;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideEntityIndicator")
        @RuneAttribute(value="smallScaleBuySideEntityIndicator")
        public String getSmallScaleBuySideEntityIndicator() {
            return this.smallScaleBuySideEntityIndicator;
        }

        @Override
        public ASICValuationReport build() {
            return this;
        }

        @Override
        public ASICValuationReportBuilder toBuilder() {
            ASICValuationReportBuilder builder = ASICValuationReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ASICValuationReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierTypeOverriddenAsBoolean);
            Optional.ofNullable(this.getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReportingOverriddenAsString);
            Optional.ofNullable(this.getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityIDOverriddenAsString);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordIdOverriddenAsString);
            Optional.ofNullable(this.getExecutionAgentOfTheCounterparty2()).ifPresent(builder::setExecutionAgentOfTheCounterparty2);
            Optional.ofNullable(this.getExecutionAgentOfTheCounterparty1()).ifPresent(builder::setExecutionAgentOfTheCounterparty1);
            Optional.ofNullable(this.getSmallScaleBuySideEntityIndicator()).ifPresent(builder::setSmallScaleBuySideEntityIndicator);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ASICValuationReport _that = (ASICValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfTheCounterparty2, _that.getExecutionAgentOfTheCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfTheCounterparty1, _that.getExecutionAgentOfTheCounterparty1())) {
                return false;
            }
            return Objects.equals(this.smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfTheCounterparty2 != null ? this.executionAgentOfTheCounterparty2.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfTheCounterparty1 != null ? this.executionAgentOfTheCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.smallScaleBuySideEntityIndicator != null ? this.smallScaleBuySideEntityIndicator.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ASICValuationReport {counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", technicalRecordId=" + this.technicalRecordId + ", executionAgentOfTheCounterparty2=" + this.executionAgentOfTheCounterparty2 + ", executionAgentOfTheCounterparty1=" + this.executionAgentOfTheCounterparty1 + ", smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + "} " + super.toString();
        }
    }
}

