/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.reports.PayoutForQuantityLeg1Rule;
import drr.standards.iosco.cde.version2.quantity.reports.NotionalCurrencyRule;
import javax.inject.Inject;

@ImplementedBy(value=NotionalCurrencyLeg1RuleDefault.class)
public abstract class NotionalCurrencyLeg1Rule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected IsAllowableActionForCFTC isAllowableActionForCFTC;
    @Inject
    protected NotionalCurrencyRule notionalCurrencyRule;
    @Inject
    protected PayoutForQuantityLeg1Rule payoutForQuantityLeg1Rule;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class NotionalCurrencyLeg1RuleDefault
    extends NotionalCurrencyLeg1Rule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCFTC.evaluate((ReportableEventBase)item.get()));
            output = (ISOCurrencyCodeEnum)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.notionalCurrencyRule.evaluate(this.payoutForQuantityLeg1Rule.evaluate((TransactionReportInstruction)item.get())))).get();
            return output;
        }
    }
}

