/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.regulation.common.CreditDocumentEnum;
import drr.regulation.common.OrganizationCharacteristicEnum;
import drr.regulation.common.TransactionCharacteristicEnum;
import drr.regulation.common.meta.ClearingExceptionDeclarationMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ClearingExceptionDeclaration", builder=ClearingExceptionDeclarationBuilderImpl.class, version="7.0.0-dev.101")
@RuneDataType(value="ClearingExceptionDeclaration", model="drr", builder=ClearingExceptionDeclarationBuilderImpl.class, version="7.0.0-dev.101")
public interface ClearingExceptionDeclaration
extends RosettaModelObject {
    public static final ClearingExceptionDeclarationMeta metaData = new ClearingExceptionDeclarationMeta();

    public List<CreditDocumentEnum> getCreditDocument();

    public List<OrganizationCharacteristicEnum> getOrganizationCharacteristic();

    public List<TransactionCharacteristicEnum> getTransactionCharacteristic();

    public ClearingExceptionDeclaration build();

    public ClearingExceptionDeclarationBuilder toBuilder();

    public static ClearingExceptionDeclarationBuilder builder() {
        return new ClearingExceptionDeclarationBuilderImpl();
    }

    default public RosettaMetaData<? extends ClearingExceptionDeclaration> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ClearingExceptionDeclaration> getType() {
        return ClearingExceptionDeclaration.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("creditDocument"), CreditDocumentEnum.class, this.getCreditDocument(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("organizationCharacteristic"), OrganizationCharacteristicEnum.class, this.getOrganizationCharacteristic(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("transactionCharacteristic"), TransactionCharacteristicEnum.class, this.getTransactionCharacteristic(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ClearingExceptionDeclarationBuilderImpl
    implements ClearingExceptionDeclarationBuilder {
        protected List<CreditDocumentEnum> creditDocument = new ArrayList<CreditDocumentEnum>();
        protected List<OrganizationCharacteristicEnum> organizationCharacteristic = new ArrayList<OrganizationCharacteristicEnum>();
        protected List<TransactionCharacteristicEnum> transactionCharacteristic = new ArrayList<TransactionCharacteristicEnum>();

        @Override
        @RosettaAttribute(value="creditDocument")
        @RuneAttribute(value="creditDocument")
        public List<CreditDocumentEnum> getCreditDocument() {
            return this.creditDocument;
        }

        @Override
        @RosettaAttribute(value="organizationCharacteristic")
        @RuneAttribute(value="organizationCharacteristic")
        public List<OrganizationCharacteristicEnum> getOrganizationCharacteristic() {
            return this.organizationCharacteristic;
        }

        @Override
        @RosettaAttribute(value="transactionCharacteristic")
        @RuneAttribute(value="transactionCharacteristic")
        public List<TransactionCharacteristicEnum> getTransactionCharacteristic() {
            return this.transactionCharacteristic;
        }

        @Override
        @RosettaAttribute(value="creditDocument")
        @RuneAttribute(value="creditDocument")
        public ClearingExceptionDeclarationBuilder addCreditDocument(CreditDocumentEnum _creditDocument) {
            if (_creditDocument != null) {
                this.creditDocument.add(_creditDocument);
            }
            return this;
        }

        @Override
        public ClearingExceptionDeclarationBuilder addCreditDocument(CreditDocumentEnum _creditDocument, int idx) {
            this.getIndex(this.creditDocument, idx, () -> _creditDocument);
            return this;
        }

        @Override
        public ClearingExceptionDeclarationBuilder addCreditDocument(List<CreditDocumentEnum> creditDocuments) {
            if (creditDocuments != null) {
                for (CreditDocumentEnum toAdd : creditDocuments) {
                    this.creditDocument.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="creditDocument")
        public ClearingExceptionDeclarationBuilder setCreditDocument(List<CreditDocumentEnum> creditDocuments) {
            this.creditDocument = creditDocuments == null ? new ArrayList<CreditDocumentEnum>() : (List)creditDocuments.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="organizationCharacteristic")
        @RuneAttribute(value="organizationCharacteristic")
        public ClearingExceptionDeclarationBuilder addOrganizationCharacteristic(OrganizationCharacteristicEnum _organizationCharacteristic) {
            if (_organizationCharacteristic != null) {
                this.organizationCharacteristic.add(_organizationCharacteristic);
            }
            return this;
        }

        @Override
        public ClearingExceptionDeclarationBuilder addOrganizationCharacteristic(OrganizationCharacteristicEnum _organizationCharacteristic, int idx) {
            this.getIndex(this.organizationCharacteristic, idx, () -> _organizationCharacteristic);
            return this;
        }

        @Override
        public ClearingExceptionDeclarationBuilder addOrganizationCharacteristic(List<OrganizationCharacteristicEnum> organizationCharacteristics) {
            if (organizationCharacteristics != null) {
                for (OrganizationCharacteristicEnum toAdd : organizationCharacteristics) {
                    this.organizationCharacteristic.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="organizationCharacteristic")
        public ClearingExceptionDeclarationBuilder setOrganizationCharacteristic(List<OrganizationCharacteristicEnum> organizationCharacteristics) {
            this.organizationCharacteristic = organizationCharacteristics == null ? new ArrayList<OrganizationCharacteristicEnum>() : (List)organizationCharacteristics.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="transactionCharacteristic")
        @RuneAttribute(value="transactionCharacteristic")
        public ClearingExceptionDeclarationBuilder addTransactionCharacteristic(TransactionCharacteristicEnum _transactionCharacteristic) {
            if (_transactionCharacteristic != null) {
                this.transactionCharacteristic.add(_transactionCharacteristic);
            }
            return this;
        }

        @Override
        public ClearingExceptionDeclarationBuilder addTransactionCharacteristic(TransactionCharacteristicEnum _transactionCharacteristic, int idx) {
            this.getIndex(this.transactionCharacteristic, idx, () -> _transactionCharacteristic);
            return this;
        }

        @Override
        public ClearingExceptionDeclarationBuilder addTransactionCharacteristic(List<TransactionCharacteristicEnum> transactionCharacteristics) {
            if (transactionCharacteristics != null) {
                for (TransactionCharacteristicEnum toAdd : transactionCharacteristics) {
                    this.transactionCharacteristic.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="transactionCharacteristic")
        public ClearingExceptionDeclarationBuilder setTransactionCharacteristic(List<TransactionCharacteristicEnum> transactionCharacteristics) {
            this.transactionCharacteristic = transactionCharacteristics == null ? new ArrayList<TransactionCharacteristicEnum>() : (List)transactionCharacteristics.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ClearingExceptionDeclaration build() {
            return new ClearingExceptionDeclarationImpl(this);
        }

        @Override
        public ClearingExceptionDeclarationBuilder toBuilder() {
            return this;
        }

        @Override
        public ClearingExceptionDeclarationBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getCreditDocument() != null && !this.getCreditDocument().isEmpty()) {
                return true;
            }
            if (this.getOrganizationCharacteristic() != null && !this.getOrganizationCharacteristic().isEmpty()) {
                return true;
            }
            return this.getTransactionCharacteristic() != null && !this.getTransactionCharacteristic().isEmpty();
        }

        public ClearingExceptionDeclarationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ClearingExceptionDeclarationBuilder o = (ClearingExceptionDeclarationBuilder)other;
            merger.mergeBasic(this.getCreditDocument(), o.getCreditDocument(), this::addCreditDocument);
            merger.mergeBasic(this.getOrganizationCharacteristic(), o.getOrganizationCharacteristic(), this::addOrganizationCharacteristic);
            merger.mergeBasic(this.getTransactionCharacteristic(), o.getTransactionCharacteristic(), this::addTransactionCharacteristic);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ClearingExceptionDeclaration _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.creditDocument, _that.getCreditDocument())) {
                return false;
            }
            if (!ListEquals.listEquals(this.organizationCharacteristic, _that.getOrganizationCharacteristic())) {
                return false;
            }
            return ListEquals.listEquals(this.transactionCharacteristic, _that.getTransactionCharacteristic());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.creditDocument != null ? this.creditDocument.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.organizationCharacteristic != null ? this.organizationCharacteristic.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.transactionCharacteristic != null ? this.transactionCharacteristic.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            return _result;
        }

        public String toString() {
            return "ClearingExceptionDeclarationBuilder {creditDocument=" + String.valueOf(this.creditDocument) + ", organizationCharacteristic=" + String.valueOf(this.organizationCharacteristic) + ", transactionCharacteristic=" + String.valueOf(this.transactionCharacteristic) + "}";
        }
    }

    public static interface ClearingExceptionDeclarationBuilder
    extends ClearingExceptionDeclaration,
    RosettaModelObjectBuilder {
        public ClearingExceptionDeclarationBuilder addCreditDocument(CreditDocumentEnum var1);

        public ClearingExceptionDeclarationBuilder addCreditDocument(CreditDocumentEnum var1, int var2);

        public ClearingExceptionDeclarationBuilder addCreditDocument(List<CreditDocumentEnum> var1);

        public ClearingExceptionDeclarationBuilder setCreditDocument(List<CreditDocumentEnum> var1);

        public ClearingExceptionDeclarationBuilder addOrganizationCharacteristic(OrganizationCharacteristicEnum var1);

        public ClearingExceptionDeclarationBuilder addOrganizationCharacteristic(OrganizationCharacteristicEnum var1, int var2);

        public ClearingExceptionDeclarationBuilder addOrganizationCharacteristic(List<OrganizationCharacteristicEnum> var1);

        public ClearingExceptionDeclarationBuilder setOrganizationCharacteristic(List<OrganizationCharacteristicEnum> var1);

        public ClearingExceptionDeclarationBuilder addTransactionCharacteristic(TransactionCharacteristicEnum var1);

        public ClearingExceptionDeclarationBuilder addTransactionCharacteristic(TransactionCharacteristicEnum var1, int var2);

        public ClearingExceptionDeclarationBuilder addTransactionCharacteristic(List<TransactionCharacteristicEnum> var1);

        public ClearingExceptionDeclarationBuilder setTransactionCharacteristic(List<TransactionCharacteristicEnum> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("creditDocument"), CreditDocumentEnum.class, this.getCreditDocument(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("organizationCharacteristic"), OrganizationCharacteristicEnum.class, this.getOrganizationCharacteristic(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("transactionCharacteristic"), TransactionCharacteristicEnum.class, this.getTransactionCharacteristic(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ClearingExceptionDeclarationBuilder prune();
    }

    public static class ClearingExceptionDeclarationImpl
    implements ClearingExceptionDeclaration {
        private final List<CreditDocumentEnum> creditDocument;
        private final List<OrganizationCharacteristicEnum> organizationCharacteristic;
        private final List<TransactionCharacteristicEnum> transactionCharacteristic;

        protected ClearingExceptionDeclarationImpl(ClearingExceptionDeclarationBuilder builder) {
            this.creditDocument = Optional.ofNullable(builder.getCreditDocument()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.organizationCharacteristic = Optional.ofNullable(builder.getOrganizationCharacteristic()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.transactionCharacteristic = Optional.ofNullable(builder.getTransactionCharacteristic()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="creditDocument")
        @RuneAttribute(value="creditDocument")
        public List<CreditDocumentEnum> getCreditDocument() {
            return this.creditDocument;
        }

        @Override
        @RosettaAttribute(value="organizationCharacteristic")
        @RuneAttribute(value="organizationCharacteristic")
        public List<OrganizationCharacteristicEnum> getOrganizationCharacteristic() {
            return this.organizationCharacteristic;
        }

        @Override
        @RosettaAttribute(value="transactionCharacteristic")
        @RuneAttribute(value="transactionCharacteristic")
        public List<TransactionCharacteristicEnum> getTransactionCharacteristic() {
            return this.transactionCharacteristic;
        }

        @Override
        public ClearingExceptionDeclaration build() {
            return this;
        }

        @Override
        public ClearingExceptionDeclarationBuilder toBuilder() {
            ClearingExceptionDeclarationBuilder builder = ClearingExceptionDeclaration.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ClearingExceptionDeclarationBuilder builder) {
            Optional.ofNullable(this.getCreditDocument()).ifPresent(builder::setCreditDocument);
            Optional.ofNullable(this.getOrganizationCharacteristic()).ifPresent(builder::setOrganizationCharacteristic);
            Optional.ofNullable(this.getTransactionCharacteristic()).ifPresent(builder::setTransactionCharacteristic);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ClearingExceptionDeclaration _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.creditDocument, _that.getCreditDocument())) {
                return false;
            }
            if (!ListEquals.listEquals(this.organizationCharacteristic, _that.getOrganizationCharacteristic())) {
                return false;
            }
            return ListEquals.listEquals(this.transactionCharacteristic, _that.getTransactionCharacteristic());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.creditDocument != null ? this.creditDocument.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.organizationCharacteristic != null ? this.organizationCharacteristic.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.transactionCharacteristic != null ? this.transactionCharacteristic.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            return _result;
        }

        public String toString() {
            return "ClearingExceptionDeclaration {creditDocument=" + String.valueOf(this.creditDocument) + ", organizationCharacteristic=" + String.valueOf(this.organizationCharacteristic) + ", transactionCharacteristic=" + String.valueOf(this.transactionCharacteristic) + "}";
        }
    }
}

