/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.CorporateSector;
import drr.regulation.common.NatureOfPartyEnum;
import drr.regulation.common.meta.HKMAPartyInformationMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="HKMAPartyInformation", builder=HKMAPartyInformationBuilderImpl.class, version="7.0.0-dev.101")
@RuneDataType(value="HKMAPartyInformation", model="drr", builder=HKMAPartyInformationBuilderImpl.class, version="7.0.0-dev.101")
public interface HKMAPartyInformation
extends RosettaModelObject {
    public static final HKMAPartyInformationMeta metaData = new HKMAPartyInformationMeta();

    public NatureOfPartyEnum getNatureOfParty();

    public Boolean getNonReportedTradePortfolio();

    public CorporateSector getCorporateSector();

    public HKMAPartyInformation build();

    public HKMAPartyInformationBuilder toBuilder();

    public static HKMAPartyInformationBuilder builder() {
        return new HKMAPartyInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends HKMAPartyInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends HKMAPartyInformation> getType() {
        return HKMAPartyInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("natureOfParty"), NatureOfPartyEnum.class, (Object)this.getNatureOfParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonReportedTradePortfolio"), Boolean.class, (Object)this.getNonReportedTradePortfolio(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("corporateSector"), processor, CorporateSector.class, this.getCorporateSector(), new AttributeMeta[0]);
    }

    public static class HKMAPartyInformationBuilderImpl
    implements HKMAPartyInformationBuilder {
        protected NatureOfPartyEnum natureOfParty;
        protected Boolean nonReportedTradePortfolio;
        protected CorporateSector.CorporateSectorBuilder corporateSector;

        @Override
        @RosettaAttribute(value="natureOfParty", isRequired=true)
        @RuneAttribute(value="natureOfParty", isRequired=true)
        public NatureOfPartyEnum getNatureOfParty() {
            return this.natureOfParty;
        }

        @Override
        @RosettaAttribute(value="nonReportedTradePortfolio")
        @RuneAttribute(value="nonReportedTradePortfolio")
        public Boolean getNonReportedTradePortfolio() {
            return this.nonReportedTradePortfolio;
        }

        @Override
        @RosettaAttribute(value="corporateSector")
        @RuneAttribute(value="corporateSector")
        public CorporateSector.CorporateSectorBuilder getCorporateSector() {
            return this.corporateSector;
        }

        @Override
        public CorporateSector.CorporateSectorBuilder getOrCreateCorporateSector() {
            CorporateSector.CorporateSectorBuilder result = this.corporateSector != null ? this.corporateSector : (this.corporateSector = CorporateSector.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="natureOfParty", isRequired=true)
        @RuneAttribute(value="natureOfParty", isRequired=true)
        public HKMAPartyInformationBuilder setNatureOfParty(NatureOfPartyEnum _natureOfParty) {
            this.natureOfParty = _natureOfParty == null ? null : _natureOfParty;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonReportedTradePortfolio")
        @RuneAttribute(value="nonReportedTradePortfolio")
        public HKMAPartyInformationBuilder setNonReportedTradePortfolio(Boolean _nonReportedTradePortfolio) {
            this.nonReportedTradePortfolio = _nonReportedTradePortfolio == null ? null : _nonReportedTradePortfolio;
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateSector")
        @RuneAttribute(value="corporateSector")
        public HKMAPartyInformationBuilder setCorporateSector(CorporateSector _corporateSector) {
            this.corporateSector = _corporateSector == null ? null : _corporateSector.toBuilder();
            return this;
        }

        @Override
        public HKMAPartyInformation build() {
            return new HKMAPartyInformationImpl(this);
        }

        @Override
        public HKMAPartyInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public HKMAPartyInformationBuilder prune() {
            if (this.corporateSector != null && !this.corporateSector.prune().hasData()) {
                this.corporateSector = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getNatureOfParty() != null) {
                return true;
            }
            if (this.getNonReportedTradePortfolio() != null) {
                return true;
            }
            return this.getCorporateSector() != null && this.getCorporateSector().hasData();
        }

        public HKMAPartyInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            HKMAPartyInformationBuilder o = (HKMAPartyInformationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCorporateSector(), (RosettaModelObjectBuilder)o.getCorporateSector(), this::setCorporateSector);
            merger.mergeBasic((Object)this.getNatureOfParty(), (Object)o.getNatureOfParty(), this::setNatureOfParty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNonReportedTradePortfolio(), (Object)o.getNonReportedTradePortfolio(), this::setNonReportedTradePortfolio, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            HKMAPartyInformation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.natureOfParty, (Object)_that.getNatureOfParty())) {
                return false;
            }
            if (!Objects.equals(this.nonReportedTradePortfolio, _that.getNonReportedTradePortfolio())) {
                return false;
            }
            return Objects.equals(this.corporateSector, _that.getCorporateSector());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.natureOfParty != null ? ((Object)((Object)this.natureOfParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.nonReportedTradePortfolio != null ? this.nonReportedTradePortfolio.hashCode() : 0);
            _result = 31 * _result + (this.corporateSector != null ? this.corporateSector.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "HKMAPartyInformationBuilder {natureOfParty=" + String.valueOf((Object)this.natureOfParty) + ", nonReportedTradePortfolio=" + this.nonReportedTradePortfolio + ", corporateSector=" + String.valueOf(this.corporateSector) + "}";
        }
    }

    public static interface HKMAPartyInformationBuilder
    extends HKMAPartyInformation,
    RosettaModelObjectBuilder {
        public CorporateSector.CorporateSectorBuilder getOrCreateCorporateSector();

        @Override
        public CorporateSector.CorporateSectorBuilder getCorporateSector();

        public HKMAPartyInformationBuilder setNatureOfParty(NatureOfPartyEnum var1);

        public HKMAPartyInformationBuilder setNonReportedTradePortfolio(Boolean var1);

        public HKMAPartyInformationBuilder setCorporateSector(CorporateSector var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("natureOfParty"), NatureOfPartyEnum.class, (Object)this.getNatureOfParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonReportedTradePortfolio"), Boolean.class, (Object)this.getNonReportedTradePortfolio(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("corporateSector"), processor, CorporateSector.CorporateSectorBuilder.class, this.getCorporateSector(), new AttributeMeta[0]);
        }

        public HKMAPartyInformationBuilder prune();
    }

    public static class HKMAPartyInformationImpl
    implements HKMAPartyInformation {
        private final NatureOfPartyEnum natureOfParty;
        private final Boolean nonReportedTradePortfolio;
        private final CorporateSector corporateSector;

        protected HKMAPartyInformationImpl(HKMAPartyInformationBuilder builder) {
            this.natureOfParty = builder.getNatureOfParty();
            this.nonReportedTradePortfolio = builder.getNonReportedTradePortfolio();
            this.corporateSector = Optional.ofNullable(builder.getCorporateSector()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="natureOfParty", isRequired=true)
        @RuneAttribute(value="natureOfParty", isRequired=true)
        public NatureOfPartyEnum getNatureOfParty() {
            return this.natureOfParty;
        }

        @Override
        @RosettaAttribute(value="nonReportedTradePortfolio")
        @RuneAttribute(value="nonReportedTradePortfolio")
        public Boolean getNonReportedTradePortfolio() {
            return this.nonReportedTradePortfolio;
        }

        @Override
        @RosettaAttribute(value="corporateSector")
        @RuneAttribute(value="corporateSector")
        public CorporateSector getCorporateSector() {
            return this.corporateSector;
        }

        @Override
        public HKMAPartyInformation build() {
            return this;
        }

        @Override
        public HKMAPartyInformationBuilder toBuilder() {
            HKMAPartyInformationBuilder builder = HKMAPartyInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(HKMAPartyInformationBuilder builder) {
            Optional.ofNullable(this.getNatureOfParty()).ifPresent(builder::setNatureOfParty);
            Optional.ofNullable(this.getNonReportedTradePortfolio()).ifPresent(builder::setNonReportedTradePortfolio);
            Optional.ofNullable(this.getCorporateSector()).ifPresent(builder::setCorporateSector);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            HKMAPartyInformation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.natureOfParty, (Object)_that.getNatureOfParty())) {
                return false;
            }
            if (!Objects.equals(this.nonReportedTradePortfolio, _that.getNonReportedTradePortfolio())) {
                return false;
            }
            return Objects.equals(this.corporateSector, _that.getCorporateSector());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.natureOfParty != null ? ((Object)((Object)this.natureOfParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.nonReportedTradePortfolio != null ? this.nonReportedTradePortfolio.hashCode() : 0);
            _result = 31 * _result + (this.corporateSector != null ? this.corporateSector.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "HKMAPartyInformation {natureOfParty=" + String.valueOf((Object)this.natureOfParty) + ", nonReportedTradePortfolio=" + this.nonReportedTradePortfolio + ", corporateSector=" + String.valueOf(this.corporateSector) + "}";
        }
    }
}

