/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.CommodityPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.CalculationPeriodToDaysCommodities;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CommodityCommodityLeg2Default.class)
public abstract class CommodityCommodityLeg2
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CalculationPeriodToDaysCommodities calculationPeriodToDaysCommodities;

    public CommodityPayout evaluate(List<? extends CommodityPayout> commodityPayouts) {
        CommodityPayout commodityLeg2;
        CommodityPayout.CommodityPayoutBuilder commodityLeg2Builder = this.doEvaluate(commodityPayouts);
        if (commodityLeg2Builder == null) {
            commodityLeg2 = null;
        } else {
            commodityLeg2 = commodityLeg2Builder.build();
            this.objectValidator.validate(CommodityPayout.class, (RosettaModelObject)commodityLeg2);
        }
        return commodityLeg2;
    }

    protected abstract CommodityPayout.CommodityPayoutBuilder doEvaluate(List<? extends CommodityPayout> var1);

    public static class CommodityCommodityLeg2Default
    extends CommodityCommodityLeg2 {
        @Override
        protected CommodityPayout.CommodityPayoutBuilder doEvaluate(List<? extends CommodityPayout> commodityPayouts) {
            if (commodityPayouts == null) {
                commodityPayouts = Collections.emptyList();
            }
            CommodityPayout.CommodityPayoutBuilder commodityLeg2 = CommodityPayout.builder();
            return this.assignOutput(commodityLeg2, commodityPayouts);
        }

        protected CommodityPayout.CommodityPayoutBuilder assignOutput(CommodityPayout.CommodityPayoutBuilder commodityLeg2, List<? extends CommodityPayout> commodityPayouts) {
            commodityLeg2 = ExpressionOperatorsNullSafe.exists((Mapper)MapperC.of(commodityPayouts).map("getMeta", a -> a.getMeta()).map("getKey", a -> a.getExternalKey())).getOrDefault(Boolean.valueOf(false)) != false ? (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)MapperC.of(commodityPayouts).max(item -> item.map("getMeta", a -> a.getMeta()).map("getKey", a -> a.getExternalKey())).get()) : (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)ExpressionOperatorsNullSafe.distinct((Mapper)MapperC.of(commodityPayouts).map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).map("getResolvedQuantity", resolvablePriceQuantity -> resolvablePriceQuantity.getResolvedQuantity()).map("getValue", quantity -> quantity.getValue())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)MapperC.of(commodityPayouts).max(item -> MapperS.of((Object)this.calculationPeriodToDaysCommodities.evaluate((CommodityPayout)item.get()))).get()) : (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)MapperC.of(commodityPayouts).min(item -> item.map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).get()));
            return Optional.ofNullable(commodityLeg2).map(o -> o.prune()).orElse(null);
        }
    }
}

