/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.party.Party;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=EqualPartyDefault.class)
public abstract class EqualParty
implements RosettaFunction {
    public Boolean evaluate(List<? extends Party> p1, List<? extends Party> p2) {
        Boolean result = this.doEvaluate(p1, p2);
        return result;
    }

    protected abstract Boolean doEvaluate(List<? extends Party> var1, List<? extends Party> var2);

    protected abstract MapperS<Boolean> sizeEqual(List<? extends Party> var1, List<? extends Party> var2);

    protected abstract MapperS<Boolean> containsAll(List<? extends Party> var1, List<? extends Party> var2);

    public static class EqualPartyDefault
    extends EqualParty {
        @Override
        protected Boolean doEvaluate(List<? extends Party> p1, List<? extends Party> p2) {
            if (p1 == null) {
                p1 = Collections.emptyList();
            }
            if (p2 == null) {
                p2 = Collections.emptyList();
            }
            Boolean result = null;
            return this.assignOutput(result, p1, p2);
        }

        protected Boolean assignOutput(Boolean result, List<? extends Party> p1, List<? extends Party> p2) {
            result = ComparisonResult.ofNullSafe(this.sizeEqual(p1, p2)).andNullSafe(ComparisonResult.ofNullSafe(this.containsAll(p1, p2))).get();
            return result;
        }

        @Override
        protected MapperS<Boolean> sizeEqual(List<? extends Party> p1, List<? extends Party> p2) {
            return ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)MapperC.of(p1).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(p2).resultCount()), (CardinalityOperator)CardinalityOperator.All).asMapper();
        }

        @Override
        protected MapperS<Boolean> containsAll(List<? extends Party> p1, List<? extends Party> p2) {
            MapperC thenArg = MapperC.of(p1).mapItem(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((List)p2), (Mapper)item, (CardinalityOperator)CardinalityOperator.Any).asMapper());
            return ExpressionOperatorsNullSafe.areEqual((Mapper)thenArg, (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).asMapper();
        }
    }
}

