/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.party.EntityIdentifier;
import cdm.base.staticdata.party.EntityIdentifierTypeEnum;
import cdm.base.staticdata.party.LegalEntity;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCredit;
import drr.base.qualification.product.functions.IsCreditSwaption;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ExtractReferenceEntityDefault.class)
public abstract class ExtractReferenceEntity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsCredit isCredit;
    @Inject
    protected IsCreditSwaption isCreditSwaption;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public EntityIdentifier evaluate(ReportableEventBase reportableEvent) {
        EntityIdentifier referenceEntity;
        EntityIdentifier.EntityIdentifierBuilder referenceEntityBuilder = this.doEvaluate(reportableEvent);
        if (referenceEntityBuilder == null) {
            referenceEntity = null;
        } else {
            referenceEntity = referenceEntityBuilder.build();
            this.objectValidator.validate(EntityIdentifier.class, (RosettaModelObject)referenceEntity);
        }
        return referenceEntity;
    }

    protected abstract EntityIdentifier.EntityIdentifierBuilder doEvaluate(ReportableEventBase var1);

    protected abstract MapperS<? extends Product> product(ReportableEventBase var1);

    protected abstract MapperS<? extends LegalEntity> referenceEntityProduct(ReportableEventBase var1);

    protected abstract MapperC<? extends EntityIdentifier> referenceEntityByType(ReportableEventBase var1);

    public static class ExtractReferenceEntityDefault
    extends ExtractReferenceEntity {
        @Override
        protected EntityIdentifier.EntityIdentifierBuilder doEvaluate(ReportableEventBase reportableEvent) {
            EntityIdentifier.EntityIdentifierBuilder referenceEntity = EntityIdentifier.builder();
            return this.assignOutput(referenceEntity, reportableEvent);
        }

        protected EntityIdentifier.EntityIdentifierBuilder assignOutput(EntityIdentifier.EntityIdentifierBuilder referenceEntity, ReportableEventBase reportableEvent) {
            MapperC thenArg = ExpressionOperatorsNullSafe.exists(this.referenceEntityByType(reportableEvent)).getOrDefault(Boolean.valueOf(false)) != false ? this.referenceEntityByType(reportableEvent) : this.referenceEntityProduct(reportableEvent).mapC("getEntityIdentifier", legalEntity -> legalEntity.getEntityIdentifier());
            referenceEntity = (EntityIdentifier.EntityIdentifierBuilder)this.toBuilder((RosettaModelObject)thenArg.last().get());
            return Optional.ofNullable(referenceEntity).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends Product> product(ReportableEventBase reportableEvent) {
            return MapperS.of((Object)this.productForEvent.evaluate(reportableEvent));
        }

        @Override
        protected MapperS<? extends LegalEntity> referenceEntityProduct(ReportableEventBase reportableEvent) {
            Boolean boolean0 = this.isCreditSwaption.evaluate((Product)this.product(reportableEvent).get());
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperS.of((Object)this.underlierForProduct.evaluate((Product)this.product(reportableEvent).get())).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity());
            }
            Boolean boolean1 = this.isCredit.evaluate((Product)this.product(reportableEvent).get());
            if (boolean1 != null && boolean1.booleanValue()) {
                return this.product(reportableEvent).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperC<? extends EntityIdentifier> referenceEntityByType(ReportableEventBase reportableEvent) {
            MapperC thenArg = this.referenceEntityProduct(reportableEvent).mapC("getEntityIdentifier", legalEntity -> legalEntity.getEntityIdentifier());
            return thenArg.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)EntityIdentifierTypeEnum.LEI), MapperS.of((Object)EntityIdentifierTypeEnum.COUNTRY_CODE)}), (Mapper)item.map("getIdentifierType", entityIdentifier -> entityIdentifier.getIdentifierType()), (CardinalityOperator)CardinalityOperator.Any).get());
        }
    }
}

