/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.math.Quantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.QuantityToDeliveryCapacity;
import drr.standards.iso.EnergyQuantityUnit2Code;
import javax.inject.Inject;

@ImplementedBy(value=GetDeliveryCapacityUnitDefault.class)
public abstract class GetDeliveryCapacityUnit
implements RosettaFunction {
    @Inject
    protected QuantityToDeliveryCapacity quantityToDeliveryCapacity;

    public EnergyQuantityUnit2Code evaluate(Quantity deliveryCapacity) {
        EnergyQuantityUnit2Code unit = this.doEvaluate(deliveryCapacity);
        return unit;
    }

    protected abstract EnergyQuantityUnit2Code doEvaluate(Quantity var1);

    public static class GetDeliveryCapacityUnitDefault
    extends GetDeliveryCapacityUnit {
        @Override
        protected EnergyQuantityUnit2Code doEvaluate(Quantity deliveryCapacity) {
            EnergyQuantityUnit2Code unit = null;
            return this.assignOutput(unit, deliveryCapacity);
        }

        protected EnergyQuantityUnit2Code assignOutput(EnergyQuantityUnit2Code unit, Quantity deliveryCapacity) {
            unit = (EnergyQuantityUnit2Code)((Object)MapperS.of((Object)this.quantityToDeliveryCapacity.evaluate(deliveryCapacity)).map("getUnit", _deliveryCapacity -> _deliveryCapacity.getUnit()).get());
            return unit;
        }
    }
}

