/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.CalculationPeriodToDays;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=InterestRateLeg1FixedFixedDefault.class)
public abstract class InterestRateLeg1FixedFixed
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CalculationPeriodToDays calculationPeriodToDays;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;

    public InterestRatePayout evaluate(Product product) {
        InterestRatePayout interestRateLeg1;
        InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1Builder = this.doEvaluate(product);
        if (interestRateLeg1Builder == null) {
            interestRateLeg1 = null;
        } else {
            interestRateLeg1 = interestRateLeg1Builder.build();
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)interestRateLeg1);
        }
        return interestRateLeg1;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> interestRatePayouts(Product var1);

    protected abstract MapperS<Boolean> isSameRate(Product var1);

    protected abstract MapperS<Boolean> isSamePeriod(Product var1);

    public static class InterestRateLeg1FixedFixedDefault
    extends InterestRateLeg1FixedFixed {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
            InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1 = InterestRatePayout.builder();
            return this.assignOutput(interestRateLeg1, product);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1, Product product) {
            interestRateLeg1 = ExpressionOperatorsNullSafe.areEqual(this.isSameRate(product), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRatePayouts(product).max(item -> item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate()).map("getRateSchedule", fixedRateSpecification -> fixedRateSpecification.getRateSchedule()).map("getPrice", rateSchedule -> rateSchedule.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue())).get()) : (ExpressionOperatorsNullSafe.areEqual(this.isSamePeriod(product), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRatePayouts(product).min(item -> MapperS.of((Object)this.calculationPeriodToDays.evaluate((InterestRatePayout)item.get()))).get()) : (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRatePayouts(product).first().get()));
            return Optional.ofNullable(interestRateLeg1).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends InterestRatePayout> interestRatePayouts(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
        }

        @Override
        protected MapperS<Boolean> isSameRate(Product product) {
            return ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)ExpressionOperatorsNullSafe.distinct((Mapper)this.interestRatePayouts(product).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate()).map("getRateSchedule", fixedRateSpecification -> fixedRateSpecification.getRateSchedule()).map("getPrice", rateSchedule -> rateSchedule.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).asMapper();
        }

        @Override
        protected MapperS<Boolean> isSamePeriod(Product product) {
            MapperC thenArg = this.interestRatePayouts(product).mapItem(item -> MapperS.of((Object)this.calculationPeriodToDays.evaluate((InterestRatePayout)item.get())));
            return ExpressionOperatorsNullSafe.notExists((Mapper)this.interestRatePayouts(product).map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates())).orNullSafe(ComparisonResult.ofNullSafe((Mapper)ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)ExpressionOperatorsNullSafe.distinct((Mapper)thenArg).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).asMapper())).asMapper();
        }
    }
}

