/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.ReportableInformationBase;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=LastAvailableSpotPriceDefault.class)
public abstract class LastAvailableSpotPrice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public PriceSchedule evaluate(ReportableInformationBase reportableInformation) {
        PriceSchedule lastAvailableSpotPrice;
        PriceSchedule.PriceScheduleBuilder lastAvailableSpotPriceBuilder = this.doEvaluate(reportableInformation);
        if (lastAvailableSpotPriceBuilder == null) {
            lastAvailableSpotPrice = null;
        } else {
            lastAvailableSpotPrice = lastAvailableSpotPriceBuilder.build();
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)lastAvailableSpotPrice);
        }
        return lastAvailableSpotPrice;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(ReportableInformationBase var1);

    public static class LastAvailableSpotPriceDefault
    extends LastAvailableSpotPrice {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(ReportableInformationBase reportableInformation) {
            PriceSchedule.PriceScheduleBuilder lastAvailableSpotPrice = PriceSchedule.builder();
            return this.assignOutput(lastAvailableSpotPrice, reportableInformation);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder lastAvailableSpotPrice, ReportableInformationBase reportableInformation) {
            lastAvailableSpotPrice = (PriceSchedule.PriceScheduleBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)reportableInformation).map("getUnderlyingAssetLastAvailableSpotPrice", reportableInformationBase -> reportableInformationBase.getUnderlyingAssetLastAvailableSpotPrice()).get());
            return Optional.ofNullable(lastAvailableSpotPrice).map(o -> o.prune()).orElse(null);
        }
    }
}

