/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.party.Party;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=RegimePartySupervisoryBodyDefault.class)
public abstract class RegimePartySupervisoryBody
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends Party> evaluate(List<? extends RegimePartyInformation> regimePartyInformation, SupervisoryBodyEnum supervisoryBody) {
        List partyReference;
        List<Party.PartyBuilder> partyReferenceBuilder = this.doEvaluate(regimePartyInformation, supervisoryBody);
        if (partyReferenceBuilder == null) {
            partyReference = null;
        } else {
            partyReference = partyReferenceBuilder.stream().map(Party::build).collect(Collectors.toList());
            this.objectValidator.validate(Party.class, partyReference);
        }
        return partyReference;
    }

    protected abstract List<Party.PartyBuilder> doEvaluate(List<? extends RegimePartyInformation> var1, SupervisoryBodyEnum var2);

    public static class RegimePartySupervisoryBodyDefault
    extends RegimePartySupervisoryBody {
        @Override
        protected List<Party.PartyBuilder> doEvaluate(List<? extends RegimePartyInformation> regimePartyInformation, SupervisoryBodyEnum supervisoryBody) {
            if (regimePartyInformation == null) {
                regimePartyInformation = Collections.emptyList();
            }
            ArrayList<Party.PartyBuilder> partyReference = new ArrayList<Party.PartyBuilder>();
            return this.assignOutput(partyReference, regimePartyInformation, supervisoryBody);
        }

        protected List<Party.PartyBuilder> assignOutput(List<Party.PartyBuilder> partyReference, List<? extends RegimePartyInformation> regimePartyInformation, SupervisoryBodyEnum supervisoryBody) {
            MapperC thenArg0 = MapperC.of(regimePartyInformation);
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.mapC("getRegimeInformation", _regimePartyInformation -> _regimePartyInformation.getRegimeInformation()).map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum.getValue()), (Mapper)MapperS.of((Object)((Object)supervisoryBody)), (CardinalityOperator)CardinalityOperator.Any).get());
            partyReference = this.toBuilder(thenArg1.mapItem(item -> item.map("getPartyReference", _regimePartyInformation -> _regimePartyInformation.getPartyReference())).map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty.getValue()).getMulti());
            return Optional.ofNullable(partyReference).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

