/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.processor;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.translation.SynonymToEnumMap;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.CorporateSector;
import drr.regulation.common.FinancialSectorEnum;
import drr.regulation.common.NonFinancialSector;
import drr.regulation.common.NonFinancialSectorEnum;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TechnicalRecordId;
import drr.regulation.common.metafields.FieldWithMetaRegimeNameEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegimeInformationMappingProcessor
extends MappingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegimeInformationMappingProcessor.class);
    private static final String ESMA_CORPORATE_SECTOR_SCHEME = "http://www.fpml.org/coding-scheme/esma-emir-refit-regulatory-corporate-sector";
    private static final String HKMA_CORPORATE_SECTOR_SCHEME = "http://www.fpml.org/coding-scheme/hkma-rewrite-regulatory-corporate-sector";
    private static final String CFTC_ORGANIZATION_TYPE_SCHEME = "http://www.fpml.org/coding-scheme/cftc-organization-type";
    private final SynonymToEnumMap synonymToEnumMap = this.getContext().getSynonymToEnumMap();

    public RegimeInformationMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builders, RosettaModelObjectBuilder parent) {
        RegimePartyInformation.RegimePartyInformationBuilder regimePartyInformationBuilder = (RegimePartyInformation.RegimePartyInformationBuilder)parent;
        List<? extends RosettaModelObjectBuilder> reportingRegimeBuilders = builders;
        List<Path> classificationPaths = this.getPartyPaths(regimePartyInformationBuilder, "classification");
        this.setCorporateSector(reportingRegimeBuilders, classificationPaths, SupervisoryBodyEnum.ESMA, ESMA_CORPORATE_SECTOR_SCHEME);
        this.setCorporateSector(reportingRegimeBuilders, classificationPaths, SupervisoryBodyEnum.FCA, ESMA_CORPORATE_SECTOR_SCHEME);
        this.setCorporateSector(reportingRegimeBuilders, classificationPaths, SupervisoryBodyEnum.HKMA, HKMA_CORPORATE_SECTOR_SCHEME);
        List<Path> organizationTypePaths = this.getPartyPaths(regimePartyInformationBuilder, "organizationType");
        this.setTechnicalRecordId(reportingRegimeBuilders);
    }

    private void setCorporateSector(List<ReportingRegime.ReportingRegimeBuilder> reportingRegimeBuilders, List<Path> classificationPaths, SupervisoryBodyEnum supervisoryBody, String corporateSectorScheme) {
        reportingRegimeBuilders.stream().filter(b -> this.isSupervisoryBody((ReportingRegime.ReportingRegimeBuilder)b, supervisoryBody)).findFirst().ifPresent(reportingRegimeBuilder -> {
            for (Path classificationPath : classificationPaths) {
                MappingProcessorUtils.getNonNullMappedValue((Path)classificationPath.addElement("industryClassificationScheme"), (List)this.getMappings()).filter(corporateSectorScheme::equals).ifPresent(industryClassificationScheme -> MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)classificationPath, classificationValue -> {
                    CorporateSector.CorporateSectorBuilder corporateSectorBuilder = CorporateSector.builder();
                    this.getFinancialSectorEnum((String)classificationValue).ifPresent(corporateSectorBuilder::addFinancialSector);
                    this.getNonFinancialSector((String)classificationValue).ifPresent(corporateSectorBuilder::addNonFinancialSector);
                    if (corporateSectorBuilder.hasData()) {
                        this.updateCorporateSectorForRegime((ReportingRegime.ReportingRegimeBuilder)reportingRegimeBuilder, corporateSectorBuilder);
                        return true;
                    }
                    return false;
                }, (List)this.getMappings(), (RosettaPath)this.getModelPath()));
            }
        });
    }

    private Boolean isFederalEntityScheme(Path organizationTypePath) {
        return MappingProcessorUtils.getNonNullMappedValue((Path)organizationTypePath.addElement("organizationTypeScheme"), (List)this.getMappings()).map(CFTC_ORGANIZATION_TYPE_SCHEME::equals).orElse(false);
    }

    private void setTechnicalRecordId(List<ReportingRegime.ReportingRegimeBuilder> reportingRegimeBuilders) {
        List messageIdSchemePaths = this.getMappings().stream().map(Mapping::getXmlPath).filter(xmlPath -> xmlPath.endsWith(new String[]{"messageIdScheme"})).collect(Collectors.toList());
        for (Path messageIdSchemePath : messageIdSchemePaths) {
            Optional mappedValue = MappingProcessorUtils.getNonNullMappedValue((Path)messageIdSchemePath, (List)this.getMappings());
            if (!mappedValue.isPresent() || !((String)mappedValue.get()).equals("http://www.fpml.org/coding-scheme/external/technical-record-id")) continue;
            Path messageIdPath = messageIdSchemePath.getParent();
            Optional messageId = MappingProcessorUtils.getNonNullMappedValue((Path)messageIdPath, (List)this.getMappings());
            messageId.ifPresent(id -> {
                TechnicalRecordId.TechnicalRecordIdBuilder technicalRecordId = TechnicalRecordId.builder().setId(FieldWithMetaString.builder().setValue((String)id));
                reportingRegimeBuilders.stream().filter(this::isRelevantSupervisoryBody).forEach(reportingRegimeBuilder -> reportingRegimeBuilder.setTechnicalRecordId(technicalRecordId));
            });
        }
    }

    private boolean isRelevantSupervisoryBody(ReportingRegime.ReportingRegimeBuilder reportingRegimeBuilder) {
        FieldWithMetaSupervisoryBodyEnum.FieldWithMetaSupervisoryBodyEnumBuilder supervisoryBodyField = reportingRegimeBuilder.getSupervisoryBody();
        if (supervisoryBodyField != null) {
            SupervisoryBodyEnum supervisoryBodyEnum = supervisoryBodyField.getValue();
            return supervisoryBodyEnum == SupervisoryBodyEnum.ASIC || supervisoryBodyEnum == SupervisoryBodyEnum.JFSA || supervisoryBodyEnum == SupervisoryBodyEnum.MAS;
        }
        return false;
    }

    private boolean isSupervisoryBody(ReportingRegime.ReportingRegimeBuilder reportingRegime, SupervisoryBodyEnum supervisoryBody) {
        return Optional.ofNullable(reportingRegime.getSupervisoryBody()).map(FieldWithMetaSupervisoryBodyEnum::getValue).map(supervisoryBody::equals).orElse(false);
    }

    private boolean isRegimeName(ReportingRegime.ReportingRegimeBuilder reportingRegime, RegimeNameEnum regimeName) {
        return Optional.ofNullable(reportingRegime.getRegimeName()).map(FieldWithMetaRegimeNameEnum::getValue).map(regimeName::equals).orElse(false);
    }

    private List<Path> getPartyPaths(RegimePartyInformation.RegimePartyInformationBuilder regimePartyInformationBuilder, String partyAttribute) {
        return Optional.ofNullable(regimePartyInformationBuilder.getPartyReference()).map(ReferenceWithMetaParty::getExternalReference).map(partyReference -> this.getPathsForParty((String)partyReference, partyAttribute)).orElse(Collections.emptyList());
    }

    private List<Path> getPathsForParty(String partyReference, String partyAttribute) {
        ArrayList<Path> paths = new ArrayList<Path>();
        Optional<Path> partyPath = this.getPartyPath(partyReference, "party", "id");
        partyPath.ifPresent(path -> {
            String partyPathStr = path.toString();
            for (Mapping mapping : this.getMappings()) {
                Path xmlPath = mapping.getXmlPath();
                if (mapping.getXmlValue() == null || xmlPath == null || !xmlPath.toString().startsWith(partyPathStr) || !xmlPath.endsWith(new String[]{partyAttribute})) continue;
                paths.add(xmlPath);
            }
        });
        return paths;
    }

    private Optional<Path> getPartyPath(String xmlValue, String ... xmlPathEndsWith) {
        return this.getMappings().stream().filter(m -> m.getXmlPath().endsWith(xmlPathEndsWith)).filter(m -> {
            Object xmlValueObj = m.getXmlValue();
            String xmlValueStr = xmlValueObj != null ? xmlValueObj.toString() : null;
            return Objects.equals(xmlValueStr, xmlValue);
        }).map(Mapping::getXmlPath).map(Path::getParent).findFirst();
    }

    private void updateCorporateSectorForRegime(ReportingRegime.ReportingRegimeBuilder reportingRegimeBuilder, CorporateSector.CorporateSectorBuilder corporateSectorBuilder) {
        SupervisoryBodyEnum supervisoryBody = reportingRegimeBuilder.getSupervisoryBody().getValue();
        switch (supervisoryBody) {
            case ESMA: {
                reportingRegimeBuilder.getOrCreateEsmaPartyInformation().setCorporateSector(corporateSectorBuilder);
                break;
            }
            case FCA: {
                reportingRegimeBuilder.getOrCreateFcaPartyInformation().setCorporateSector(corporateSectorBuilder);
                break;
            }
            case HKMA: {
                reportingRegimeBuilder.getOrCreateHkmaPartyInformation().setCorporateSector(corporateSectorBuilder);
                break;
            }
            default: {
                throw new RuntimeException("Cannot updated corporate sector, unexpected supervisoryBody " + String.valueOf((Object)supervisoryBody));
            }
        }
    }

    private Optional<FinancialSectorEnum> getFinancialSectorEnum(String value) {
        try {
            return Optional.of(FinancialSectorEnum.valueOf(value));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private Optional<NonFinancialSector> getNonFinancialSector(String value) {
        try {
            return Optional.of(NonFinancialSectorEnum.valueOf(value)).map(e -> NonFinancialSector.builder().setNonFinancialSectorIndicator((NonFinancialSectorEnum)((Object)e)).setOrdinal(e.ordinal() + 1));
        }
        catch (IllegalArgumentException e2) {
            return Optional.empty();
        }
    }
}

