/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.contract.reports;

import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_AssetClass_ForeignExchange;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.product.functions.IsSingleCommodityPayoutProduct;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.common.CommonAssetClass;
import javax.inject.Inject;

@ImplementedBy(value=AssetClassRuleDefault.class)
public abstract class AssetClassRule
implements ReportFunction<ReportableEventBase, CommonAssetClass> {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
    @Inject
    protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
    @Inject
    protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
    @Inject
    protected Qualify_AssetClass_ForeignExchange qualify_AssetClass_ForeignExchange;
    @Inject
    protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;

    public CommonAssetClass evaluate(ReportableEventBase input) {
        CommonAssetClass output = this.doEvaluate(input);
        return output;
    }

    protected abstract CommonAssetClass doEvaluate(ReportableEventBase var1);

    public static class AssetClassRuleDefault
    extends AssetClassRule {
        @Override
        protected CommonAssetClass doEvaluate(ReportableEventBase input) {
            CommonAssetClass output = null;
            return this.assignOutput(output, input);
        }

        protected CommonAssetClass assignOutput(CommonAssetClass output, ReportableEventBase input) {
            MapperS thenArg = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEventBase)item.get())));
            output = (CommonAssetClass)((Object)thenArg.mapSingleToItem(item -> {
                Boolean boolean0 = this.qualify_AssetClass_InterestRate.evaluate(this.economicTermsForProduct.evaluate((Product)item.get()));
                if (boolean0 != null && boolean0.booleanValue()) {
                    return MapperS.of((Object)((Object)CommonAssetClass.INTR));
                }
                Boolean boolean1 = this.qualify_AssetClass_Credit.evaluate(this.economicTermsForProduct.evaluate((Product)item.get()));
                if (boolean1 != null && boolean1.booleanValue()) {
                    return MapperS.of((Object)((Object)CommonAssetClass.CRDT));
                }
                Boolean boolean2 = this.qualify_AssetClass_Equity.evaluate(this.economicTermsForProduct.evaluate((Product)item.get()));
                if (boolean2 != null && boolean2.booleanValue()) {
                    return MapperS.of((Object)((Object)CommonAssetClass.EQUI));
                }
                if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_AssetClass_Commodity.evaluate(this.economicTermsForProduct.evaluate((Product)item.get())))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isSingleCommodityPayoutProduct.evaluate((Product)item.get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)CommonAssetClass.COMM));
                }
                Boolean boolean3 = this.qualify_AssetClass_ForeignExchange.evaluate(this.economicTermsForProduct.evaluate((Product)item.get()));
                if (boolean3 != null && boolean3.booleanValue()) {
                    return MapperS.of((Object)((Object)CommonAssetClass.CURR));
                }
                return MapperS.ofNull();
            }).get());
            return output;
        }
    }
}

