/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.link.reports;

import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.TradeIdentifier;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.qualification.event.functions.IsActionTypeNEWT;
import drr.base.qualification.event.functions.IsCleared;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.functions.BeforeTradeForEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version3.event.reports.EventTypeRule;
import drr.standards.iso.EventTypeEnum;
import javax.inject.Inject;

@ImplementedBy(value=OriginalSwapUSIRuleDefault.class)
public abstract class OriginalSwapUSIRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected BeforeTradeForEvent beforeTradeForEvent;
    @Inject
    protected EventTypeRule eventTypeRule;
    @Inject
    protected IsActionTypeNEWT isActionTypeNEWT;
    @Inject
    protected IsCleared isCleared;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class OriginalSwapUSIRuleDefault
    extends OriginalSwapUSIRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.isCleared.evaluate((WorkflowStep)item.map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.isActionTypeNEWT.evaluate((ReportableEventBase)item.get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)this.eventTypeRule.evaluate((TransactionReportInstructionBase)item.get()))), (Mapper)MapperS.of((Object)((Object)EventTypeEnum.CLRG)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.beforeTradeForEvent.evaluate((ReportableEventBase)item.get()));
                }
                return MapperS.ofNull();
            });
            MapperC thenArg1 = thenArg0.mapSingleToList(item -> item.mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier()));
            MapperC thenArg2 = thenArg1.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getIdentifierType", tradeIdentifier -> tradeIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)TradeIdentifierTypeEnum.UNIQUE_SWAP_IDENTIFIER), (CardinalityOperator)CardinalityOperator.All).get());
            MapperS thenArg3 = MapperS.of((Object)((TradeIdentifier)thenArg2.get()));
            MapperC thenArg4 = thenArg3.mapSingleToList(item -> item.mapC("getAssignedIdentifier", tradeIdentifier -> tradeIdentifier.getAssignedIdentifier()).map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()));
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)thenArg4.last().get();
            output = fieldWithMetaString == null ? null : fieldWithMetaString.getValue();
            return output;
        }
    }
}

