/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.link.reports;

import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.TradeIdentifier;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.event.functions.IsActionTypeNEWT;
import drr.base.qualification.event.functions.IsCleared;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.functions.BeforeTradeForEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.version3.event.reports.EventTypeRule;
import drr.standards.iso.EventTypeEnum;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=OriginalSwapUTIRuleDefault.class)
public abstract class OriginalSwapUTIRule
implements ReportFunction<TransactionReportInstruction, List<String>> {
    @Inject
    protected BeforeTradeForEvent beforeTradeForEvent;
    @Inject
    protected EventTypeRule eventTypeRule;
    @Inject
    protected IsActionTypeNEWT isActionTypeNEWT;
    @Inject
    protected IsCleared isCleared;

    public List<String> evaluate(TransactionReportInstruction input) {
        List<String> output = this.doEvaluate(input);
        return output;
    }

    protected abstract List<String> doEvaluate(TransactionReportInstruction var1);

    public static class OriginalSwapUTIRuleDefault
    extends OriginalSwapUTIRule {
        @Override
        protected List<String> doEvaluate(TransactionReportInstruction input) {
            ArrayList<String> output = new ArrayList<String>();
            return this.assignOutput(output, input);
        }

        protected List<String> assignOutput(List<String> output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.isCleared.evaluate((WorkflowStep)item.map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.isActionTypeNEWT.evaluate((ReportableEventBase)item.get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)this.eventTypeRule.evaluate((TransactionReportInstructionBase)item.get()))), (Mapper)MapperS.of((Object)((Object)EventTypeEnum.CLRG)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.beforeTradeForEvent.evaluate((ReportableEventBase)item.get()));
                }
                return MapperS.ofNull();
            });
            MapperC thenArg1 = thenArg0.mapSingleToList(item -> item.mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier()));
            MapperC thenArg2 = thenArg1.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getIdentifierType", tradeIdentifier -> tradeIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER), (CardinalityOperator)CardinalityOperator.All).get());
            MapperS thenArg3 = MapperS.of((Object)((TradeIdentifier)thenArg2.get()));
            output = thenArg3.mapSingleToList(item -> item.mapC("getAssignedIdentifier", tradeIdentifier -> tradeIdentifier.getAssignedIdentifier()).map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier())).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti();
            return output;
        }
    }
}

