/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.price;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.PriceNotationEnum;
import drr.regulation.common.trade.price.meta.BarrierPriceMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="BarrierPrice", builder=BarrierPriceBuilderImpl.class, version="7.0.0-dev.101")
@RuneDataType(value="BarrierPrice", model="drr", builder=BarrierPriceBuilderImpl.class, version="7.0.0-dev.101")
public interface BarrierPrice
extends RosettaModelObject {
    public static final BarrierPriceMeta metaData = new BarrierPriceMeta();

    public PriceFormat getPrice();

    public PriceNotationEnum getNotation();

    public ISOCurrencyCodeEnum getCurrency();

    public BarrierPrice build();

    public BarrierPriceBuilder toBuilder();

    public static BarrierPriceBuilder builder() {
        return new BarrierPriceBuilderImpl();
    }

    default public RosettaMetaData<? extends BarrierPrice> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BarrierPrice> getType() {
        return BarrierPrice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("price"), processor, PriceFormat.class, this.getPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notation"), PriceNotationEnum.class, (Object)this.getNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currency"), ISOCurrencyCodeEnum.class, (Object)this.getCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class BarrierPriceBuilderImpl
    implements BarrierPriceBuilder {
        protected PriceFormat.PriceFormatBuilder price;
        protected PriceNotationEnum notation;
        protected ISOCurrencyCodeEnum currency;

        @Override
        @RosettaAttribute(value="price", isRequired=true)
        @RuneAttribute(value="price", isRequired=true)
        public PriceFormat.PriceFormatBuilder getPrice() {
            return this.price;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreatePrice() {
            PriceFormat.PriceFormatBuilder result = this.price != null ? this.price : (this.price = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notation", isRequired=true)
        @RuneAttribute(value="notation", isRequired=true)
        public PriceNotationEnum getNotation() {
            return this.notation;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public ISOCurrencyCodeEnum getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="price", isRequired=true)
        @RuneAttribute(value="price", isRequired=true)
        public BarrierPriceBuilder setPrice(PriceFormat _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notation", isRequired=true)
        @RuneAttribute(value="notation", isRequired=true)
        public BarrierPriceBuilder setNotation(PriceNotationEnum _notation) {
            this.notation = _notation == null ? null : _notation;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public BarrierPriceBuilder setCurrency(ISOCurrencyCodeEnum _currency) {
            this.currency = _currency == null ? null : _currency;
            return this;
        }

        @Override
        public BarrierPrice build() {
            return new BarrierPriceImpl(this);
        }

        @Override
        public BarrierPriceBuilder toBuilder() {
            return this;
        }

        @Override
        public BarrierPriceBuilder prune() {
            if (this.price != null && !this.price.prune().hasData()) {
                this.price = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPrice() != null && this.getPrice().hasData()) {
                return true;
            }
            if (this.getNotation() != null) {
                return true;
            }
            return this.getCurrency() != null;
        }

        public BarrierPriceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BarrierPriceBuilder o = (BarrierPriceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrice(), (RosettaModelObjectBuilder)o.getPrice(), this::setPrice);
            merger.mergeBasic((Object)this.getNotation(), (Object)o.getNotation(), this::setNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrency(), (Object)o.getCurrency(), this::setCurrency, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BarrierPrice _that = this.getType().cast(o);
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.notation, (Object)_that.getNotation())) {
                return false;
            }
            return Objects.equals(this.currency, _that.getCurrency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.notation != null ? ((Object)((Object)this.notation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BarrierPriceBuilder {price=" + String.valueOf(this.price) + ", notation=" + String.valueOf((Object)this.notation) + ", currency=" + String.valueOf(this.currency) + "}";
        }
    }

    public static interface BarrierPriceBuilder
    extends BarrierPrice,
    RosettaModelObjectBuilder {
        public PriceFormat.PriceFormatBuilder getOrCreatePrice();

        @Override
        public PriceFormat.PriceFormatBuilder getPrice();

        public BarrierPriceBuilder setPrice(PriceFormat var1);

        public BarrierPriceBuilder setNotation(PriceNotationEnum var1);

        public BarrierPriceBuilder setCurrency(ISOCurrencyCodeEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, this.getPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notation"), PriceNotationEnum.class, (Object)this.getNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currency"), ISOCurrencyCodeEnum.class, (Object)this.getCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public BarrierPriceBuilder prune();
    }

    public static class BarrierPriceImpl
    implements BarrierPrice {
        private final PriceFormat price;
        private final PriceNotationEnum notation;
        private final ISOCurrencyCodeEnum currency;

        protected BarrierPriceImpl(BarrierPriceBuilder builder) {
            this.price = Optional.ofNullable(builder.getPrice()).map(f -> f.build()).orElse(null);
            this.notation = builder.getNotation();
            this.currency = builder.getCurrency();
        }

        @Override
        @RosettaAttribute(value="price", isRequired=true)
        @RuneAttribute(value="price", isRequired=true)
        public PriceFormat getPrice() {
            return this.price;
        }

        @Override
        @RosettaAttribute(value="notation", isRequired=true)
        @RuneAttribute(value="notation", isRequired=true)
        public PriceNotationEnum getNotation() {
            return this.notation;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public ISOCurrencyCodeEnum getCurrency() {
            return this.currency;
        }

        @Override
        public BarrierPrice build() {
            return this;
        }

        @Override
        public BarrierPriceBuilder toBuilder() {
            BarrierPriceBuilder builder = BarrierPrice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BarrierPriceBuilder builder) {
            Optional.ofNullable(this.getPrice()).ifPresent(builder::setPrice);
            Optional.ofNullable(this.getNotation()).ifPresent(builder::setNotation);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BarrierPrice _that = this.getType().cast(o);
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.notation, (Object)_that.getNotation())) {
                return false;
            }
            return Objects.equals(this.currency, _that.getCurrency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.notation != null ? ((Object)((Object)this.notation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BarrierPrice {price=" + String.valueOf(this.price) + ", notation=" + String.valueOf((Object)this.notation) + ", currency=" + String.valueOf(this.currency) + "}";
        }
    }
}

