/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.price.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.reports.PayoutForQuantityLeg1Rule;
import drr.regulation.common.trade.reports.PayoutLeg1Rule;
import drr.standards.iosco.cde.version3.execution.reports.SettlementCurrencyRule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalCurrencyRule;
import javax.inject.Inject;

@ImplementedBy(value=OptionPremiumCurrencyRuleDefault.class)
public abstract class OptionPremiumCurrencyRule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected NotionalCurrencyRule notionalCurrencyRule;
    @Inject
    protected drr.standards.iosco.cde.version3.price.reports.OptionPremiumCurrencyRule optionPremiumCurrencyRule;
    @Inject
    protected PayoutForQuantityLeg1Rule payoutForQuantityLeg1Rule;
    @Inject
    protected PayoutLeg1Rule payoutLeg1Rule;
    @Inject
    protected SettlementCurrencyRule settlementCurrencyRule;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class OptionPremiumCurrencyRuleDefault
    extends OptionPremiumCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            output = (ISOCurrencyCodeEnum)MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)((ISOCurrencyCodeEnum)MapperS.of((Object)this.optionPremiumCurrencyRule.evaluate((TransactionReportInstructionBase)item.get())).getOrDefault((Object)this.settlementCurrencyRule.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)item.get())))))).getOrDefault((Object)this.notionalCurrencyRule.evaluate(this.payoutForQuantityLeg1Rule.evaluate(input)));
            return output;
        }
    }
}

