/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.quantity.functions;

import cdm.base.datetime.CalculationPeriodFrequency;
import cdm.base.datetime.Frequency;
import cdm.base.datetime.PeriodExtendedEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.regulation.common.trade.quantity.QuantityFrequency;
import drr.regulation.common.trade.quantity.functions.CommodityQuantityWithFrequency;
import drr.standards.iso.FrequencyPeriodEnum;
import drr.standards.iso.functions.ConvertPeriodtoISOFrequencyPeriod;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=QuantityFrequencyDefault.class)
public abstract class QuantityFrequency
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityQuantityWithFrequency commodityQuantityWithFrequency;
    @Inject
    protected ConvertPeriodtoISOFrequencyPeriod convertPeriodtoISOFrequencyPeriod;

    public drr.regulation.common.trade.quantity.QuantityFrequency evaluate(PayoutLegWithAuxiliary payout) {
        drr.regulation.common.trade.quantity.QuantityFrequency quantityFrequency;
        QuantityFrequency.QuantityFrequencyBuilder quantityFrequencyBuilder = this.doEvaluate(payout);
        if (quantityFrequencyBuilder == null) {
            quantityFrequency = null;
        } else {
            quantityFrequency = quantityFrequencyBuilder.build();
            this.objectValidator.validate(drr.regulation.common.trade.quantity.QuantityFrequency.class, (RosettaModelObject)quantityFrequency);
        }
        return quantityFrequency;
    }

    protected abstract QuantityFrequency.QuantityFrequencyBuilder doEvaluate(PayoutLegWithAuxiliary var1);

    protected abstract MapperS<? extends Frequency> frequencyPeriod(PayoutLegWithAuxiliary var1);

    protected abstract MapperS<? extends CalculationPeriodFrequency> calculationPeriodFrequency(PayoutLegWithAuxiliary var1);

    public static class QuantityFrequencyDefault
    extends QuantityFrequency {
        @Override
        protected QuantityFrequency.QuantityFrequencyBuilder doEvaluate(PayoutLegWithAuxiliary payout) {
            QuantityFrequency.QuantityFrequencyBuilder quantityFrequency = drr.regulation.common.trade.quantity.QuantityFrequency.builder();
            return this.assignOutput(quantityFrequency, payout);
        }

        protected QuantityFrequency.QuantityFrequencyBuilder assignOutput(QuantityFrequency.QuantityFrequencyBuilder quantityFrequency, PayoutLegWithAuxiliary payout) {
            if (ExpressionOperatorsNullSafe.exists(this.frequencyPeriod(payout)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)this.frequencyPeriod(payout).map("getPeriod", frequency -> frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.C), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperS thenArg = MapperS.of((Object)((Object)this.convertPeriodtoISOFrequencyPeriod.evaluate((PeriodExtendedEnum)this.calculationPeriodFrequency(payout).map("getPeriod", _calculationPeriodFrequency -> _calculationPeriodFrequency.getPeriod()).get())));
                quantityFrequency = (QuantityFrequency.QuantityFrequencyBuilder)this.toBuilder(drr.regulation.common.trade.quantity.QuantityFrequency.builder().setPeriod((FrequencyPeriodEnum)((Object)MapperS.of((Object)((Object)((FrequencyPeriodEnum)((Object)thenArg.getOrDefault((Object)FrequencyPeriodEnum.ADHO))))).get())).setPeriodMultiplier((Integer)this.calculationPeriodFrequency(payout).map("getPeriodMultiplier", _calculationPeriodFrequency -> _calculationPeriodFrequency.getPeriodMultiplier()).get()).build());
            } else {
                quantityFrequency = ExpressionOperatorsNullSafe.exists(this.frequencyPeriod(payout)).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)this.frequencyPeriod(payout).map("getPeriod", frequency -> frequency.getPeriod()), (Mapper)MapperS.of((Object)PeriodExtendedEnum.C), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)) != false ? (QuantityFrequency.QuantityFrequencyBuilder)this.toBuilder(drr.regulation.common.trade.quantity.QuantityFrequency.builder().setPeriod(this.convertPeriodtoISOFrequencyPeriod.evaluate((PeriodExtendedEnum)this.frequencyPeriod(payout).map("getPeriod", frequency -> frequency.getPeriod()).get())).setPeriodMultiplier((Integer)this.frequencyPeriod(payout).map("getPeriodMultiplier", frequency -> frequency.getPeriodMultiplier()).get()).build()) : null;
            }
            return Optional.ofNullable(quantityFrequency).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends Frequency> frequencyPeriod(PayoutLegWithAuxiliary payout) {
            return MapperS.of((Object)this.commodityQuantityWithFrequency.evaluate(payout)).map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency());
        }

        @Override
        protected MapperS<? extends CalculationPeriodFrequency> calculationPeriodFrequency(PayoutLegWithAuxiliary payout) {
            MapperS thenArg0 = MapperS.of((Object)payout).map("getCommodityPayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getCommodityPayout()).map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).map("getCalculationPeriodFrequency", calculationPeriodDates -> calculationPeriodDates.getCalculationPeriodFrequency());
            MapperS thenArg1 = MapperS.of((Object)((CalculationPeriodFrequency)thenArg0.getOrDefault((Object)((CalculationPeriodFrequency)MapperS.of((Object)payout).map("getOptionPayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getOptionPayout()).map("getObservationTerms", optionPayout -> optionPayout.getObservationTerms()).map("getCalculationPeriodDates", observationTerms -> observationTerms.getCalculationPeriodDates()).map("getCalculationPeriodFrequency", calculationPeriodDates -> calculationPeriodDates.getCalculationPeriodFrequency()).get()))));
            return MapperS.of((Object)((CalculationPeriodFrequency)thenArg1.getOrDefault((Object)((CalculationPeriodFrequency)MapperS.of((Object)payout).map("getAuxiliaryLeg", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getAuxiliaryLeg()).map("getCommodityPayout", payoutLeg -> payoutLeg.getCommodityPayout()).map("getCalculationPeriodDates", commodityPayout -> commodityPayout.getCalculationPeriodDates()).map("getCalculationPeriodFrequency", calculationPeriodDates -> calculationPeriodDates.getCalculationPeriodFrequency()).get()))));
        }
    }
}

