/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.quantity.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.regulation.common.trade.quantity.functions.CommodityQuantityWithFrequency;
import drr.regulation.common.trade.quantity.reports.EquityNotionalQuantityRule;
import drr.standards.iso.functions.FormatToShortFraction5DecimalNumber;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=NotionalQuantityRuleDefault.class)
public abstract class NotionalQuantityRule
implements ReportFunction<PayoutLegWithAuxiliary, BigDecimal> {
    @Inject
    protected CommodityQuantityWithFrequency commodityQuantityWithFrequency;
    @Inject
    protected EquityNotionalQuantityRule equityNotionalQuantityRule;
    @Inject
    protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;

    public BigDecimal evaluate(PayoutLegWithAuxiliary input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(PayoutLegWithAuxiliary var1);

    public static class NotionalQuantityRuleDefault
    extends NotionalQuantityRule {
        @Override
        protected BigDecimal doEvaluate(PayoutLegWithAuxiliary input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, PayoutLegWithAuxiliary input) {
            MapperS thenArg0 = MapperS.of((Object)this.commodityQuantityWithFrequency.evaluate(input));
            MapperS thenArg1 = MapperS.of((Object)((BigDecimal)MapperS.of((Object)this.equityNotionalQuantityRule.evaluate(input)).getOrDefault((Object)((BigDecimal)MapperS.of((Object)((BigDecimal)thenArg0.map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).getOrDefault((Object)((BigDecimal)thenArg0.mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).map("getValue", datedValue -> datedValue.getValue()).first().get())))).get()))));
            output = (BigDecimal)MapperS.of((Object)this.formatToShortFraction5DecimalNumber.evaluate((BigDecimal)thenArg1.get())).get();
            return output;
        }
    }
}

